/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.progress;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.openthinclient.progress.AbstractProgressReceiver;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.progress.ProgressTask;
import org.openthinclient.progress.Registration;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public class ProgressManager<V> {
    private final ProgressTask<V> task;
    private final List<ProgressReceiver> receivers;
    private Consumer<ProgressManager<V>> taskActivationHandler;
    private Consumer<ProgressManager<V>> taskFinalizationHandler;
    private ListenableProgressFuture<V> future;
    private volatile State state;
    private volatile String lastProgressMessage = "";
    private volatile double lastProgressValue = -1.0;

    public ProgressManager(ProgressTask<V> task) {
        this.task = task;
        this.state = State.QUEUED;
        this.receivers = new CopyOnWriteArrayList<ProgressReceiver>();
    }

    public State getState() {
        return this.state;
    }

    public ProgressReceiver receiver() {
        return new AbstractProgressReceiver(){

            @Override
            public void progress(String message, double progress) {
                ProgressManager.this.lastProgressMessage = message;
                ProgressManager.this.lastProgressValue = progress;
                ProgressManager.this.receivers.forEach(receiver -> receiver.progress(message, progress));
            }

            @Override
            public void progress(String message) {
                ProgressManager.this.lastProgressMessage = message;
                ProgressManager.this.receivers.forEach(receiver -> receiver.progress(message));
            }

            @Override
            public void progress(double progress) {
                ProgressManager.this.lastProgressValue = progress;
                ProgressManager.this.receivers.forEach(receiver -> receiver.progress(progress));
            }

            @Override
            public void completed() {
                ProgressManager.this.receivers.forEach(ProgressReceiver::completed);
            }
        };
    }

    public void onTaskActivation(Consumer<ProgressManager<V>> taskActivationHandler) {
        this.taskActivationHandler = taskActivationHandler;
    }

    public void onTaskFinalization(Consumer<ProgressManager<V>> taskFinalizationHandler) {
        this.taskFinalizationHandler = taskFinalizationHandler;
    }

    public ListenableProgressFuture<V> wrap(final ListenableFuture<V> future) {
        if (this.future != null) {
            throw new IllegalStateException("this org.openthinclient.progress manager instance already wrapped a future");
        }
        this.future = new ListenableProgressFuture<V>(){

            @Override
            public double getProgress() {
                return ProgressManager.this.lastProgressValue;
            }

            @Override
            public String getProgressMessage() {
                return ProgressManager.this.lastProgressMessage;
            }

            @Override
            public Registration addProgressReceiver(ProgressReceiver receiver) {
                receiver.progress(ProgressManager.this.lastProgressMessage, ProgressManager.this.lastProgressValue);
                ProgressManager.this.receivers.add(receiver);
                return () -> ProgressManager.this.receivers.remove(receiver);
            }

            public void addCallback(ListenableFutureCallback<? super V> callback) {
                future.addCallback(callback);
            }

            public void addCallback(SuccessCallback<? super V> successCallback, FailureCallback failureCallback) {
                future.addCallback(successCallback, failureCallback);
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            public boolean isCancelled() {
                return future.isCancelled();
            }

            public boolean isDone() {
                return future.isDone();
            }

            public V get() throws InterruptedException, ExecutionException {
                return future.get();
            }

            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return future.get(timeout, unit);
            }
        };
        return this.future;
    }

    public Callable<V> asCallable() {
        return () -> {
            try {
                this.state = State.RUNNING;
                if (this.taskActivationHandler != null) {
                    this.taskActivationHandler.accept(this);
                }
                V result = this.task.execute(this.receiver());
                this.state = State.FINISHED;
                V v = result;
                return v;
            }
            catch (Exception e) {
                this.state = State.FAILED;
                throw e;
            }
            finally {
                if (this.taskFinalizationHandler != null) {
                    this.taskFinalizationHandler.accept(this);
                }
            }
        };
    }

    public ListenableProgressFuture<?> getFuture() {
        return this.future;
    }

    public static enum State {
        QUEUED,
        RUNNING,
        FINISHED,
        FAILED;

    }
}

