/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.importer.impl;

import java.util.HashSet;
import java.util.Set;
import org.openthinclient.api.importer.impl.ApplicationProfileMembersMapper;
import org.openthinclient.api.importer.impl.ImportModelMapper;
import org.openthinclient.api.importer.impl.ProfileReferenceCreator;
import org.openthinclient.api.importer.impl.ProfileReferenceResolver;
import org.openthinclient.api.importer.impl.ProfileSchemaConfigurer;
import org.openthinclient.api.importer.model.ImportableClient;
import org.openthinclient.api.importer.model.ImportableHardwareType;
import org.openthinclient.api.importer.model.ImportableLocation;
import org.openthinclient.api.importer.model.ProfileReference;
import org.openthinclient.api.rest.model.Device;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportModelMapperImpl
implements ImportModelMapper {
    @Autowired
    private ProfileReferenceResolver profileReferenceResolver;
    @Autowired
    private ProfileReferenceCreator profileReferenceCreator;
    @Autowired
    private ProfileSchemaConfigurer profileSchemaConfigurer;
    @Autowired
    private ApplicationProfileMembersMapper applicationProfileMembersMapper;

    @Override
    public ImportableHardwareType toImportable(HardwareType hw) {
        Set<ProfileReference> set_;
        if (hw == null) {
            return null;
        }
        ImportableHardwareType importableHardwareType = new ImportableHardwareType();
        importableHardwareType.setDescription(hw.getDescription());
        importableHardwareType.setName(hw.getName());
        Set<ProfileReference> set = this.deviceSetToProfileReferenceSet(hw.getDevices());
        if (set != null) {
            importableHardwareType.setDevices(set);
        }
        if (importableHardwareType.getHardwareTypes() != null && (set_ = this.hardwareTypeSetToProfileReferenceSet(hw.getHardwareTypes())) != null) {
            importableHardwareType.getHardwareTypes().addAll(set_);
        }
        this.applyConfiguration((Profile)hw, importableHardwareType);
        return importableHardwareType;
    }

    @Override
    public HardwareType fromImportable(ImportableHardwareType hw) {
        Set<HardwareType> set_;
        if (hw == null) {
            return null;
        }
        HardwareType hardwareType = new HardwareType();
        hardwareType.setDescription(hw.getDescription());
        hardwareType.setName(hw.getName());
        Set<org.openthinclient.common.model.Device> set = this.profileReferenceSetToDeviceSet(hw.getDevices());
        if (set != null) {
            hardwareType.setDevices(set);
        }
        if ((set_ = this.profileReferenceSetToHardwareTypeSet(hw.getHardwareTypes())) != null) {
            hardwareType.setHardwareTypes(set_);
        }
        this.profileSchemaConfigurer.applyConfiguration(hw, (Profile)hardwareType);
        return hardwareType;
    }

    @Override
    public org.openthinclient.common.model.Device fromImportable(Device device) {
        if (device == null) {
            return null;
        }
        org.openthinclient.common.model.Device device_ = new org.openthinclient.common.model.Device();
        device_.setDescription(device.getDescription());
        device_.setName(device.getName());
        Set<String> set = device.getMembers();
        if (set != null) {
            device_.setMembers(new HashSet<String>(set));
        }
        this.profileSchemaConfigurer.applyConfiguration(device, (Profile)device_);
        return device_;
    }

    @Override
    public Printer fromImportable(org.openthinclient.api.rest.model.Printer printer) {
        if (printer == null) {
            return null;
        }
        Printer printer_ = new Printer();
        printer_.setDescription(printer.getDescription());
        printer_.setName(printer.getName());
        this.profileSchemaConfigurer.applyConfiguration(printer, (Profile)printer_);
        return printer_;
    }

    @Override
    public Location fromImportable(ImportableLocation location) {
        if (location == null) {
            return null;
        }
        Location location_ = new Location();
        location_.setDescription(location.getDescription());
        location_.setName(location.getName());
        Set<Printer> set = this.profileReferenceSetToPrinterSet(location.getPrinters());
        if (set != null) {
            location_.setPrinters(set);
        }
        this.profileSchemaConfigurer.applyConfiguration(location, (Profile)location_);
        return location_;
    }

    @Override
    public Application fromImportable(org.openthinclient.api.rest.model.Application application) {
        if (application == null) {
            return null;
        }
        Application application_ = new Application();
        application_.setDescription(application.getDescription());
        application_.setName(application.getName());
        Set<DirectoryObject> set = this.applicationProfileMembersMapper.asSetOfDirectoryObject(application.getMembers());
        if (set != null) {
            application_.setMembers(set);
        }
        this.profileSchemaConfigurer.applyConfiguration(application, (Profile)application_);
        return application_;
    }

    @Override
    public Client fromImportable(ImportableClient importableClient) {
        Set<org.openthinclient.common.model.Device> set__;
        if (importableClient == null) {
            return null;
        }
        Client client = new Client();
        client.setDescription(importableClient.getDescription());
        client.setName(importableClient.getName());
        Set<Application> set = this.profileReferenceSetToApplicationSet(importableClient.getApplications());
        if (set != null) {
            client.setApplications(set);
        }
        client.setHardwareType(this.profileReferenceResolver.resolve(importableClient.getHardwareType(), HardwareType.class));
        client.setLocation(this.profileReferenceResolver.resolve(importableClient.getLocation(), Location.class));
        Set<Printer> set_ = this.profileReferenceSetToPrinterSet(importableClient.getPrinters());
        if (set_ != null) {
            client.setPrinters(set_);
        }
        if ((set__ = this.profileReferenceSetToDeviceSet(importableClient.getDevices())) != null) {
            client.setDevices(set__);
        }
        client.setMacAddress(importableClient.getMacAddress());
        this.profileSchemaConfigurer.applyConfiguration(importableClient, (Profile)client);
        return client;
    }

    protected Set<ProfileReference> deviceSetToProfileReferenceSet(Set<org.openthinclient.common.model.Device> set) {
        if (set == null) {
            return null;
        }
        HashSet<ProfileReference> set_ = new HashSet<ProfileReference>();
        for (org.openthinclient.common.model.Device device : set) {
            set_.add(this.profileReferenceCreator.create((Profile)device));
        }
        return set_;
    }

    protected Set<ProfileReference> hardwareTypeSetToProfileReferenceSet(Set<HardwareType> set) {
        if (set == null) {
            return null;
        }
        HashSet<ProfileReference> set_ = new HashSet<ProfileReference>();
        for (HardwareType hardwareType : set) {
            set_.add(this.profileReferenceCreator.create((Profile)hardwareType));
        }
        return set_;
    }

    protected Set<org.openthinclient.common.model.Device> profileReferenceSetToDeviceSet(Set<ProfileReference> set) {
        if (set == null) {
            return null;
        }
        HashSet<org.openthinclient.common.model.Device> set_ = new HashSet<org.openthinclient.common.model.Device>();
        for (ProfileReference profileReference : set) {
            set_.add(this.profileReferenceResolver.resolve(profileReference, org.openthinclient.common.model.Device.class));
        }
        return set_;
    }

    protected Set<HardwareType> profileReferenceSetToHardwareTypeSet(Set<ProfileReference> set) {
        if (set == null) {
            return null;
        }
        HashSet<HardwareType> set_ = new HashSet<HardwareType>();
        for (ProfileReference profileReference : set) {
            set_.add(this.profileReferenceResolver.resolve(profileReference, HardwareType.class));
        }
        return set_;
    }

    protected Set<Printer> profileReferenceSetToPrinterSet(Set<ProfileReference> set) {
        if (set == null) {
            return null;
        }
        HashSet<Printer> set_ = new HashSet<Printer>();
        for (ProfileReference profileReference : set) {
            set_.add(this.profileReferenceResolver.resolve(profileReference, Printer.class));
        }
        return set_;
    }

    protected Set<Application> profileReferenceSetToApplicationSet(Set<ProfileReference> set) {
        if (set == null) {
            return null;
        }
        HashSet<Application> set_ = new HashSet<Application>();
        for (ProfileReference profileReference : set) {
            set_.add(this.profileReferenceResolver.resolve(profileReference, Application.class));
        }
        return set_;
    }
}

