/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.openthinclient.pkgmgr.db.Package;

public class PackageManagerUtils {
    public List<Package> reduceToLatestVersion(List<Package> packages) {
        ConcurrentHashMap<String, Package> seen = new ConcurrentHashMap<String, Package>();
        for (Package pkg : packages) {
            if (!seen.containsKey(pkg.getName())) {
                seen.put(pkg.getName(), pkg);
                continue;
            }
            Package p2 = (Package)seen.get(pkg.getName());
            if (p2.getVersion().compareTo(pkg.getVersion()) >= 1) continue;
            seen.replace(pkg.getName(), pkg);
        }
        return seen.entrySet().stream().map(p -> (Package)p.getValue()).collect(Collectors.toList());
    }

    public static Package parse(String p) {
        Package pkg;
        if (p.split("_\\d").length > 1) {
            int separatorIdx = p.indexOf("_");
            String name = p.substring(0, separatorIdx);
            String version = p.substring(separatorIdx + 1);
            pkg = PackageManagerUtils.createPackage(name, version);
        } else {
            pkg = PackageManagerUtils.createPackage(p, null);
        }
        return pkg;
    }

    public static Package createPackage(String name, String version) {
        Package pkg = new Package();
        pkg.setName(name);
        if (version != null) {
            pkg.setVersion(version);
        }
        return pkg;
    }
}

