/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openthinclient.pkgmgr.SourcesList;

public class SourcesListWriter {
    private final String NL = "\n";

    public void write(SourcesList sourcesList, OutputStream out) throws SourcesListWriterException {
        try {
            OutputStreamWriter w = new OutputStreamWriter(out, "UTF-8");
            this.write(sourcesList, w);
            w.flush();
        }
        catch (IOException e) {
            throw new SourcesListWriterException("sources list writing failed", e);
        }
    }

    public void write(SourcesList sourcesList, Writer writer) throws SourcesListWriterException {
        sourcesList.getSources().forEach(source -> {
            try {
                String[] lines;
                if (!Strings.isNullOrEmpty((String)source.getDescription()) && (lines = source.getDescription().split("\\r?\\n")).length > 0) {
                    for (String line : lines) {
                        writer.write("# ");
                        writer.write(line);
                        writer.write("\n");
                    }
                }
                if (!source.isEnabled()) {
                    writer.write("#");
                }
                writer.write("deb");
                writer.write(" ");
                writer.write(source.getUrl().toExternalForm());
                writer.write(" ");
                writer.write("./");
                writer.write("\n");
            }
            catch (IOException e) {
                throw new SourcesListWriterException("sources list writing failed", e);
            }
        });
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new SourcesListWriterException("sources list writing failed", e);
        }
    }

    public static class SourcesListWriterException
    extends RuntimeException {
        public SourcesListWriterException() {
        }

        public SourcesListWriterException(String message) {
            super(message);
        }

        public SourcesListWriterException(String message, Throwable cause) {
            super(message, cause);
        }

        public SourcesListWriterException(Throwable cause) {
            super(cause);
        }
    }
}

