/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.PackageManagerException;
import org.openthinclient.pkgmgr.PackageManagerTaskSummary;
import org.openthinclient.pkgmgr.SourcesList;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.exception.SourceIntegrityViolationException;
import org.openthinclient.pkgmgr.op.PackageListUpdateReport;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.service.nfs.NFS;
import org.openthinclient.util.dpkg.LocalPackageRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManagerImpl
implements PackageManager {
    private static final Logger logger = LoggerFactory.getLogger(PackageManagerImpl.class);
    private final PackageManager delegate;
    private final NFS nfs;

    public PackageManagerImpl(PackageManager delegate, NFS nfs) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.delegate = delegate;
        this.nfs = nfs;
    }

    @Override
    public void close() throws PackageManagerException {
        this.delegate.close();
    }

    @Override
    public long getFreeDiskSpace() throws PackageManagerException {
        return this.delegate.getFreeDiskSpace();
    }

    @Override
    public Collection<Package> getInstallablePackages() throws PackageManagerException {
        return this.delegate.getInstallablePackages();
    }

    @Override
    public Collection<Package> getInstalledPackages() {
        return this.delegate.getInstalledPackages();
    }

    @Override
    public Collection<Package> getInstallablePackagesWithoutInstalledOfSameVersion() {
        return this.delegate.getInstallablePackagesWithoutInstalledOfSameVersion();
    }

    @Override
    public Collection<Package> getUpdateablePackages() {
        return this.delegate.getUpdateablePackages();
    }

    @Override
    public Collection<String> getChangelogFile(Package p) throws IOException {
        return this.delegate.getChangelogFile(p);
    }

    @Override
    public ListenableProgressFuture<PackageListUpdateReport> updateCacheDB() {
        return this.delegate.updateCacheDB();
    }

    @Override
    public boolean addWarning(String warning) {
        return this.delegate.addWarning(warning);
    }

    @Override
    public PackageManagerTaskSummary fetchTaskSummary() {
        return this.delegate.fetchTaskSummary();
    }

    @Override
    public PackageManagerOperation createOperation() {
        return this.delegate.createOperation();
    }

    @Override
    public ListenableProgressFuture<PackageManagerOperationReport> execute(PackageManagerOperation operation) {
        return this.delegate.execute(operation);
    }

    @Override
    public SourcesList getSourcesList() {
        return this.delegate.getSourcesList();
    }

    @Override
    public LocalPackageRepository getLocalPackageRepository() {
        return this.delegate.getLocalPackageRepository();
    }

    @Override
    public boolean isInstalled(Package pkg) {
        return this.delegate.isInstalled(pkg);
    }

    @Override
    public boolean isInstallable(Package pkg) {
        return this.delegate.isInstallable(pkg);
    }

    @Override
    public PackageManagerConfiguration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public void deleteSource(Source source) throws SourceIntegrityViolationException {
        this.delegate.deleteSource(source);
    }

    @Override
    public Source saveSource(Source source) {
        return this.delegate.saveSource(source);
    }

    @Override
    public Collection<Source> findAllSources() {
        return this.delegate.findAllSources();
    }

    @Override
    public void saveSources(List<Source> sources) {
        this.delegate.saveSources(sources);
    }

    @Override
    public ListenableProgressFuture<PackageListUpdateReport> deleteSourcePackagesFromCacheDB(Source source) {
        return this.delegate.deleteSourcePackagesFromCacheDB(source);
    }

    @Override
    public List<PackageInstalledContent> getInstalledPackageContents(Package pkg) {
        return this.delegate.getInstalledPackageContents(pkg);
    }
}

