/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.util.dpkg.LocalPackageRepository;

public class DefaultLocalPackageRepository
implements LocalPackageRepository {
    private final Path rootPath;

    public DefaultLocalPackageRepository(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public Path getPackage(Package pkg) {
        Path packagePath = this.getPackagePath(pkg);
        if (this.isValidPackageFile(packagePath)) {
            return packagePath;
        }
        return null;
    }

    private boolean isValidPackageFile(Path packagePath) {
        return Files.exists(packagePath, new LinkOption[0]) && Files.isRegularFile(packagePath, new LinkOption[0]);
    }

    private Path getPackagePath(Package pkg) {
        int lastSlash = pkg.getFilename().lastIndexOf(47);
        String filename = lastSlash > 0 ? pkg.getFilename().substring(lastSlash + 1) : pkg.getFilename();
        return this.getSourcePath(pkg.getSource()).resolve(filename);
    }

    private Path getSourcePath(Source source) {
        Long id = source.getId();
        if (id == null) {
            throw new IllegalArgumentException("The given source has not yet been saved");
        }
        return this.rootPath.resolve("" + id);
    }

    @Override
    public boolean isAvailable(Package pkg) {
        return this.isValidPackageFile(this.getPackagePath(pkg));
    }

    @Override
    public void addPackage(Package pkg, LocalPackageRepository.PackageContentsProvider packageContentsProvider) throws IOException {
        Path targetPath = this.getPackagePath(pkg);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Path temporaryPath = targetPath.getParent().resolve(targetPath.getFileName() + ".tmp");
        packageContentsProvider.provide(temporaryPath);
        Files.move(temporaryPath, targetPath, new CopyOption[0]);
    }
}

