/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.Version;

public abstract class PackageReference
implements Serializable {
    private static final long serialVersionUID = 3977016258086907959L;

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract boolean matches(Package var1);

    public abstract boolean isSatisfiedBy(Map<String, Package> var1);

    public static class OrReference
    extends PackageReference {
        private final List<SingleReference> refs;

        public OrReference(SingleReference ... refs) {
            this(Arrays.asList(refs));
        }

        public OrReference(List<SingleReference> refs) {
            this.refs = new ArrayList<SingleReference>(refs);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.refs.size(); ++i) {
                PackageReference ref = this.refs.get(i);
                sb.append(ref.toString());
                if (i >= this.refs.size() - 1) continue;
                sb.append(" | ");
            }
            return sb.toString();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.refs);
        }

        @Override
        public boolean matches(Package pkg) {
            for (PackageReference packageReference : this.refs) {
                if (!packageReference.matches(pkg)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isSatisfiedBy(Map<String, Package> pkgs) {
            for (PackageReference packageReference : this.refs) {
                if (!packageReference.isSatisfiedBy(pkgs)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrReference that = (OrReference)o;
            return this.refs.equals(that.refs);
        }

        public List<SingleReference> getReferences() {
            return Collections.unmodifiableList(this.refs);
        }
    }

    public static class SingleReference
    extends PackageReference {
        private final String name;
        private final Version version;
        private final Relation relation;

        public SingleReference(String name, Relation relation, Version version) {
            if (name == null) {
                throw new IllegalArgumentException("Name must not be null.");
            }
            if (relation != null && version == null) {
                throw new IllegalArgumentException("Version must not be null if relation is specified.");
            }
            this.name = name;
            this.relation = relation;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        public Relation getRelation() {
            return this.relation;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            if (null != this.relation) {
                sb.append(" (").append((Object)this.relation).append(" ").append(this.version).append(")");
            }
            return sb.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleReference that = (SingleReference)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version) && Objects.equals((Object)this.relation, (Object)that.relation);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.version, this.relation});
        }

        @Override
        public boolean matches(Package pkg) {
            if (!this.name.equalsIgnoreCase(pkg.getName())) {
                return false;
            }
            if (null == this.relation) {
                return true;
            }
            Version v = pkg.getVersion();
            switch (this.relation) {
                case EARLIER: {
                    return v.compareTo(this.version) < 0;
                }
                case EARLIER_OR_EQUAL: {
                    return v.compareTo(this.version) <= 0;
                }
                case EQUAL: {
                    return v.equals(this.version);
                }
                case LATER_OR_EQUAL: {
                    return v.compareTo(this.version) >= 0;
                }
                case LATER: {
                    return v.compareTo(this.version) > 0;
                }
            }
            return false;
        }

        @Override
        public boolean isSatisfiedBy(Map<String, Package> pkgs) {
            Package definingPackage = pkgs.get(this.name);
            if (null == definingPackage) {
                return false;
            }
            if (this.name.equals(definingPackage.getName())) {
                return this.matches(definingPackage);
            }
            return false;
        }
    }

    public static enum Relation {
        EARLIER("<<"),
        EARLIER_OR_EQUAL("<="),
        EQUAL("="),
        LATER_OR_EQUAL(">="),
        LATER(">>");

        private final String textualRepresentation;

        public static Relation getByTextualRepresentation(String s) {
            for (Relation r : Relation.values()) {
                if (!r.textualRepresentation.equals(s)) continue;
                return r;
            }
            return null;
        }

        private Relation(String s) {
            this.textualRepresentation = s;
        }

        public String getTextualRepresentation() {
            return this.textualRepresentation;
        }

        public String toString() {
            return this.textualRepresentation;
        }
    }
}

