/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor.check;

import ch.qos.cal10n.MessageConveyor;
import java.net.NetworkInterface;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.openthinclient.advisor.AdvisorMessages;
import org.openthinclient.advisor.check.AbstractCheck;
import org.openthinclient.advisor.check.CheckExecutionEngine;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.openthinclient.advisor.inventory.SystemInventory;
import org.openthinclient.advisor.inventory.SystemInventoryFactory;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class CheckNetworkInferfaces
extends AbstractCheck<NetworkInterfacesCheckSummary> {
    private final SystemInventory systemInventory;

    public CheckNetworkInferfaces(Locale locale, SystemInventory systemInventory) {
        super(new MessageConveyor(locale).getMessage((Enum)AdvisorMessages.ADVISOR_CHECKNETWORKINFERFACES_TITLE, new Object[0]), "");
        this.systemInventory = systemInventory;
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
        CheckExecutionEngine engine = new CheckExecutionEngine((AsyncListenableTaskExecutor)taskExecutor);
        SystemInventoryFactory inventoryFactory = new SystemInventoryFactory((AsyncListenableTaskExecutor)taskExecutor);
        ListenableFuture<SystemInventory> systemInventory = inventoryFactory.determineSystemInventory();
        engine.execute(new CheckNetworkInferfaces(Locale.ENGLISH, (SystemInventory)systemInventory.get())).onResult(r -> {
            System.out.println((Object)r.getType());
            System.out.println(((NetworkInterfacesCheckSummary)r.getValue()).getDeviceSummary());
            System.out.println();
            System.out.println(((NetworkInterfacesCheckSummary)r.getValue()).getMessage());
        });
    }

    @Override
    protected CheckExecutionResult<NetworkInterfacesCheckSummary> perform() {
        String message;
        CheckExecutionResult.CheckResultType type;
        StringBuilder sbDevices = new StringBuilder();
        Consumer<NetworkInterface> dumpNetworkInterfacesConsumer = n -> {
            sbDevices.append(String.format("%s (%s)", n.getName(), n.getDisplayName()));
            sbDevices.append(" [");
            sbDevices.append(this.systemInventory.getNetworkInterfaces().getHardwareAddressString((NetworkInterface)n));
            sbDevices.append("]");
            sbDevices.append("\r\n");
            Collections.list(n.getInetAddresses()).forEach(address -> {
                sbDevices.append(String.format("- %s", address.getHostAddress()));
                sbDevices.append("\r\n");
            });
        };
        sbDevices.append("System Information Summary\r\n");
        sbDevices.append("Loopback interfaces ------------------------------\r\n");
        this.systemInventory.getNetworkInterfaces().getLoopbackInterfaces().forEach(dumpNetworkInterfacesConsumer);
        sbDevices.append("Network interfaces -------------------------------\r\n");
        this.systemInventory.getNetworkInterfaces().getNonLoopbackInterfaces().forEach(dumpNetworkInterfacesConsumer);
        if (this.systemInventory.getNetworkInterfaces().getAllInterfaces().size() == 0) {
            type = CheckExecutionResult.CheckResultType.FAILED;
            message = "No network devices detected on this system.";
        } else if (this.systemInventory.getNetworkInterfaces().getNonLoopbackInterfaces().size() == 0) {
            type = CheckExecutionResult.CheckResultType.FAILED;
            message = "No non loopback network devices has been detected on your system.";
        } else if (this.systemInventory.getNetworkInterfaces().getNonLoopbackInterfaces().size() == 1) {
            type = CheckExecutionResult.CheckResultType.SUCCESS;
            message = "";
        } else {
            type = CheckExecutionResult.CheckResultType.WARNING;
            message = " non loopback network interfaces detected on your system. Only a single network device is recommended for use with the openthinclient manager.";
        }
        return new CheckExecutionResult<NetworkInterfacesCheckSummary>(type, new NetworkInterfacesCheckSummary(message, sbDevices.toString()));
    }

    public static final class NetworkInterfacesCheckSummary {
        private final String message;
        private final String deviceSummary;

        public NetworkInterfacesCheckSummary(String message, String deviceSummary) {
            this.message = message;
            this.deviceSummary = deviceSummary;
        }

        public String getMessage() {
            return this.message;
        }

        public String getDeviceSummary() {
            return this.deviceSummary;
        }
    }
}

