/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.common;

import org.openthinclient.service.common.Service;
import org.openthinclient.service.common.ServiceConfiguration;
import org.openthinclient.service.common.ServiceErrorEvent;
import org.openthinclient.service.common.ServiceStartedEvent;
import org.openthinclient.service.common.ServiceStoppedEvent;
import org.openthinclient.service.common.home.ManagerHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class ManagedService<S extends Service<C>, C extends ServiceConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedService.class);
    private final ApplicationEventPublisher eventPublisher;
    private final ManagerHome managerHome;
    private final S service;
    private volatile boolean running;
    private volatile Exception lastException;

    public ManagedService(ApplicationEventPublisher eventPublisher, ManagerHome managerHome, S service) {
        this.eventPublisher = eventPublisher;
        this.managerHome = managerHome;
        this.service = service;
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        ServiceConfiguration configuration = (ServiceConfiguration)this.managerHome.getConfiguration(this.service.getConfigurationClass());
        this.service.setConfiguration((ServiceConfiguration)configuration);
    }

    public synchronized void start() {
        if (this.running) {
            LOGGER.error("Not starting service " + this.service + " as it is already running");
            return;
        }
        this.running = true;
        this.lastException = null;
        try {
            this.loadConfiguration();
            this.service.startService();
            this.eventPublisher.publishEvent((ApplicationEvent)new ServiceStartedEvent(this));
        }
        catch (Exception e) {
            this.lastException = e;
            LOGGER.error("Failed to start service " + this.service, (Throwable)e);
            this.eventPublisher.publishEvent((ApplicationEvent)new ServiceErrorEvent(this, e));
            this.running = false;
        }
    }

    public synchronized void stop() {
        if (!this.running) {
            LOGGER.error("Can not stop service " + this.service + " as it is not running");
            return;
        }
        this.running = false;
        try {
            this.service.stopService();
            this.eventPublisher.publishEvent((ApplicationEvent)new ServiceStoppedEvent(this));
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop service " + this.service, (Throwable)e);
        }
    }

    public synchronized void restart() {
        if (this.running) {
            this.stop();
        }
        this.start();
    }

    public Service<?> getService() {
        return this.service;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Exception getStartupException() {
        return this.lastException;
    }

    public boolean isFaulty() {
        return this.getStartupException() != null;
    }

    public boolean isAutostartEnabled() {
        return this.service.getConfiguration().isAutostartEnabled();
    }
}

