/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.openthinclient.sysreport.AbstractReport;
import org.openthinclient.sysreport.AbstractReportWriter;

public abstract class AbstractReportPackage<T extends AbstractReport>
extends AbstractReportWriter<T> {
    private final String reportFilename;

    public AbstractReportPackage(T report, String reportFilename) {
        super(report);
        this.reportFilename = reportFilename;
    }

    public void save(OutputStream out) throws IOException {
        try (ZipArchiveOutputStream zip = new ZipArchiveOutputStream(out);){
            Instant creationTimestamp = Instant.now();
            zip.setLevel(9);
            zip.setComment("openthinclient manager system report. Generated: " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault()).format(creationTimestamp));
            this.writeReportReport(zip, creationTimestamp);
            this.writeAdditionalContents(zip, creationTimestamp);
            zip.finish();
        }
    }

    protected abstract void writeAdditionalContents(ZipArchiveOutputStream var1, Instant var2) throws IOException;

    private void writeReportReport(ZipArchiveOutputStream zip, Instant creationTimestamp) throws IOException {
        ZipArchiveEntry entry = new ZipArchiveEntry(this.reportFilename);
        entry.setCreationTime(FileTime.from(creationTimestamp));
        zip.putArchiveEntry((ArchiveEntry)entry);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeReport(baos);
        zip.write(baos.toByteArray());
        zip.closeArchiveEntry();
    }
}

