/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.config;

import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientGroupService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.sysreport.StatisticsReportPublisher;
import org.openthinclient.sysreport.generate.StatisticsReportGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.annotation.Schedules;

@Configuration
@EnableScheduling
public class StatisticsReportingConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsReportingConfiguration.class);
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private PackageManager packageManager;
    @Autowired
    private ClientService clientService;
    @Autowired
    private UnrecognizedClientService unrecognizedClientService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ClientGroupService clientGroupService;
    @Autowired
    private RealmService realmService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private LicenseManager licenseManager;

    @Bean
    public StatisticsReportGenerator statisticsReportGenerator() {
        return new StatisticsReportGenerator(this.managerHome, this.packageManager, this.clientService, this.unrecognizedClientService, this.applicationService, this.applicationGroupService, this.clientGroupService, this.realmService, this.userService, this.userGroupService, this.deviceService, this.locationService, this.printerService, this.hardwareTypeService, this.licenseManager);
    }

    @Bean
    public StatisticsReportPublisher.Uploader uploader() {
        return new StatisticsReportPublisher.Uploader(((PackageManagerConfiguration)this.managerHome.getConfiguration(PackageManagerConfiguration.class)).getProxyConfiguration());
    }

    @Bean
    public StatisticsReportPublisher statisticsReportPublisher() {
        return new StatisticsReportPublisher(this.statisticsReportGenerator(), this.uploader());
    }

    @Schedules(value={@Scheduled(cron="0 30 7 * * FRI"), @Scheduled(cron="0 0 12 * * WED")})
    public void transmitStatisticsReport() throws Exception {
        if (this.managerHome.getMetadata().isUsageStatisticsEnabled()) {
            this.statisticsReportPublisher().publish();
        } else {
            LOGGER.debug("Statistics transmission has been disabled. Skipping.");
        }
    }
}

