/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import org.openthinclient.sysreport.SystemReport;
import org.openthinclient.sysreport.generate.AbstractNetworkInterfaceContributor;
import org.openthinclient.sysreport.generate.SystemReportGenerator;

public class NetworkInterfaceDetailsContributor
extends AbstractNetworkInterfaceContributor<SystemReport> {
    @Override
    protected void contribute(SystemReport report, NetworkInterface networkInterface) throws SocketException {
        SystemReport.NetworkInterfaceDetails target = new SystemReport.NetworkInterfaceDetails();
        target.setDisplayName(networkInterface.getDisplayName());
        target.setName(networkInterface.getName());
        if (networkInterface.getHardwareAddress() != null) {
            target.setHardwareAddress(SystemReportGenerator.toMacAddressString(networkInterface.getHardwareAddress()));
        }
        for (InetAddress inetAddress : Collections.list(networkInterface.getInetAddresses())) {
            target.getAddresses().add(inetAddress.getHostAddress());
        }
        report.getNetwork().getInterfaces().add(target);
    }
}

