/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.sysreport.Package;
import org.openthinclient.sysreport.PackageInstalledContent;
import org.openthinclient.sysreport.SystemReport;
import org.openthinclient.sysreport.generate.AbstractPackageManagerReportContributor;

public class PackageManagerReportContributor
extends AbstractPackageManagerReportContributor<SystemReport> {
    public PackageManagerReportContributor(PackageManager packageManager) {
        super(packageManager);
    }

    @Override
    public void contribute(SystemReport report) {
        super.contribute(report);
        PackageManagerConfiguration config = this.packageManager.getConfiguration();
        SystemReport.Network network = report.getNetwork();
        if (config.getProxyConfiguration() != null) {
            if (!Strings.isNullOrEmpty((String)config.getProxyConfiguration().getPassword())) {
                network.getProxy().setPasswordSpecified(true);
            }
            network.getProxy().setEnabled(config.getProxyConfiguration().isEnabled());
            network.getProxy().setHost(config.getProxyConfiguration().getHost());
            network.getProxy().setPort(config.getProxyConfiguration().getPort());
            network.getProxy().setUser(config.getProxyConfiguration().getUser());
        }
        this.packageManager.getInstalledPackages().stream().map(this::convert).forEach(report.getPackageManager().getInstalled()::add);
        this.packageManager.getInstallablePackages().stream().map(this::convert).forEach(report.getPackageManager().getInstallable()::add);
    }

    @Override
    protected void onInstalled(SystemReport report, org.openthinclient.pkgmgr.db.Package aPackage) {
        report.getPackageManager().getInstalled().add(this.convert(aPackage));
    }

    @Override
    protected void onInstallable(SystemReport report, org.openthinclient.pkgmgr.db.Package aPackage) {
        report.getPackageManager().getInstallable().add(this.convert(aPackage));
    }

    protected Package convert(org.openthinclient.pkgmgr.db.Package pkg) {
        Package converted = new Package();
        converted.setId(pkg.getId());
        converted.setSource(pkg.getSource().getUrl().toString());
        converted.setInstalledSize(pkg.getInstalledSize());
        converted.setVersion(pkg.getVersion().toString());
        converted.setArchitecture(pkg.getArchitecture());
        converted.setDistribution(pkg.getDistribution());
        converted.setName(pkg.getName());
        converted.setPriority(pkg.getPriority());
        converted.setSize(pkg.getSize());
        converted.setInstalled(pkg.isInstalled());
        if (pkg.isInstalled()) {
            converted.setInstalledContents(this.packageManager.getInstalledPackageContents(pkg).stream().map(this::convert).sorted(Comparator.comparingLong(PackageInstalledContent::getSequence)).collect(Collectors.toList()));
        }
        return converted;
    }

    private PackageInstalledContent convert(org.openthinclient.pkgmgr.db.PackageInstalledContent installedPackageContent) {
        PackageInstalledContent converted = new PackageInstalledContent();
        converted.setId(installedPackageContent.getId());
        converted.setPath(installedPackageContent.getPath());
        converted.setSequence(installedPackageContent.getSequence());
        converted.setSha1(installedPackageContent.getSha1());
        switch (installedPackageContent.getType()) {
            case FILE: {
                converted.setType(PackageInstalledContent.Type.FILE);
                break;
            }
            case DIR: {
                converted.setType(PackageInstalledContent.Type.DIR);
                break;
            }
            case SYMLINK: {
                converted.setType(PackageInstalledContent.Type.SYMLINK);
            }
        }
        return converted;
    }
}

