/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.io.Serializable;
import java.security.Principal;
import javax.naming.Name;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.name.LdapDN;

public final class LdapPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 3906650782395676720L;
    private final Name name;
    public static final LdapPrincipal ANONYMOUS = new LdapPrincipal();
    private final AuthenticationLevel authenticationLevel;

    LdapPrincipal(Name name, AuthenticationLevel authenticationLevel) {
        this.name = name;
        this.authenticationLevel = authenticationLevel;
    }

    private LdapPrincipal() {
        this.name = new LdapDN();
        this.authenticationLevel = AuthenticationLevel.NONE;
    }

    public LdapDN getJndiName() {
        return (LdapDN)this.name.clone();
    }

    public String getName() {
        return this.name.toString();
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public String toString() {
        return this.name.toString();
    }
}

