/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.ConcreteNameComponentNormalizer;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleCache {
    private static final String ACI_ATTR = "prescriptiveACI";
    private static final String OC_ATTR = "objectClass";
    private static final String ACSUBENTRY_OC = "accessControlSubentry";
    private static final Logger log = LoggerFactory.getLogger((Class)TupleCache.class);
    private final Hashtable env;
    private final Map tuples = new HashMap();
    private final PartitionNexus nexus;
    private final ACIItemParser aciParser;
    private Map normalizerMap;

    public TupleCache(DirectoryServiceConfiguration factoryCfg) throws NamingException {
        this.normalizerMap = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry().getNormalizerMapping();
        this.nexus = factoryCfg.getPartitionNexus();
        AttributeTypeRegistry attributeRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        OidRegistry oidRegistry = factoryCfg.getGlobalRegistries().getOidRegistry();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(attributeRegistry, oidRegistry);
        this.aciParser = new ACIItemParser((NameComponentNormalizer)ncn, this.normalizerMap);
        this.env = (Hashtable)factoryCfg.getEnvironment().clone();
        this.initialize();
    }

    private LdapDN parseNormalized(String name) throws NamingException {
        LdapDN dn = new LdapDN(name);
        dn.normalize(this.normalizerMap);
        return dn;
    }

    private void initialize() throws NamingException {
        Iterator suffixes = this.nexus.listSuffixes();
        while (suffixes.hasNext()) {
            String suffix = (String)suffixes.next();
            LdapDN baseDn = this.parseNormalized(suffix);
            SimpleNode filter = new SimpleNode(OC_ATTR, ACSUBENTRY_OC, 0);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration results = this.nexus.search(baseDn, this.env, (ExprNode)filter, ctls);
            while (results.hasMore()) {
                SearchResult result = (SearchResult)results.next();
                String subentryDn = result.getName();
                Attribute aci = result.getAttributes().get(ACI_ATTR);
                if (aci == null) {
                    log.warn("Found accessControlSubentry '" + subentryDn + "' without any " + ACI_ATTR);
                    continue;
                }
                LdapDN normName = this.parseNormalized(subentryDn);
                this.subentryAdded(subentryDn, normName, result.getAttributes());
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveACI(Attributes entry) throws NamingException {
        Attribute aci = entry.get(ACI_ATTR);
        if (aci == null) {
            if (AttributeUtils.containsValueCaseIgnore((Attribute)entry.get(OC_ATTR), (Object)ACSUBENTRY_OC)) {
                throw new LdapSchemaViolationException("", ResultCodeEnum.OBJECTCLASSVIOLATION);
            }
            return false;
        }
        return true;
    }

    public void subentryAdded(String upName, LdapDN normName, Attributes entry) throws NamingException {
        Attribute aci = entry.get(ACI_ATTR);
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        ArrayList entryTuples = new ArrayList();
        for (int ii = 0; ii < aci.size(); ++ii) {
            ACIItem item = null;
            try {
                item = this.aciParser.parse((String)aci.get(ii));
            }
            catch (ParseException e) {
                String msg = "ACIItem parser failure on \n'" + item + "'\ndue to syntax error. " + "Cannnot add ACITuples to TupleCache.\n" + "Check that the syntax of the ACI item is correct. \nUntil this error " + "is fixed your security settings will not be as expected.";
                log.error(msg, (Throwable)e);
                continue;
            }
            entryTuples.addAll(item.toTuples());
        }
        this.tuples.put(normName.toNormName(), entryTuples);
    }

    public void subentryDeleted(Name normName, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        this.tuples.remove(normName.toString());
    }

    public void subentryModified(LdapDN normName, ModificationItemImpl[] mods, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        boolean isAciModified = false;
        for (int ii = 0; ii < mods.length; ++ii) {
            isAciModified |= AttributeUtils.containsValueCaseIgnore((Attribute)mods[ii].getAttribute(), (Object)ACI_ATTR);
        }
        if (isAciModified) {
            this.subentryDeleted((Name)normName, entry);
            this.subentryAdded(normName.getUpName(), normName, entry);
        }
    }

    public void subentryModified(LdapDN normName, int modOp, Attributes mods, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        if (mods.get(ACI_ATTR) != null) {
            this.subentryDeleted((Name)normName, entry);
            this.subentryAdded(normName.getUpName(), normName, entry);
        }
    }

    public List getACITuples(String subentryDn) {
        List aciTuples = (List)this.tuples.get(subentryDn);
        if (aciTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(aciTuples);
    }

    public void subentryRenamed(Name oldName, Name newName) {
        this.tuples.put(newName.toString(), this.tuples.remove(oldName.toString()));
    }
}

