/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.HighestPrecedenceFilter;
import org.apache.directory.server.core.authz.support.MaxImmSubFilter;
import org.apache.directory.server.core.authz.support.MaxValueCountFilter;
import org.apache.directory.server.core.authz.support.MicroOperationFilter;
import org.apache.directory.server.core.authz.support.MostSpecificProtectedItemFilter;
import org.apache.directory.server.core.authz.support.MostSpecificUserClassFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.authz.support.RelatedProtectedItemFilter;
import org.apache.directory.server.core.authz.support.RelatedUserClassFilter;
import org.apache.directory.server.core.authz.support.RestrictedByFilter;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.server.core.subtree.RefinementEvaluator;
import org.apache.directory.server.core.subtree.RefinementLeafEvaluator;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.AuthenticationLevel;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ACDFEngine {
    private final ACITupleFilter[] filters;
    public static final Collection USER_LOOKUP_BYPASS;

    public ACDFEngine(OidRegistry oidRegistry, AttributeTypeRegistry attrTypeRegistry) throws NamingException {
        ExpressionEvaluator entryEvaluator = new ExpressionEvaluator(oidRegistry, attrTypeRegistry);
        SubtreeEvaluator subtreeEvaluator = new SubtreeEvaluator(oidRegistry);
        RefinementEvaluator refinementEvaluator = new RefinementEvaluator(new RefinementLeafEvaluator(oidRegistry));
        this.filters = new ACITupleFilter[]{new RelatedUserClassFilter(subtreeEvaluator), new RelatedProtectedItemFilter(refinementEvaluator, entryEvaluator, oidRegistry, attrTypeRegistry), new MaxValueCountFilter(), new MaxImmSubFilter(), new RestrictedByFilter(), new MicroOperationFilter(), new HighestPrecedenceFilter(), new MostSpecificUserClassFilter(), new MostSpecificProtectedItemFilter()};
    }

    public void checkPermission(PartitionNexusProxy proxy, Collection userGroupNames, LdapDN username, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Collection microOperations, Collection aciTuples, Attributes entry) throws NamingException {
        if (!this.hasPermission(proxy, userGroupNames, username, authenticationLevel, entryName, attrId, attrValue, microOperations, aciTuples, entry)) {
            throw new LdapNoPermissionException();
        }
    }

    public boolean hasPermission(PartitionNexusProxy proxy, Collection userGroupNames, LdapDN userName, AuthenticationLevel authenticationLevel, LdapDN entryName, String attrId, Object attrValue, Collection microOperations, Collection aciTuples, Attributes entry) throws NamingException {
        if (entryName == null) {
            throw new NullPointerException("entryName");
        }
        Attributes userEntry = proxy.lookup(userName, USER_LOOKUP_BYPASS);
        OperationScope scope = attrId == null ? OperationScope.ENTRY : (attrValue == null ? OperationScope.ATTRIBUTE_TYPE : OperationScope.ATTRIBUTE_TYPE_AND_VALUE);
        aciTuples = new ArrayList(aciTuples);
        for (int i = 0; i < this.filters.length; ++i) {
            ACITupleFilter filter = this.filters[i];
            aciTuples = filter.filter(aciTuples, scope, proxy, userGroupNames, userName, userEntry, authenticationLevel, entryName, attrId, attrValue, entry, microOperations);
        }
        if (aciTuples.size() == 0) {
            return false;
        }
        Iterator i = aciTuples.iterator();
        while (i.hasNext()) {
            ACITuple tuple = (ACITuple)i.next();
            if (tuple.isGrant()) continue;
            return false;
        }
        return true;
    }

    static {
        HashSet<String> c = new HashSet<String>();
        c.add("normalizationService");
        c.add("authenticationService");
        c.add("authorizationService");
        c.add("defaultAuthorizationService");
        c.add("schemaService");
        c.add("subentryService");
        c.add("operationalAttributeService");
        c.add("eventService");
        USER_LOOKUP_BYPASS = Collections.unmodifiableCollection(c);
    }
}

