/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.configuration;

import java.beans.PropertyEditorSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.collections.MultiHashMap;
import org.apache.directory.server.core.configuration.ConfigurationException;
import org.apache.directory.shared.ldap.ldif.LdifComposerImpl;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.util.MultiMap;
import org.apache.directory.shared.ldap.util.StringTools;

public class AttributesPropertyEditor
extends PropertyEditorSupport {
    public AttributesPropertyEditor() {
    }

    public AttributesPropertyEditor(Object source) {
        super(source);
    }

    public String getAsText() {
        LdifComposerImpl composer = new LdifComposerImpl();
        MultiMap map = new MultiMap(){
            private final MultiHashMap map = new MultiHashMap();

            public Object remove(Object arg0, Object arg1) {
                return this.map.remove(arg0, arg1);
            }

            public int size() {
                return this.map.size();
            }

            public Object get(Object arg0) {
                return this.map.get(arg0);
            }

            public boolean containsValue(Object arg0) {
                return this.map.containsValue(arg0);
            }

            public Object put(Object arg0, Object arg1) {
                return this.map.put(arg0, arg1);
            }

            public Object remove(Object arg0) {
                return this.map.remove(arg0);
            }

            public Collection values() {
                return this.map.values();
            }

            public boolean isEmpty() {
                return this.map.isEmpty();
            }

            public boolean containsKey(Object key) {
                return this.map.containsKey(key);
            }

            public void putAll(Map arg0) {
                this.map.putAll(arg0);
            }

            public void clear() {
                this.map.clear();
            }

            public Set keySet() {
                return this.map.keySet();
            }

            public Set entrySet() {
                return this.map.entrySet();
            }
        };
        Attributes attrs = (Attributes)this.getValue();
        try {
            NamingEnumeration<? extends Attribute> e = attrs.getAll();
            while (e.hasMore()) {
                Attribute attr = e.next();
                NamingEnumeration<?> e2 = attr.getAll();
                while (e2.hasMoreElements()) {
                    Object value = e2.next();
                    map.put((Object)attr.getID(), value);
                }
            }
            return composer.compose(map);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attributes readEntry(String text) {
        StringReader strIn = new StringReader(text);
        BufferedReader in = new BufferedReader(strIn);
        String line = null;
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        try {
            while ((line = in.readLine()) != null) {
                String addedLine;
                if (line.length() == 0 || StringTools.isEmpty((String)(addedLine = line.trim()))) continue;
                Attribute attribute = LdifReader.parseAttributeValue((String)addedLine);
                Attribute oldAttribute = attributes.get(attribute.getID());
                if (oldAttribute != null) {
                    try {
                        oldAttribute.add(attribute.get());
                        attributes.put(oldAttribute);
                        continue;
                    }
                    catch (NamingException ne) {
                        continue;
                    }
                }
                attributes.put(attribute);
            }
            return attributes;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return attributes;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            text = "";
        }
        this.setValue(this.readEntry(text));
    }
}

