/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.configuration.MutableInterceptorConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.interceptor.Interceptor;
import org.apache.directory.server.core.interceptor.InterceptorException;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorChain {
    private static final Logger log = LoggerFactory.getLogger((Class)InterceptorChain.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private final Interceptor FINAL_INTERCEPTOR = new Interceptor(){
        private PartitionNexus nexus;

        public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) {
            this.nexus = factoryCfg.getPartitionNexus();
        }

        public void destroy() {
        }

        public boolean compare(NextInterceptor next, LdapDN name, String oid, Object value) throws NamingException {
            return this.nexus.compare(name, oid, value);
        }

        public Attributes getRootDSE(NextInterceptor next) throws NamingException {
            return this.nexus.getRootDSE();
        }

        public LdapDN getMatchedName(NextInterceptor next, LdapDN dn) throws NamingException {
            return (LdapDN)this.nexus.getMatchedName(dn).clone();
        }

        public LdapDN getSuffix(NextInterceptor next, LdapDN dn) throws NamingException {
            return (LdapDN)this.nexus.getSuffix(dn).clone();
        }

        public Iterator listSuffixes(NextInterceptor next) throws NamingException {
            return this.nexus.listSuffixes();
        }

        public void delete(NextInterceptor next, LdapDN name) throws NamingException {
            this.nexus.delete(name);
        }

        public void add(NextInterceptor next, LdapDN normName, Attributes entry) throws NamingException {
            this.nexus.add(normName, entry);
        }

        public void modify(NextInterceptor next, LdapDN name, int modOp, Attributes mods) throws NamingException {
            this.nexus.modify(name, modOp, mods);
        }

        public void modify(NextInterceptor next, LdapDN name, ModificationItemImpl[] mods) throws NamingException {
            this.nexus.modify(name, mods);
        }

        public NamingEnumeration list(NextInterceptor next, LdapDN base) throws NamingException {
            return this.nexus.list(base);
        }

        public NamingEnumeration search(NextInterceptor next, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
            return this.nexus.search(base, env, filter, searchCtls);
        }

        public Attributes lookup(NextInterceptor next, LdapDN name) throws NamingException {
            return (Attributes)this.nexus.lookup(name).clone();
        }

        public Attributes lookup(NextInterceptor next, LdapDN dn, String[] attrIds) throws NamingException {
            return (Attributes)this.nexus.lookup(dn, attrIds).clone();
        }

        public boolean hasEntry(NextInterceptor next, LdapDN name) throws NamingException {
            return this.nexus.hasEntry(name);
        }

        public boolean isSuffix(NextInterceptor next, LdapDN name) throws NamingException {
            return this.nexus.isSuffix(name);
        }

        public void modifyRn(NextInterceptor next, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
            this.nexus.modifyRn(name, newRn, deleteOldRn);
        }

        public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName) throws NamingException {
            this.nexus.move(oriChildName, newParentName);
        }

        public void move(NextInterceptor next, LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
            this.nexus.move(oriChildName, newParentName, newRn, deleteOldRn);
        }

        public void addContextPartition(NextInterceptor next, PartitionConfiguration cfg) throws NamingException {
            this.nexus.addContextPartition(cfg);
        }

        public void removeContextPartition(NextInterceptor next, LdapDN suffix) throws NamingException {
            this.nexus.removeContextPartition(suffix);
        }

        public void bind(NextInterceptor next, LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
            this.nexus.bind(bindDn, credentials, mechanisms, saslAuthId);
        }

        public void unbind(NextInterceptor next, LdapDN bindDn) throws NamingException {
            this.nexus.unbind(bindDn);
        }
    };
    private final Map name2entry = new HashMap();
    private final Entry tail;
    private Entry head;
    private DirectoryServiceConfiguration factoryCfg;

    public InterceptorChain() {
        MutableInterceptorConfiguration tailCfg = new MutableInterceptorConfiguration();
        tailCfg.setName("tail");
        tailCfg.setInterceptor(this.FINAL_INTERCEPTOR);
        this.head = this.tail = new Entry(null, null, tailCfg);
    }

    public synchronized void init(DirectoryServiceConfiguration factoryCfg) throws NamingException {
        this.factoryCfg = factoryCfg;
        this.FINAL_INTERCEPTOR.init(factoryCfg, null);
        ListIterator i = factoryCfg.getStartupConfiguration().getInterceptorConfigurations().listIterator();
        Interceptor interceptor = null;
        try {
            while (i.hasNext()) {
                InterceptorConfiguration cfg = (InterceptorConfiguration)i.next();
                if (IS_DEBUG) {
                    log.debug("Adding interceptor " + cfg.getName());
                }
                this.register(cfg);
            }
        }
        catch (Throwable t) {
            this.destroy();
            if (t instanceof NamingException) {
                throw (NamingException)t;
            }
            throw new InterceptorException(interceptor, "Failed to initialize interceptor chain.", t);
        }
    }

    public synchronized void destroy() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        Entry e = this.tail;
        do {
            entries.add(e);
        } while ((e = e.prevEntry) != null);
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            e = (Entry)i.next();
            if (e == this.tail) continue;
            try {
                this.deregister(e.configuration.getName());
            }
            catch (Throwable t) {
                log.warn("Failed to deregister an interceptor: " + e.configuration.getName(), t);
            }
        }
    }

    public Interceptor get(String interceptorName) {
        Entry e = (Entry)this.name2entry.get(interceptorName);
        if (e == null) {
            return null;
        }
        return e.configuration.getInterceptor();
    }

    public synchronized List getAll() {
        ArrayList<Interceptor> result = new ArrayList<Interceptor>();
        Entry e = this.head;
        do {
            result.add(e.configuration.getInterceptor());
        } while ((e = e.nextEntry) != this.tail);
        return result;
    }

    public synchronized void addFirst(InterceptorConfiguration cfg) throws NamingException {
        this.register0(cfg, this.head);
    }

    public synchronized void addLast(InterceptorConfiguration cfg) throws NamingException {
        this.register0(cfg, this.tail);
    }

    public synchronized void addBefore(String nextInterceptorName, InterceptorConfiguration cfg) throws NamingException {
        Entry e = (Entry)this.name2entry.get(nextInterceptorName);
        if (e == null) {
            throw new ConfigurationException("Interceptor not found: " + nextInterceptorName);
        }
        this.register0(cfg, e);
    }

    public synchronized InterceptorConfiguration remove(String interceptorName) throws NamingException {
        return this.deregister(interceptorName);
    }

    public synchronized void addAfter(String prevInterceptorName, InterceptorConfiguration cfg) throws NamingException {
        Entry e = (Entry)this.name2entry.get(prevInterceptorName);
        if (e == null) {
            throw new ConfigurationException("Interceptor not found: " + prevInterceptorName);
        }
        this.register0(cfg, e.nextEntry);
    }

    private void register(InterceptorConfiguration cfg) throws NamingException {
        this.checkAddable(cfg);
        this.register0(cfg, this.tail);
    }

    private InterceptorConfiguration deregister(String name) throws ConfigurationException {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        if (nextEntry == null) {
            return null;
        }
        if (prevEntry == null) {
            nextEntry.prevEntry = null;
            this.head = nextEntry;
        } else {
            prevEntry.nextEntry = nextEntry;
            nextEntry.prevEntry = prevEntry;
        }
        this.name2entry.remove(name);
        entry.configuration.getInterceptor().destroy();
        return entry.configuration;
    }

    private void register0(InterceptorConfiguration cfg, Entry nextEntry) throws NamingException {
        Entry newEntry;
        String name = cfg.getName();
        Interceptor interceptor = cfg.getInterceptor();
        interceptor.init(this.factoryCfg, cfg);
        if (nextEntry == this.head) {
            newEntry = new Entry(null, this.head, cfg);
            this.head.prevEntry = newEntry;
            this.head = newEntry;
        } else if (this.head == this.tail) {
            newEntry = new Entry(null, this.tail, cfg);
            this.tail.prevEntry = newEntry;
            this.head = newEntry;
        } else {
            newEntry = new Entry(nextEntry.prevEntry, nextEntry, cfg);
            nextEntry.prevEntry.nextEntry = newEntry;
            nextEntry.prevEntry = newEntry;
        }
        this.name2entry.put(name, newEntry);
    }

    private Entry checkOldName(String baseName) throws ConfigurationException {
        Entry e = (Entry)this.name2entry.get(baseName);
        if (e == null) {
            throw new ConfigurationException("Unknown interceptor name:" + baseName);
        }
        return e;
    }

    private void checkAddable(InterceptorConfiguration cfg) throws ConfigurationException {
        if (this.name2entry.containsKey(cfg.getName())) {
            throw new ConfigurationException("Other interceptor is using name '" + cfg.getName() + "'");
        }
    }

    private Entry getStartingEntry() {
        if (InvocationStack.getInstance().isEmpty()) {
            return this.head;
        }
        Invocation invocation = InvocationStack.getInstance().peek();
        if (!invocation.hasBypass()) {
            return this.head;
        }
        if (invocation.isBypassed("*")) {
            return this.tail;
        }
        Entry next = this.head;
        while (next != this.tail) {
            if (invocation.isBypassed(next.configuration.getName())) {
                next = next.nextEntry;
                continue;
            }
            return next;
        }
        return this.tail;
    }

    public Attributes getRootDSE() throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getRootDSE(next);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public LdapDN getMatchedName(LdapDN name) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getMatchedName(next, name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public LdapDN getSuffix(LdapDN name) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.getSuffix(next, name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.compare(next, name, oid, value);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Iterator listSuffixes() throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.listSuffixes(next);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void addContextPartition(PartitionConfiguration cfg) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.addContextPartition(next, cfg);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void removeContextPartition(LdapDN suffix) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.removeContextPartition(next, suffix);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void delete(LdapDN name) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.delete(next, name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void add(LdapDN normName, Attributes entry) throws NamingException {
        Entry node = this.getStartingEntry();
        Interceptor head = node.configuration.getInterceptor();
        NextInterceptor next = node.nextInterceptor;
        try {
            head.add(next, normName, entry);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        Entry node = this.getStartingEntry();
        Interceptor head = node.configuration.getInterceptor();
        NextInterceptor next = node.nextInterceptor;
        try {
            head.bind(next, bindDn, credentials, mechanisms, saslAuthId);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void unbind(LdapDN bindDn) throws NamingException {
        Entry node = this.getStartingEntry();
        Interceptor head = node.configuration.getInterceptor();
        NextInterceptor next = node.nextInterceptor;
        try {
            head.unbind(next, bindDn);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void modify(LdapDN name, int modOp, Attributes mods) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.modify(next, name, modOp, mods);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void modify(LdapDN name, ModificationItemImpl[] mods) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.modify(next, name, mods);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public NamingEnumeration list(LdapDN base) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.list(next, base);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public NamingEnumeration search(LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.search(next, base, env, filter, searchCtls);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Attributes lookup(LdapDN name) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.lookup(next, name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public Attributes lookup(LdapDN dn, String[] attrIds) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.lookup(next, dn, attrIds);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean hasEntry(LdapDN name) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.hasEntry(next, name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public boolean isSuffix(LdapDN name) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            return head.isSuffix(next, name);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
            throw new InternalError();
        }
    }

    public void modifyRn(LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.modifyRn(next, name, newRn, deleteOldRn);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.move(next, oriChildName, newParentName);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        Entry entry = this.getStartingEntry();
        Interceptor head = entry.configuration.getInterceptor();
        NextInterceptor next = entry.nextInterceptor;
        try {
            head.move(next, oriChildName, newParentName, newRn, deleteOldRn);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Throwable e) {
            InterceptorChain.throwInterceptorException(head, e);
        }
    }

    private static void throwInterceptorException(Interceptor interceptor, Throwable e) throws InterceptorException {
        throw new InterceptorException(interceptor, "Unexpected exception.", e);
    }

    private class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final InterceptorConfiguration configuration;
        private final NextInterceptor nextInterceptor;

        private Entry(Entry prevEntry, Entry nextEntry, InterceptorConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException("configuration");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.configuration = configuration;
            this.nextInterceptor = new NextInterceptor(){

                private Entry getNextEntry() {
                    if (InvocationStack.getInstance().isEmpty()) {
                        return Entry.this.nextEntry;
                    }
                    Invocation invocation = InvocationStack.getInstance().peek();
                    if (!invocation.hasBypass()) {
                        return Entry.this.nextEntry;
                    }
                    Entry next = Entry.this.nextEntry;
                    while (next != InterceptorChain.this.tail) {
                        if (invocation.isBypassed(next.configuration.getName())) {
                            next = next.nextEntry;
                            continue;
                        }
                        return next;
                    }
                    return next;
                }

                public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.compare(next.nextInterceptor, name, oid, value);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public Attributes getRootDSE() throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.getRootDSE(next.nextInterceptor);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public LdapDN getMatchedName(LdapDN dn) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.getMatchedName(next.nextInterceptor, dn);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public LdapDN getSuffix(LdapDN dn) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.getSuffix(next.nextInterceptor, dn);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public Iterator listSuffixes() throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.listSuffixes(next.nextInterceptor);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public void delete(LdapDN name) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.delete(next.nextInterceptor, name);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void add(LdapDN normName, Attributes entry) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.add(next.nextInterceptor, normName, entry);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void modify(LdapDN name, int modOp, Attributes mods) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.modify(next.nextInterceptor, name, modOp, mods);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void modify(LdapDN name, ModificationItemImpl[] mods) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.modify(next.nextInterceptor, name, mods);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public NamingEnumeration list(LdapDN base) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.list(next.nextInterceptor, base);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public NamingEnumeration search(LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.search(next.nextInterceptor, base, env, filter, searchCtls);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public Attributes lookup(LdapDN name) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.lookup(next.nextInterceptor, name);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public Attributes lookup(LdapDN dn, String[] attrIds) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.lookup(next.nextInterceptor, dn, attrIds);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public boolean hasEntry(LdapDN name) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.hasEntry(next.nextInterceptor, name);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public boolean isSuffix(LdapDN name) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        return interceptor.isSuffix(next.nextInterceptor, name);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public void modifyRn(LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.modifyRn(next.nextInterceptor, name, newRn, deleteOldRn);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void move(LdapDN oriChildName, LdapDN newParentName) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.move(next.nextInterceptor, oriChildName, newParentName);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void move(LdapDN oriChildName, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.move(next.nextInterceptor, oriChildName, newParentName, newRn, deleteOldRn);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.bind(next.nextInterceptor, bindDn, credentials, mechanisms, saslAuthId);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void unbind(LdapDN bindDn) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.unbind(next.nextInterceptor, bindDn);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                    }
                }

                public void addContextPartition(PartitionConfiguration cfg) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.addContextPartition(next.nextInterceptor, cfg);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }

                public void removeContextPartition(LdapDN suffix) throws NamingException {
                    Entry next = this.getNextEntry();
                    Interceptor interceptor = next.configuration.getInterceptor();
                    try {
                        interceptor.removeContextPartition(next.nextInterceptor, suffix);
                    }
                    catch (NamingException ne) {
                        throw ne;
                    }
                    catch (Throwable e) {
                        InterceptorChain.throwInterceptorException(interceptor, e);
                        throw new InternalError();
                    }
                }
            };
        }
    }
}

