/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceListener;
import org.apache.directory.server.core.configuration.AddPartitionConfiguration;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.RemovePartitionConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.configuration.SyncConfiguration;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public abstract class AbstractContextFactory
implements InitialContextFactory,
DirectoryServiceListener {
    protected AbstractContextFactory() {
    }

    public final synchronized Context getInitialContext(Hashtable env) throws NamingException {
        Configuration cfg = Configuration.toConfiguration(env);
        env = (Hashtable)env.clone();
        LdapDN principalDn = null;
        if (env.containsKey("java.naming.security.principal") && env.get("java.naming.security.principal") instanceof LdapDN) {
            principalDn = (LdapDN)env.get("java.naming.security.principal");
        }
        String principal = AbstractContextFactory.getPrincipal(env);
        byte[] credential = AbstractContextFactory.getCredential(env);
        String authentication = AbstractContextFactory.getAuthentication(env);
        String providerUrl = AbstractContextFactory.getProviderUrl(env);
        DirectoryService service = DirectoryService.getInstance(cfg.getInstanceId());
        if (cfg instanceof ShutdownConfiguration) {
            service.shutdown();
        } else if (cfg instanceof SyncConfiguration) {
            service.sync();
        } else if (cfg instanceof StartupConfiguration) {
            service.startup(this, env);
        } else if (cfg instanceof AddPartitionConfiguration) {
            new PartitionNexusProxy(service.getJndiContext(principalDn, principal, credential, authentication, ""), service).addContextPartition(((AddPartitionConfiguration)cfg).getDirectoryPartitionConfiguration());
        } else if (cfg instanceof RemovePartitionConfiguration) {
            Context ctx = service.getJndiContext(principalDn, principal, credential, authentication, "");
            PartitionNexusProxy proxy = new PartitionNexusProxy(ctx, service);
            proxy.removeContextPartition(((RemovePartitionConfiguration)cfg).getSuffix());
        } else if (service == null) {
            throw new NamingException("Unknown configuration: " + cfg);
        }
        return service.getJndiContext(principalDn, principal, credential, authentication, providerUrl);
    }

    public static String getProviderUrl(Hashtable env) {
        Object value = env.get("java.naming.provider.url");
        if (value == null) {
            value = "";
        }
        String providerUrl = value.toString();
        env.put("java.naming.provider.url", providerUrl);
        return providerUrl;
    }

    public static String getAuthentication(Hashtable env) {
        Object value = env.get("java.naming.security.authentication");
        String authentication = value == null ? "none" : value.toString();
        env.put("java.naming.security.authentication", authentication);
        return authentication;
    }

    public static byte[] getCredential(Hashtable env) throws ConfigurationException {
        byte[] credential;
        Object value = env.get("java.naming.security.credentials");
        if (value == null) {
            credential = null;
        } else if (value instanceof String) {
            credential = StringTools.getBytesUtf8((String)((String)value));
        } else if (value instanceof byte[]) {
            credential = (byte[])value;
        } else {
            throw new ConfigurationException("Can't convert 'java.naming.security.credentials' to byte[].");
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        return credential;
    }

    public static String getPrincipal(Hashtable env) {
        String principal;
        Object value = env.get("java.naming.security.principal");
        if (value == null) {
            principal = null;
        } else {
            principal = value.toString();
            env.put("java.naming.security.principal", principal);
        }
        return principal;
    }
}

