/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;

class JavaLdapSupport {
    public static final String TOP_ATTR = "top";
    public static final String JOBJECT_ATTR = "javaObject";
    public static final String OBJECTCLASS_ATTR = "objectClass";
    public static final String JCONTAINER_ATTR = "javaContainer";
    public static final String JSERIALIZEDOBJ_ATTR = "javaSerializedObject";
    public static final String JCLASSNAME_ATTR = "javaClassName";
    public static final String JCLASSNAMES_ATTR = "javaClassNames";
    public static final String JSERIALDATA_ATTR = "javaSerializedData";

    JavaLdapSupport() {
    }

    static Object deserialize(Attributes attributes) throws NamingException {
        ObjectInputStream in = null;
        String className = (String)attributes.get(JCLASSNAME_ATTR).get();
        try {
            byte[] data = (byte[])attributes.get(JSERIALDATA_ATTR).get();
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("De-serialization of '" + className + "' instance failed:\n" + e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new NamingException("object deserialization stream close() failure");
            }
        }
    }

    static byte[] serialize(Object obj) throws NamingException {
        ByteArrayOutputStream bytesOut = null;
        ObjectOutputStream out = null;
        try {
            bytesOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bytesOut);
            out.writeObject(obj);
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Serialization of '" + obj + "' failed:\n" + e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new NamingException("object serialization stream close() failure");
            }
        }
    }

    static void serialize(Attributes entry, Object obj) throws NamingException {
        LockableAttributeImpl objectClass = new LockableAttributeImpl(OBJECTCLASS_ATTR);
        objectClass.add(TOP_ATTR);
        objectClass.add(JOBJECT_ATTR);
        objectClass.add(JCONTAINER_ATTR);
        objectClass.add(JSERIALIZEDOBJ_ATTR);
        entry.put((Attribute)objectClass);
        entry.put(JCLASSNAME_ATTR, obj.getClass().getName());
        entry.put(JSERIALDATA_ATTR, JavaLdapSupport.serialize(obj));
        Class<?>[] classes = obj.getClass().getClasses();
        LockableAttributeImpl javaClassNames = new LockableAttributeImpl(JCLASSNAMES_ATTR);
        for (int ii = 0; ii < classes.length; ++ii) {
            javaClassNames.add(classes[ii].getName());
        }
        entry.put((Attribute)javaClassNames);
    }
}

