/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.authn.AuthenticationService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.jndi.JavaLdapSupport;
import org.apache.directory.server.core.jndi.LdapJndiProperties;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.PartitionNexusProxy;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.StringTools;

public abstract class ServerContext
implements EventContext {
    public static final String DELETE_OLD_RDN_PROP = "java.naming.ldap.deleteRDN";
    private final DirectoryService service;
    private final PartitionNexus nexusProxy;
    private final Hashtable env;
    private final LdapDN dn;
    private final Set listeners = new HashSet();
    private LdapPrincipal principal;

    protected ServerContext(DirectoryService service, Hashtable env) throws NamingException {
        this.service = service;
        this.nexusProxy = new PartitionNexusProxy(this, service);
        DirectoryServiceConfiguration cfg = service.getConfiguration();
        this.env = (Hashtable)cfg.getEnvironment().clone();
        this.env.putAll(env);
        LdapJndiProperties props = LdapJndiProperties.getLdapJndiProperties(this.env);
        this.dn = props.getProviderDn();
        this.nexusProxy.bind(props.getBindDn(), props.getCredentials(), props.getAuthenticationMechanisms(), props.getSaslAuthId());
        if (!this.nexusProxy.hasEntry(this.dn)) {
            throw new NameNotFoundException(this.dn + " does not exist");
        }
        if (this.dn.size() == 0) {
            return;
        }
    }

    protected ServerContext(DirectoryService service, LdapPrincipal principal, Name dn) throws NamingException {
        this.service = service;
        this.dn = (LdapDN)dn.clone();
        this.env = (Hashtable)service.getConfiguration().getEnvironment().clone();
        this.env.put("java.naming.provider.url", dn.toString());
        this.nexusProxy = new PartitionNexusProxy(this, service);
        this.principal = principal;
    }

    public DirectoryService getService() {
        return this.service;
    }

    public LdapPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(AuthenticationService.TrustedPrincipalWrapper wrapper) {
        this.principal = wrapper.getPrincipal();
    }

    protected PartitionNexus getNexusProxy() {
        return this.nexusProxy;
    }

    protected Name getDn() {
        return this.dn;
    }

    public void close() throws NamingException {
        Iterator list = this.listeners.iterator();
        while (list.hasNext()) {
            ((PartitionNexusProxy)this.nexusProxy).removeNamingListener(this, (NamingListener)list.next());
        }
    }

    public String getNameInNamespace() throws NamingException {
        return this.dn.toString();
    }

    public Hashtable getEnvironment() {
        return this.env;
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext((Name)new LdapDN(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        LockableAttributesImpl attributes = new LockableAttributesImpl();
        LdapDN target = this.buildTarget(name);
        this.injectRdnAttributeValues(target, (Attributes)attributes);
        attributes.put("objectClass", "javaContainer");
        attributes.put("objectClass", "top");
        this.nexusProxy.add(target, (Attributes)attributes);
        return new ServerLdapContext(this.service, this.principal, (Name)target);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext((Name)new LdapDN(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        LdapDN target = this.buildTarget(name);
        if (target.size() == 0) {
            throw new LdapNoPermissionException("can't delete the rootDSE");
        }
        this.nexusProxy.delete(target);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind((Name)new LdapDN(name), obj);
    }

    private void injectRdnAttributeValues(LdapDN target, Attributes attributes) throws NamingException {
        Rdn rdn = target.getRdn(target.size() - 1);
        if (rdn.size() == 1) {
            attributes.put(rdn.getUpType(), rdn.getValue());
        } else {
            Iterator ii = rdn.iterator();
            while (ii.hasNext()) {
                AttributeTypeAndValue atav = (AttributeTypeAndValue)ii.next();
                attributes.put(atav.getUpType(), atav.getValue());
            }
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        DirStateFactory.Result res = DirectoryManager.getStateToBind(obj, name, this, this.env, null);
        Attributes outAttrs = res.getAttributes();
        if (outAttrs != null) {
            LdapDN target = this.buildTarget(name);
            this.nexusProxy.add(target, outAttrs);
            return;
        }
        if (obj instanceof Referenceable) {
            throw new NamingException("Do not know how to store Referenceables yet!");
        }
        if (obj instanceof Reference) {
            throw new NamingException("Do not know how to store References yet!");
        }
        if (obj instanceof Serializable) {
            LockableAttributesImpl attributes = new LockableAttributesImpl();
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapDN target = this.buildTarget(name);
            this.injectRdnAttributeValues(target, (Attributes)attributes);
            JavaLdapSupport.serialize((Attributes)attributes, obj);
            this.nexusProxy.add(target, (Attributes)attributes);
        } else if (obj instanceof DirContext) {
            Attributes attributes = ((DirContext)obj).getAttributes("");
            if (outAttrs != null && outAttrs.size() > 0) {
                NamingEnumeration<? extends Attribute> list = outAttrs.getAll();
                while (list.hasMore()) {
                    attributes.put(list.next());
                }
            }
            LdapDN target = this.buildTarget(name);
            this.injectRdnAttributeValues(target, attributes);
            this.nexusProxy.add(target, attributes);
        } else {
            throw new NamingException("Can't find a way to bind: " + obj);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename((Name)new LdapDN(oldName), (Name)new LdapDN(newName));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        LdapDN oldDn = this.buildTarget(oldName);
        LdapDN newDn = this.buildTarget(newName);
        if (oldDn.size() == 0) {
            throw new LdapNoPermissionException("can't rename the rootDSE");
        }
        LdapDN oldBase = (LdapDN)oldName.clone();
        oldBase.remove(oldName.size() - 1);
        LdapDN newBase = (LdapDN)newName.clone();
        newBase.remove(newName.size() - 1);
        String newRdn = newName.get(newName.size() - 1);
        String oldRdn = oldName.get(oldName.size() - 1);
        boolean delOldRdn = true;
        if (null != this.env.get(DELETE_OLD_RDN_PROP)) {
            String delOldRdnStr = (String)this.env.get(DELETE_OLD_RDN_PROP);
            delOldRdn = !delOldRdnStr.equals("false");
            delOldRdn = delOldRdn || delOldRdnStr.equals("no");
            boolean bl = delOldRdn = delOldRdn || delOldRdnStr.equals("0");
        }
        if (oldName.size() == newName.size() && oldBase.equals((Object)newBase)) {
            this.nexusProxy.modifyRn(oldDn, newRdn, delOldRdn);
        } else {
            LdapDN parent = (LdapDN)newDn.clone();
            parent.remove(newDn.size() - 1);
            if (newRdn.equalsIgnoreCase(oldRdn)) {
                this.nexusProxy.move(oldDn, parent);
            } else {
                this.nexusProxy.move(oldDn, parent, newRdn, delOldRdn);
            }
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind((Name)new LdapDN(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        LdapDN target = this.buildTarget(name);
        if (this.nexusProxy.hasEntry(target)) {
            this.nexusProxy.delete(target);
        }
        this.bind(name, obj);
    }

    public void unbind(String name) throws NamingException {
        this.unbind((Name)new LdapDN(name));
    }

    public void unbind(Name name) throws NamingException {
        this.nexusProxy.delete(this.buildTarget(name));
    }

    public Object lookup(String name) throws NamingException {
        if (StringTools.isEmpty((String)name)) {
            return this.lookup((Name)LdapDN.EMPTY_LDAPDN);
        }
        return this.lookup((Name)new LdapDN(name));
    }

    public Object lookup(Name name) throws NamingException {
        Object obj;
        LdapDN target = this.buildTarget(name);
        Attributes attributes = this.nexusProxy.lookup(target);
        try {
            obj = DirectoryManager.getObjectInstance(null, name, this, this.env, attributes);
        }
        catch (Exception e) {
            String msg = "Failed to create an object for " + target;
            msg = msg + " using object factories within the context's environment.";
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e);
            throw ne;
        }
        if (obj != null) {
            return obj;
        }
        if (attributes.get("javaClassName") != null) {
            return JavaLdapSupport.deserialize(attributes);
        }
        ServerLdapContext ctx = new ServerLdapContext(this.service, this.principal, (Name)target);
        Control[] controls = ((ServerLdapContext)this).getRequestControls();
        if (null != controls) {
            ctx.setRequestControls((Control[])controls.clone());
        }
        return ctx;
    }

    public Object lookupLink(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                return new LdapDN(name);
            }
        };
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParser(){

            public Name parse(String name) throws NamingException {
                return new LdapDN(name);
            }
        };
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list((Name)new LdapDN(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.nexusProxy.list(this.buildTarget(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings((Name)new LdapDN(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        LdapDN base = this.buildTarget(name);
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(1);
        return this.nexusProxy.search(base, this.getEnvironment(), (ExprNode)filter, ctls);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName((Name)new LdapDN(name), (Name)new LdapDN(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (prefix == null || prefix.size() == 0) {
            return name;
        }
        LdapDN fqn = this.buildTarget(name);
        String head = prefix.get(0);
        while (fqn.size() > 0) {
            if (fqn.get(0).equalsIgnoreCase(head)) {
                return fqn;
            }
            fqn.remove(0);
        }
        String msg = "The prefix '" + prefix + "' is not an ancestor of this ";
        msg = msg + "entry '" + this.dn + "'";
        throw new NamingException(msg);
    }

    public void addNamingListener(Name name, int scope, NamingListener namingListener) throws NamingException {
        PresenceNode filter = new PresenceNode("objectClass");
        SearchControls controls = new SearchControls();
        controls.setSearchScope(scope);
        ((PartitionNexusProxy)this.nexusProxy).addNamingListener(this, (Name)this.buildTarget(name), (ExprNode)filter, controls, namingListener);
        this.listeners.add(namingListener);
    }

    public void addNamingListener(String name, int scope, NamingListener namingListener) throws NamingException {
        this.addNamingListener((Name)new LdapDN(name), scope, namingListener);
    }

    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        ((PartitionNexusProxy)this.nexusProxy).removeNamingListener(this, namingListener);
        this.listeners.remove(namingListener);
    }

    public boolean targetMustExist() throws NamingException {
        return false;
    }

    protected Set getListeners() {
        return this.listeners;
    }

    LdapDN buildTarget(Name relativeName) throws InvalidNameException {
        LdapDN target = (LdapDN)this.dn.clone();
        target.addAll(target.size(), relativeName);
        return target;
    }
}

