/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.core.normalization.UndefinedFilterAttributeException;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizingVisitor
implements FilterVisitor {
    private static final Logger log = LoggerFactory.getLogger((Class)NormalizingVisitor.class);
    private final NameComponentNormalizer ncn;
    private final OidRegistry registry;

    public NormalizingVisitor(NameComponentNormalizer ncn, OidRegistry registry) {
        this.ncn = ncn;
        this.registry = registry;
    }

    public void visit(ExprNode node) {
        if (node instanceof PresenceNode) {
            PresenceNode pnode = (PresenceNode)node;
            try {
                pnode.setAttribute(this.registry.getOid(pnode.getAttribute()));
            }
            catch (NamingException e) {
                log.error("Failed to normalize filter node attribute: " + pnode.getAttribute(), (Throwable)e);
                RuntimeException rte = new RuntimeException(e.getMessage());
                rte.initCause(e);
                throw rte;
            }
            return;
        }
        if (node instanceof SimpleNode) {
            Object normalized;
            SimpleNode snode = (SimpleNode)node;
            try {
                normalized = !this.ncn.isDefined(snode.getAttribute()) ? snode.getValue() : (Character.isDigit(snode.getAttribute().charAt(0)) ? (snode.getValue() instanceof String ? this.ncn.normalizeByOid(snode.getAttribute(), (String)snode.getValue()) : (snode.getValue() instanceof byte[] ? this.ncn.normalizeByOid(snode.getAttribute(), (byte[])snode.getValue()) : this.ncn.normalizeByOid(snode.getAttribute(), snode.getValue().toString()))) : (snode.getValue() instanceof String ? this.ncn.normalizeByName(snode.getAttribute(), (String)snode.getValue()) : (snode.getValue() instanceof byte[] ? this.ncn.normalizeByName(snode.getAttribute(), (byte[])snode.getValue()) : this.ncn.normalizeByName(snode.getAttribute(), snode.getValue().toString()))));
            }
            catch (NamingException e) {
                log.error("Failed to normalize filter value: " + e.getMessage(), (Throwable)e);
                RuntimeException rte = new RuntimeException(e.getMessage());
                rte.initCause(e);
                throw rte;
            }
            try {
                snode.setAttribute(this.registry.getOid(snode.getAttribute()));
            }
            catch (NamingException e) {
                log.error("Failed to normalize filter node attribute: " + snode.getAttribute(), (Throwable)e);
                UndefinedFilterAttributeException rte = new UndefinedFilterAttributeException((LeafNode)snode, e.getMessage());
                rte.initCause(e);
                throw rte;
            }
            snode.setValue(normalized);
            return;
        }
        if (node instanceof BranchNode) {
            int ii;
            BranchNode bnode = (BranchNode)node;
            StringBuffer buf = null;
            for (ii = 0; ii < bnode.getChildren().size(); ++ii) {
                LeafNode ln;
                ExprNode child = (ExprNode)bnode.getChildren().get(ii);
                if (child.isLeaf() && !this.ncn.isDefined((ln = (LeafNode)child).getAttribute())) {
                    if (log.isWarnEnabled()) {
                        if (buf == null) {
                            buf = new StringBuffer();
                        } else {
                            buf.setLength(0);
                        }
                        buf.append("Removing leaf node based on undefined attribute '");
                        buf.append(ln.getAttribute());
                        buf.append("' from filter.");
                        log.warn(buf.toString());
                    }
                    bnode.getChildren().remove(child);
                    if (bnode.getOperator() != 10) {
                        bnode.set((Object)"undefined", (Object)Boolean.TRUE);
                    } else {
                        bnode.set((Object)"undefined", (Object)Boolean.FALSE);
                    }
                    --ii;
                    continue;
                }
                try {
                    this.visit(child);
                    continue;
                }
                catch (UndefinedFilterAttributeException e) {
                    bnode.getChildren().remove(ii);
                    if (bnode.getOperator() != 10) {
                        bnode.set((Object)"undefined", (Object)Boolean.TRUE);
                    } else {
                        bnode.set((Object)"undefined", (Object)Boolean.FALSE);
                    }
                    --ii;
                }
            }
            for (ii = 0; ii < bnode.getChildren().size(); ++ii) {
                ExprNode unknown = (ExprNode)bnode.getChildren().get(ii);
                if (unknown.isLeaf()) continue;
                BranchNode child = (BranchNode)unknown;
                if (child.getChildren().size() == 0 || child.get((Object)"undefined") == Boolean.TRUE) {
                    bnode.getChildren().remove(child);
                    --ii;
                    continue;
                }
                if (child.getChildren().size() != 1 || child.getOperator() == 11) continue;
                bnode.getChildren().remove(child);
                if (ii >= bnode.getChildren().size()) {
                    bnode.getChildren().add(child.getChild());
                    continue;
                }
                bnode.getChildren().add(ii, child.getChild());
            }
        }
    }

    public boolean canVisit(ExprNode node) {
        return true;
    }

    public boolean isPrefix() {
        return false;
    }

    public ArrayList getOrder(BranchNode node, ArrayList children) {
        return children;
    }
}

