/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.InterceptorConfiguration;
import org.apache.directory.server.core.enumeration.SearchResultFilter;
import org.apache.directory.server.core.enumeration.SearchResultFilteringEnumeration;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.invocation.Invocation;
import org.apache.directory.server.core.invocation.InvocationStack;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.DateUtils;

public class OperationalAttributeService
extends BaseInterceptor {
    private final SearchResultFilter DENORMALIZING_SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            if (controls.getReturningAttributes() != null) {
                return OperationalAttributeService.this.filterDenormalized(result.getAttributes());
            }
            return true;
        }
    };
    private final SearchResultFilter SEARCH_FILTER = new SearchResultFilter(){

        public boolean accept(Invocation invocation, SearchResult result, SearchControls controls) throws NamingException {
            if (controls.getReturningAttributes() == null) {
                return OperationalAttributeService.this.filter(result.getAttributes());
            }
            return true;
        }
    };
    private PartitionNexus nexus;
    private AttributeTypeRegistry registry;
    private boolean isDenormalizeOpAttrsEnabled;
    private AttributeType refAttrOid = null;

    public void init(DirectoryServiceConfiguration factoryCfg, InterceptorConfiguration cfg) throws NamingException {
        this.nexus = factoryCfg.getPartitionNexus();
        this.registry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        this.isDenormalizeOpAttrsEnabled = factoryCfg.getStartupConfiguration().isDenormalizeOpAttrsEnabled();
        this.refAttrOid = this.registry.lookup("ref");
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, LdapDN normName, Attributes entry) throws NamingException {
        String principal = OperationalAttributeService.getPrincipal().getName();
        LockableAttributeImpl attribute = new LockableAttributeImpl("creatorsName");
        attribute.add(principal);
        entry.put((Attribute)attribute);
        attribute = new LockableAttributeImpl("createTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        entry.put((Attribute)attribute);
        nextInterceptor.add(normName, entry);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, int modOp, Attributes attrs) throws NamingException {
        nextInterceptor.modify(name, modOp, attrs);
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        LockableAttributeImpl attribute = new LockableAttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new LockableAttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        this.nexus.modify(name, 2, (Attributes)attributes);
    }

    public void modify(NextInterceptor nextInterceptor, LdapDN name, ModificationItemImpl[] items) throws NamingException {
        nextInterceptor.modify(name, items);
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        LockableAttributeImpl attribute = new LockableAttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new LockableAttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        this.nexus.modify(name, 2, (Attributes)attributes);
    }

    public void modifyRn(NextInterceptor nextInterceptor, LdapDN name, String newRn, boolean deleteOldRn) throws NamingException {
        nextInterceptor.modifyRn(name, newRn, deleteOldRn);
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        LockableAttributeImpl attribute = new LockableAttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new LockableAttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        LdapDN newDn = (LdapDN)name.clone();
        newDn.remove(name.size() - 1);
        newDn.add(newRn);
        newDn.normalize(this.registry.getNormalizerMapping());
        this.nexus.modify(newDn, 2, (Attributes)attributes);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN name, LdapDN newParentName) throws NamingException {
        nextInterceptor.move(name, newParentName);
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        LockableAttributeImpl attribute = new LockableAttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new LockableAttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        this.nexus.modify(newParentName, 2, (Attributes)attributes);
    }

    public void move(NextInterceptor nextInterceptor, LdapDN name, LdapDN newParentName, String newRn, boolean deleteOldRn) throws NamingException {
        nextInterceptor.move(name, newParentName, newRn, deleteOldRn);
        LockableAttributesImpl attributes = new LockableAttributesImpl(true);
        LockableAttributeImpl attribute = new LockableAttributeImpl("modifiersName");
        attribute.add(OperationalAttributeService.getPrincipal().getName());
        attributes.put((Attribute)attribute);
        attribute = new LockableAttributeImpl("modifyTimestamp");
        attribute.add(DateUtils.getGeneralizedTime());
        attributes.put((Attribute)attribute);
        this.nexus.modify(newParentName, 2, (Attributes)attributes);
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name) throws NamingException {
        Attributes result = nextInterceptor.lookup(name);
        if (result == null) {
            return null;
        }
        this.filter(result);
        return result;
    }

    public Attributes lookup(NextInterceptor nextInterceptor, LdapDN name, String[] attrIds) throws NamingException {
        Attributes result = nextInterceptor.lookup(name, attrIds);
        if (result == null) {
            return null;
        }
        this.filter((Name)name, result, attrIds);
        return result;
    }

    public NamingEnumeration list(NextInterceptor nextInterceptor, LdapDN base) throws NamingException {
        NamingEnumeration e = nextInterceptor.list(base);
        Invocation invocation = InvocationStack.getInstance().peek();
        return new SearchResultFilteringEnumeration(e, new SearchControls(), invocation, this.SEARCH_FILTER);
    }

    public NamingEnumeration search(NextInterceptor nextInterceptor, LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        Invocation invocation = InvocationStack.getInstance().peek();
        NamingEnumeration e = nextInterceptor.search(base, env, filter, searchCtls);
        if (searchCtls.getReturningAttributes() != null) {
            if (this.isDenormalizeOpAttrsEnabled) {
                return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.DENORMALIZING_SEARCH_FILTER);
            }
            return e;
        }
        return new SearchResultFilteringEnumeration(e, searchCtls, invocation, this.SEARCH_FILTER);
    }

    private boolean filter(Attributes attributes) throws NamingException {
        NamingEnumeration<String> list = attributes.getIDs();
        while (list.hasMore()) {
            String attrId = list.next();
            AttributeType type = null;
            if (this.registry.hasAttributeType(attrId)) {
                type = this.registry.lookup(attrId);
            }
            if (type == null || type.getUsage() == UsageEnum.USERAPPLICATIONS || type.getOid().equals(this.refAttrOid.getOid())) continue;
            attributes.remove(attrId);
        }
        return true;
    }

    private void filter(Name dn, Attributes entry, String[] ids) throws NamingException {
        if (ids == null) {
            this.filter(entry);
            return;
        }
        if (dn.size() == 0) {
            HashSet<String> idsSet = new HashSet<String>(ids.length);
            for (int ii = 0; ii < ids.length; ++ii) {
                idsSet.add(ids[ii].toLowerCase());
            }
            NamingEnumeration<String> list = entry.getIDs();
            while (list.hasMore()) {
                String attrId = ((String)list.nextElement()).toLowerCase();
                if (idsSet.contains(attrId)) continue;
                entry.remove(attrId);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    public void denormalizeEntryOpAttrs(Attributes entry) throws NamingException {
        if (this.isDenormalizeOpAttrsEnabled) {
            AttributeType type = this.registry.lookup("creatorsName");
            Attribute attr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)type);
            if (attr != null) {
                LdapDN creatorsName = new LdapDN((String)attr.get());
                attr.clear();
                attr.add(0, this.denormalizeTypes(creatorsName).getUpName());
            }
            type = null;
            type = this.registry.lookup("modifiersName");
            attr = null;
            attr = AttributeUtils.getAttribute((Attributes)entry, (AttributeType)type);
            if (attr != null) {
                LdapDN modifiersName = new LdapDN((String)attr.get());
                attr.clear();
                attr.add(0, this.denormalizeTypes(modifiersName).getUpName());
            }
        }
    }

    public LdapDN denormalizeTypes(LdapDN dn) throws NamingException {
        LdapDN newDn = new LdapDN();
        for (int ii = 0; ii < dn.size(); ++ii) {
            Rdn rdn = dn.getRdn(ii);
            if (rdn.size() == 0) {
                newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                newDn.add(new Rdn(this.registry.lookup(rdn.getNormType()).getName(), (String)rdn.getAtav().getValue()));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator jj = rdn.iterator();
            while (jj.hasNext()) {
                AttributeTypeAndValue atav = (AttributeTypeAndValue)jj.next();
                String type = this.registry.lookup(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getValue());
                if (!jj.hasNext()) continue;
                buf.append('+');
            }
            newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private boolean filterDenormalized(Attributes entry) throws NamingException {
        this.denormalizeEntryOpAttrs(entry);
        return true;
    }
}

