/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.MultiException;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeIdentifierException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNoSuchAttributeException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionNexus
extends PartitionNexus {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultPartitionNexus.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static final String ASF = "Apache Software Foundation";
    private static final String VENDORNAME_ATTR = "vendorName";
    private static final String VENDORVERSION_ATTR = "vendorVersion";
    private static final String NAMINGCTXS_ATTR = "namingContexts";
    private boolean initialized;
    private DirectoryServiceConfiguration factoryCfg;
    private Partition system;
    private HashMap partitions = new HashMap();
    private final Attributes rootDSE;
    private AttributeTypeRegistry attrRegistry;
    private OidRegistry oidRegistry;

    public DefaultPartitionNexus(Attributes rootDSE) {
        this.rootDSE = rootDSE;
        LockableAttributeImpl attr = new LockableAttributeImpl("subschemaSubentry");
        attr.add("cn=schema,ou=system");
        rootDSE.put((Attribute)attr);
        attr = new LockableAttributeImpl("supportedLDAPVersion");
        rootDSE.put((Attribute)attr);
        attr.add("3");
        attr = new LockableAttributeImpl("supportedFeatures");
        rootDSE.put((Attribute)attr);
        attr.add("1.3.6.1.4.1.4203.1.5.1");
        attr = new LockableAttributeImpl("supportedExtension");
        rootDSE.put((Attribute)attr);
        attr.add("1.3.6.1.4.1.1466.20036");
        attr = new LockableAttributeImpl("supportedControl");
        rootDSE.put((Attribute)attr);
        attr.add("2.16.840.1.113730.3.4.3");
        attr.add("2.16.840.1.113730.3.4.7");
        attr.add("1.3.6.1.4.1.4203.1.10.1");
        attr.add("2.16.840.1.113730.3.4.2");
        attr = new LockableAttributeImpl("objectClass");
        rootDSE.put((Attribute)attr);
        attr.add("top");
        attr.add("extensibleObject");
        attr = new LockableAttributeImpl(NAMINGCTXS_ATTR);
        rootDSE.put((Attribute)attr);
        attr = new LockableAttributeImpl(VENDORNAME_ATTR);
        attr.add(ASF);
        rootDSE.put((Attribute)attr);
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            log.error("failed to log version properties");
        }
        attr = new LockableAttributeImpl(VENDORVERSION_ATTR);
        attr.add(props.getProperty("apacheds.version", "UNKNOWN"));
        rootDSE.put((Attribute)attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        if (this.initialized) {
            return;
        }
        this.factoryCfg = factoryCfg;
        this.attrRegistry = this.factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        this.oidRegistry = this.factoryCfg.getGlobalRegistries().getOidRegistry();
        ArrayList<PartitionConfiguration> initializedPartitionCfgs = new ArrayList<PartitionConfiguration>();
        initializedPartitionCfgs.add(this.initializeSystemPartition());
        Iterator i = factoryCfg.getStartupConfiguration().getContextPartitionConfigurations().iterator();
        try {
            while (i.hasNext()) {
                PartitionConfiguration c = (PartitionConfiguration)i.next();
                this.addContextPartition(c);
                initializedPartitionCfgs.add(0, c);
            }
            this.initialized = true;
        }
        finally {
            if (!this.initialized) {
                i = initializedPartitionCfgs.iterator();
                while (i.hasNext()) {
                    PartitionConfiguration partitionCfg = (PartitionConfiguration)i.next();
                    Partition partition = partitionCfg.getContextPartition();
                    i.remove();
                    try {
                        partition.destroy();
                    }
                    catch (Exception e) {
                        log.warn("Failed to destroy a partition: " + partitionCfg.getSuffix(), (Throwable)e);
                    }
                    finally {
                        this.unregister(partition);
                    }
                }
            }
        }
    }

    private PartitionConfiguration initializeSystemPartition() throws NamingException {
        MutableBTreePartitionConfiguration systemCfg;
        PartitionConfiguration overrides = this.factoryCfg.getStartupConfiguration().getSystemPartitionConfiguration();
        if (overrides != null) {
            systemCfg = MutableBTreePartitionConfiguration.getConfiguration(overrides);
            Attributes systemEntry = systemCfg.getContextEntry();
            Attribute objectClassAttr = systemEntry.get("objectClass");
            if (objectClassAttr == null) {
                objectClassAttr = new LockableAttributeImpl("objectClass");
                systemEntry.put(objectClassAttr);
            }
            objectClassAttr.add("top");
            objectClassAttr.add("organizationalUnit");
            objectClassAttr.add("extensibleObject");
            systemEntry.put("creatorsName", "uid=admin,ou=system");
            systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            systemEntry.put(NamespaceTools.getRdnAttribute((String)"ou=system"), NamespaceTools.getRdnValue((String)"ou=system"));
            systemCfg.setContextEntry(systemEntry);
            if (!systemCfg.getName().equals("system")) {
                throw new ConfigurationException("System partition has wrong name: should be 'system'.");
            }
            Set indices = systemCfg.getIndexedAttributes();
            HashSet<String> indexOids = new HashSet<String>();
            OidRegistry registry = this.factoryCfg.getGlobalRegistries().getOidRegistry();
            Iterator ii = indices.iterator();
            while (ii.hasNext()) {
                indexOids.add(registry.getOid(ii.next().toString()));
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.7");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.3");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.4");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.1");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.5");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.6");
            }
            if (!indexOids.contains("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                indices.add("1.3.6.1.4.1.18060.0.4.1.2.2");
            }
            if (!indexOids.contains(registry.getOid("objectClass"))) {
                log.warn("CAUTION: You have not included objectClass as an indexed attributein the system partition configuration.  This will lead to poor performance.  The server is automatically adding this index for you.");
                indices.add("objectClass");
            }
        } else {
            systemCfg = new MutableBTreePartitionConfiguration();
            systemCfg.setName("system");
            systemCfg.setCacheSize(500);
            systemCfg.setSuffix("ou=system");
            HashSet<String> indexedSystemAttrs = new HashSet<String>();
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.7");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.3");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.4");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.1");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.5");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.6");
            indexedSystemAttrs.add("1.3.6.1.4.1.18060.0.4.1.2.2");
            indexedSystemAttrs.add("objectClass");
            systemCfg.setIndexedAttributes(indexedSystemAttrs);
            LockableAttributesImpl systemEntry = new LockableAttributesImpl();
            LockableAttributeImpl objectClassAttr = new LockableAttributeImpl("objectClass");
            objectClassAttr.add("top");
            objectClassAttr.add("organizationalUnit");
            objectClassAttr.add("extensibleObject");
            systemEntry.put((Attribute)objectClassAttr);
            systemEntry.put("creatorsName", "uid=admin,ou=system");
            systemEntry.put("createTimestamp", DateUtils.getGeneralizedTime());
            systemEntry.put(NamespaceTools.getRdnAttribute((String)"ou=system"), NamespaceTools.getRdnValue((String)"ou=system"));
            systemCfg.setContextEntry((Attributes)systemEntry);
        }
        this.system = new JdbmPartition();
        this.system.init(this.factoryCfg, systemCfg);
        systemCfg.setContextPartition(this.system);
        String key = this.system.getSuffix().toString();
        if (this.partitions.containsKey(key)) {
            throw new ConfigurationException("Duplicate partition suffix: " + key);
        }
        this.partitions.put(key, this.system);
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.add(this.system.getUpSuffix().toString());
        return systemCfg;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        Iterator suffixes = new HashSet(this.partitions.keySet()).iterator();
        while (suffixes.hasNext()) {
            String suffix = (String)suffixes.next();
            try {
                this.removeContextPartition(new LdapDN(suffix));
            }
            catch (NamingException e) {
                log.warn("Failed to destroy a partition: " + suffix, (Throwable)e);
            }
        }
        this.initialized = false;
    }

    public void sync() throws NamingException {
        MultiException error = null;
        Iterator list = this.partitions.values().iterator();
        while (list.hasNext()) {
            Partition partition = (Partition)list.next();
            try {
                partition.sync();
            }
            catch (NamingException e) {
                log.warn("Failed to flush partition data out.", (Throwable)e);
                if (error == null) {
                    error = new MultiException("Grouping many exceptions on root nexus sync()");
                }
                error.addThrowable((Throwable)e);
            }
        }
        if (error != null) {
            String msg = "Encountered failures while performing a sync() operation on backing stores";
            NamingException total = new NamingException(msg);
            total.setRootCause((Throwable)error);
        }
    }

    public boolean compare(LdapDN name, String oid, Object value) throws NamingException {
        Partition partition = this.getBackend(name);
        AttributeTypeRegistry registry = this.factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        if (!registry.hasAttributeType(oid)) {
            throw new LdapInvalidAttributeIdentifierException(oid + " not found within the attributeType registry");
        }
        AttributeType attrType = registry.lookup(oid);
        Attribute attr = partition.lookup(name).get(attrType.getName());
        if (attr == null) {
            throw new LdapNoSuchAttributeException();
        }
        if (attr.contains(value)) {
            return true;
        }
        Normalizer normalizer = attrType.getEquality().getNormalizer();
        Object reqVal = normalizer.normalize(value);
        for (int ii = 0; ii < attr.size(); ++ii) {
            Object attrVal;
            Object attrValObj = normalizer.normalize(attr.get(ii));
            if (attrValObj instanceof String) {
                attrVal = (String)attrValObj;
                if (!(reqVal instanceof String) || !((String)attrVal).equals(reqVal)) continue;
                return true;
            }
            attrVal = (byte[])attrValObj;
            if (reqVal instanceof byte[]) {
                return Arrays.equals((byte[])attrVal, (byte[])reqVal);
            }
            if (!(reqVal instanceof String)) continue;
            return Arrays.equals((byte[])attrVal, StringTools.getBytesUtf8((String)((String)reqVal)));
        }
        return false;
    }

    public synchronized void addContextPartition(PartitionConfiguration config) throws NamingException {
        Partition partition = config.getContextPartition();
        String key = config.getSuffix();
        if (this.partitions.containsKey(key)) {
            throw new ConfigurationException("Duplicate partition suffix: " + key);
        }
        partition.init(this.factoryCfg, config);
        this.partitions.put(partition.getSuffix().toString(), partition);
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.add(partition.getUpSuffix().toString());
    }

    public synchronized void removeContextPartition(LdapDN suffix) throws NamingException {
        String key = suffix.toString();
        Partition partition = (Partition)this.partitions.get(key);
        if (partition == null) {
            throw new NameNotFoundException("No partition with suffix: " + key);
        }
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.remove(partition.getUpSuffix().toString());
        this.partitions.remove(key);
        partition.sync();
        partition.destroy();
    }

    public Partition getSystemPartition() {
        return this.system;
    }

    public LdapContext getLdapContext() {
        throw new NotImplementedException();
    }

    public LdapDN getMatchedName(LdapDN dn) throws NamingException {
        dn = (LdapDN)dn.clone();
        while (dn.size() > 0) {
            if (this.hasEntry(dn)) {
                return dn;
            }
            dn.remove(dn.size() - 1);
        }
        return dn;
    }

    public LdapDN getSuffix() {
        return LdapDN.EMPTY_LDAPDN;
    }

    public LdapDN getUpSuffix() {
        return LdapDN.EMPTY_LDAPDN;
    }

    public LdapDN getSuffix(LdapDN dn) throws NamingException {
        Partition backend = this.getBackend(dn);
        return backend.getSuffix();
    }

    public Iterator listSuffixes() throws NamingException {
        return Collections.unmodifiableSet(this.partitions.keySet()).iterator();
    }

    public Attributes getRootDSE() {
        return this.rootDSE;
    }

    private void unregister(Partition partition) throws NamingException {
        Attribute namingContexts = this.rootDSE.get(NAMINGCTXS_ATTR);
        namingContexts.remove(partition.getSuffix().toString());
        this.partitions.remove(partition.getSuffix().toString());
    }

    public void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        Partition partition = this.getBackend(bindDn);
        partition.bind(bindDn, credentials, mechanisms, saslAuthId);
    }

    public void unbind(LdapDN bindDn) throws NamingException {
        Partition partition = this.getBackend(bindDn);
        partition.unbind(bindDn);
    }

    public void delete(LdapDN dn) throws NamingException {
        Partition backend = this.getBackend(dn);
        backend.delete(dn);
    }

    public void add(LdapDN dn, Attributes entry) throws NamingException {
        Partition backend = this.getBackend(dn);
        backend.add(dn, entry);
    }

    public void modify(LdapDN dn, int modOp, Attributes mods) throws NamingException {
        Partition backend = this.getBackend(dn);
        backend.modify(dn, modOp, mods);
    }

    public void modify(LdapDN dn, ModificationItemImpl[] mods) throws NamingException {
        Partition backend = this.getBackend(dn);
        backend.modify(dn, mods);
    }

    public NamingEnumeration list(LdapDN base) throws NamingException {
        Partition backend = this.getBackend(base);
        return backend.list(base);
    }

    public NamingEnumeration search(LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        if (base.size() == 0) {
            boolean isObjectScope = searchCtls.getSearchScope() == 0;
            boolean isSearchAll = ((PresenceNode)filter).getAttribute().equalsIgnoreCase("2.5.4.0");
            if (filter instanceof PresenceNode && isObjectScope && isSearchAll) {
                NamingEnumeration<? extends Attribute> ii;
                String[] ids = searchCtls.getReturningAttributes();
                if (ids == null || ids.length == 0) {
                    SearchResult result = new SearchResult("", (Object)null, (Attributes)this.getRootDSE().clone(), false);
                    return new SingletonEnumeration((Object)result);
                }
                HashSet<String> realIds = new HashSet<String>();
                boolean containsAsterisk = false;
                boolean containsPlus = false;
                boolean containsOneDotOne = false;
                for (int ii2 = 0; ii2 < ids.length; ++ii2) {
                    String id = ids[ii2].trim();
                    if (id.equals("*")) {
                        containsAsterisk = true;
                        continue;
                    }
                    if (id.equals("+")) {
                        containsPlus = true;
                        continue;
                    }
                    if (id.equals("1.1")) {
                        containsOneDotOne = true;
                        continue;
                    }
                    try {
                        realIds.add(this.oidRegistry.getOid(id));
                        continue;
                    }
                    catch (NamingException e) {
                        realIds.add(id);
                    }
                }
                if (containsOneDotOne) {
                    SearchResult result = new SearchResult("", (Object)null, (Attributes)new LockableAttributesImpl(), false);
                    return new SingletonEnumeration((Object)result);
                }
                if (containsAsterisk && containsPlus) {
                    SearchResult result = new SearchResult("", (Object)null, (Attributes)this.getRootDSE().clone(), false);
                    return new SingletonEnumeration((Object)result);
                }
                LockableAttributesImpl attrs = new LockableAttributesImpl();
                if (containsAsterisk) {
                    ii = this.getRootDSE().getAll();
                    while (ii.hasMore()) {
                        Attribute attr = ii.next();
                        AttributeType type = this.attrRegistry.lookup(attr.getID());
                        if (type.getUsage() == UsageEnum.USERAPPLICATIONS) {
                            attrs.put(attr);
                            continue;
                        }
                        if (!realIds.contains(type.getOid())) continue;
                        attrs.put(attr);
                    }
                } else if (containsPlus) {
                    ii = this.getRootDSE().getAll();
                    while (ii.hasMore()) {
                        Attribute attr = ii.next();
                        AttributeType type = this.attrRegistry.lookup(attr.getID());
                        if (type.getUsage() != UsageEnum.USERAPPLICATIONS) {
                            attrs.put(attr);
                            continue;
                        }
                        if (!realIds.contains(type.getOid())) continue;
                        attrs.put(attr);
                    }
                } else {
                    ii = this.getRootDSE().getAll();
                    while (ii.hasMore()) {
                        Attribute attr = ii.next();
                        AttributeType type = this.attrRegistry.lookup(attr.getID());
                        if (!realIds.contains(type.getOid())) continue;
                        attrs.put(attr);
                    }
                }
                SearchResult result = new SearchResult("", (Object)null, (Attributes)attrs, false);
                return new SingletonEnumeration((Object)result);
            }
            throw new LdapNameNotFoundException();
        }
        Partition backend = this.getBackend(base);
        return backend.search(base, env, filter, searchCtls);
    }

    public Attributes lookup(LdapDN dn) throws NamingException {
        if (dn.size() == 0) {
            return (Attributes)this.rootDSE.clone();
        }
        Partition backend = this.getBackend(dn);
        return backend.lookup(dn);
    }

    public Attributes lookup(LdapDN dn, String[] attrIds) throws NamingException {
        if (dn.size() == 0) {
            LockableAttributesImpl retval = new LockableAttributesImpl();
            NamingEnumeration<String> list = this.rootDSE.getIDs();
            while (list.hasMore()) {
                String id = list.next();
                Attribute attr = this.rootDSE.get(id);
                retval.put((Attribute)attr.clone());
            }
            return retval;
        }
        Partition backend = this.getBackend(dn);
        return backend.lookup(dn, attrIds);
    }

    public boolean hasEntry(LdapDN dn) throws NamingException {
        if (IS_DEBUG) {
            log.debug("Check if DN '" + dn + "' exists.");
        }
        if (dn.size() == 0) {
            return true;
        }
        Partition backend = this.getBackend(dn);
        return backend.hasEntry(dn);
    }

    public boolean isSuffix(LdapDN dn) {
        return this.partitions.containsKey(dn.toString());
    }

    public void modifyRn(LdapDN dn, String newRdn, boolean deleteOldRdn) throws NamingException {
        Partition backend = this.getBackend(dn);
        backend.modifyRn(dn, newRdn, deleteOldRdn);
    }

    public void move(LdapDN oriChildName, LdapDN newParentName) throws NamingException {
        Partition backend = this.getBackend(oriChildName);
        backend.move(oriChildName, newParentName);
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn, String newRdn, boolean deleteOldRdn) throws NamingException {
        Partition backend = this.getBackend(oldChildDn);
        backend.move(oldChildDn, newParentDn, newRdn, deleteOldRdn);
    }

    private Partition getBackend(LdapDN dn) throws NamingException {
        LdapDN clonedDn = (LdapDN)dn.clone();
        while (clonedDn.size() > 0) {
            if (this.partitions.containsKey(clonedDn.toString())) {
                return (Partition)this.partitions.get(clonedDn.toString());
            }
            clonedDn.remove(clonedDn.size() - 1);
        }
        throw new LdapNameNotFoundException(dn.getUpName());
    }

    public Partition getPartition(LdapDN dn) throws NamingException {
        return this.getBackend(dn);
    }

    public void registerSupportedExtensions(Set extensionOids) {
        Attribute supportedExtension = this.rootDSE.get("supportedExtension");
        if (supportedExtension == null) {
            supportedExtension = new LockableAttributeImpl("supportedExtension");
            this.rootDSE.put(supportedExtension);
        }
        Iterator oids = extensionOids.iterator();
        while (oids.hasNext()) {
            supportedExtension.add((String)oids.next());
        }
    }
}

