/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.OidNormalizer;

public abstract class PartitionNexus
implements Partition {
    public static final String ADMIN_PRINCIPAL = "uid=admin,ou=system";
    public static final String ADMIN_PRINCIPAL_NORMALIZED = "0.9.2342.19200300.100.1.1=admin,2.5.4.11=system";
    public static final String ADMIN_UID = "admin";
    public static final String ADMIN_PASSWORD = "secret";
    public static final String USERS_BASE_NAME = "ou=users,ou=system";
    public static final String GROUPS_BASE_NAME = "ou=groups,ou=system";
    private static final String UID_ATTRIBUTE = "uid";
    private static final String UID_ATTRIBUTE_ALIAS = "userid";
    private static final String UID_ATTRIBUTE_OID = "0.9.2342.19200300.100.1.1";
    private static final String OU_ATTRIBUTE = "ou";
    private static final String OU_ATTRIBUTE_ALIAS = "organizationalUnitName";
    private static final String OU_ATTRIBUTE_OID = "2.5.4.11";
    public static final String SYSTEM_PARTITION_SUFFIX = "ou=system";

    public static final LdapDN getAdminName() {
        LdapDN adminDn = null;
        try {
            adminDn = new LdapDN(ADMIN_PRINCIPAL);
        }
        catch (NamingException e) {
            throw new InternalError();
        }
        try {
            HashMap<String, OidNormalizer> oidsMap = new HashMap<String, OidNormalizer>();
            oidsMap.put(UID_ATTRIBUTE, new OidNormalizer(UID_ATTRIBUTE_OID, (Normalizer)new NoOpNormalizer()));
            oidsMap.put(UID_ATTRIBUTE_ALIAS, new OidNormalizer(UID_ATTRIBUTE_OID, (Normalizer)new NoOpNormalizer()));
            oidsMap.put(UID_ATTRIBUTE_OID, new OidNormalizer(UID_ATTRIBUTE_OID, (Normalizer)new NoOpNormalizer()));
            oidsMap.put(OU_ATTRIBUTE, new OidNormalizer(OU_ATTRIBUTE_OID, (Normalizer)new NoOpNormalizer()));
            oidsMap.put(OU_ATTRIBUTE_ALIAS, new OidNormalizer(OU_ATTRIBUTE_OID, (Normalizer)new NoOpNormalizer()));
            oidsMap.put(OU_ATTRIBUTE_OID, new OidNormalizer(OU_ATTRIBUTE_OID, (Normalizer)new NoOpNormalizer()));
            adminDn.normalize(oidsMap);
        }
        catch (InvalidNameException ine) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return adminDn;
    }

    public static final LdapDN getGroupsBaseName() {
        LdapDN groupsBaseDn = null;
        try {
            groupsBaseDn = new LdapDN(GROUPS_BASE_NAME);
        }
        catch (NamingException e) {
            throw new InternalError();
        }
        return groupsBaseDn;
    }

    public static final LdapDN getUsersBaseName() {
        LdapDN usersBaseDn = null;
        try {
            usersBaseDn = new LdapDN(USERS_BASE_NAME);
        }
        catch (NamingException e) {
            throw new InternalError();
        }
        return usersBaseDn;
    }

    public abstract LdapContext getLdapContext();

    public abstract Attributes getRootDSE() throws NamingException;

    public abstract boolean compare(LdapDN var1, String var2, Object var3) throws NamingException;

    public abstract void addContextPartition(PartitionConfiguration var1) throws NamingException;

    public abstract void removeContextPartition(LdapDN var1) throws NamingException;

    public abstract Partition getSystemPartition();

    public abstract Partition getPartition(LdapDN var1) throws NamingException;

    public abstract LdapDN getMatchedName(LdapDN var1) throws NamingException;

    public abstract LdapDN getSuffix(LdapDN var1) throws NamingException;

    public abstract Iterator listSuffixes() throws NamingException;

    public abstract void registerSupportedExtensions(Set var1);
}

