/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.BTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.BTreeSearchResultEnumeration;
import org.apache.directory.server.core.partition.impl.btree.DefaultOptimizer;
import org.apache.directory.server.core.partition.impl.btree.DefaultSearchEngine;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEnumerator;
import org.apache.directory.server.core.partition.impl.btree.ExpressionEvaluator;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexConfiguration;
import org.apache.directory.server.core.partition.impl.btree.IndexNotFoundException;
import org.apache.directory.server.core.partition.impl.btree.NoOpOptimizer;
import org.apache.directory.server.core.partition.impl.btree.Optimizer;
import org.apache.directory.server.core.partition.impl.btree.SearchEngine;
import org.apache.directory.server.core.partition.impl.btree.gui.PartitionViewer;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BTreePartition
implements Partition {
    private static final Logger log = LoggerFactory.getLogger((Class)BTreePartition.class);
    private SearchEngine searchEngine = null;
    private AttributeTypeRegistry attributeTypeRegistry = null;

    protected BTreePartition() {
    }

    public void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        this.attributeTypeRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        OidRegistry oidRegistry = factoryCfg.getGlobalRegistries().getOidRegistry();
        ExpressionEvaluator evaluator = new ExpressionEvaluator(this, oidRegistry, this.attributeTypeRegistry);
        ExpressionEnumerator enumerator = new ExpressionEnumerator(this, this.attributeTypeRegistry, evaluator);
        BTreePartitionConfiguration btConfig = BTreePartitionConfiguration.convert(cfg);
        Optimizer optimizer = btConfig.isOptimizerEnabled() ? new DefaultOptimizer(this) : new NoOpOptimizer();
        this.searchEngine = new DefaultSearchEngine(this, evaluator, enumerator, optimizer);
        HashSet<String> sysOidSet = new HashSet<String>();
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.3");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.4");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.2");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.1");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.5");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.6");
        sysOidSet.add("1.3.6.1.4.1.18060.0.4.1.2.7");
        HashSet<String> customAddedSystemIndices = new HashSet<String>();
        Iterator ii = cfg.getIndexedAttributes().iterator();
        while (ii.hasNext()) {
            Object nextObject = ii.next();
            String name = null;
            int cacheSize = 100;
            int numDupLimit = 512;
            if (nextObject instanceof String) {
                name = (String)nextObject;
                log.warn("Using default cache size of {} for index on attribute {}", (Object)new Integer(cacheSize), (Object)name);
            } else if (nextObject instanceof IndexConfiguration) {
                IndexConfiguration indexConfiguration = (IndexConfiguration)nextObject;
                name = indexConfiguration.getAttributeId();
                cacheSize = indexConfiguration.getCacheSize();
                numDupLimit = indexConfiguration.getDuplicateLimit();
                if (cacheSize <= 0) {
                    log.warn("Cache size {} for index on attribute is null or negative. Using default value.", (Object)new Integer(cacheSize), (Object)name);
                    cacheSize = 100;
                } else {
                    log.info("Using cache size of {} for index on attribute {}", (Object)new Integer(cacheSize), (Object)name);
                }
                if (cacheSize <= 0) {
                    log.warn("Duplicate limit {} for index on attribute is null or negative. Using default value.", (Object)new Integer(numDupLimit), (Object)name);
                    cacheSize = 100;
                } else {
                    log.info("Using duplicate limit of {} for index on attribute {}", (Object)new Integer(numDupLimit), (Object)name);
                }
            }
            String oid = oidRegistry.getOid(name);
            AttributeType type = this.attributeTypeRegistry.lookup(oid);
            if (sysOidSet.contains(oid)) {
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                    this.setExistanceIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.3");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                    this.setHierarchyIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.4");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                    this.setUpdnIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.2");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                    this.setNdnIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.1");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                    this.setOneAliasIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.5");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                    this.setSubAliasIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.6");
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                    this.setAliasIndexOn(type, cacheSize, numDupLimit);
                    customAddedSystemIndices.add("1.3.6.1.4.1.18060.0.4.1.2.7");
                    continue;
                }
                throw new NamingException("Unidentified system index " + oid);
            }
            this.addIndexOn(type, cacheSize, numDupLimit);
        }
        ii = sysOidSet.iterator();
        while (ii.hasNext()) {
            String systemIndexName = (String)ii.next();
            if (customAddedSystemIndices.contains(systemIndexName)) continue;
            AttributeType type = this.attributeTypeRegistry.lookup(systemIndexName);
            log.warn("Using default cache size of {} for index on attribute {}", (Object)new Integer(100), (Object)systemIndexName);
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.3")) {
                this.setExistanceIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.4")) {
                this.setHierarchyIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.2")) {
                this.setUpdnIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.1")) {
                this.setNdnIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.5")) {
                this.setOneAliasIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.6")) {
                this.setSubAliasIndexOn(type, 100, 512);
                continue;
            }
            if (systemIndexName.equals("1.3.6.1.4.1.18060.0.4.1.2.7")) {
                this.setAliasIndexOn(type, 100, 512);
                continue;
            }
            throw new NamingException("Unidentified system index " + systemIndexName);
        }
        Attributes suffixOnDisk = this.getSuffixEntry();
        if (suffixOnDisk == null) {
            LdapDN suffix = new LdapDN(cfg.getSuffix());
            LdapDN normalizedSuffix = LdapDN.normalize((LdapDN)suffix, (Map)this.attributeTypeRegistry.getNormalizerMapping());
            this.add(normalizedSuffix, cfg.getContextEntry());
        }
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public void delete(LdapDN dn) throws NamingException {
        BigInteger id = this.getEntryId(dn.toString());
        if (id == null) {
            throw new LdapNameNotFoundException("Could not find entry at '" + dn + "' to delete it!");
        }
        if (this.getChildCount(id) > 0) {
            LdapContextNotEmptyException cnee = new LdapContextNotEmptyException("[66] Cannot delete entry " + dn + " it has children!");
            cnee.setRemainingName((Name)dn);
            throw cnee;
        }
        this.delete(id);
    }

    public abstract void add(LdapDN var1, Attributes var2) throws NamingException;

    public abstract void modify(LdapDN var1, int var2, Attributes var3) throws NamingException;

    public abstract void modify(LdapDN var1, ModificationItemImpl[] var2) throws NamingException;

    public NamingEnumeration list(LdapDN base) throws NamingException {
        BTreeSearchResultEnumeration list = new BTreeSearchResultEnumeration(ArrayUtils.EMPTY_STRING_ARRAY, this.list(this.getEntryId(base.toString())), this, this.attributeTypeRegistry);
        return list;
    }

    public NamingEnumeration search(LdapDN base, Map env, ExprNode filter, SearchControls searchCtls) throws NamingException {
        String[] attrIds = searchCtls.getReturningAttributes();
        NamingEnumeration underlying = null;
        underlying = this.searchEngine.search((Name)base, env, filter, searchCtls);
        return new BTreeSearchResultEnumeration(attrIds, underlying, this, this.attributeTypeRegistry);
    }

    public Attributes lookup(LdapDN dn) throws NamingException {
        return this.lookup(this.getEntryId(dn.toString()));
    }

    public Attributes lookup(LdapDN dn, String[] attrIds) throws NamingException {
        if (attrIds == null || attrIds.length == 0) {
            return this.lookup(dn);
        }
        Attributes entry = this.lookup(dn);
        LockableAttributesImpl retval = new LockableAttributesImpl();
        for (int ii = 0; ii < attrIds.length; ++ii) {
            Attribute attr = entry.get(attrIds[ii]);
            if (attr == null) continue;
            retval.put(attr);
        }
        return retval;
    }

    public boolean hasEntry(LdapDN dn) throws NamingException {
        return null != this.getEntryId(dn.toString());
    }

    public abstract void modifyRn(LdapDN var1, String var2, boolean var3) throws NamingException;

    public abstract void move(LdapDN var1, LdapDN var2) throws NamingException;

    public abstract void move(LdapDN var1, LdapDN var2, String var3, boolean var4) throws NamingException;

    public abstract void sync() throws NamingException;

    public abstract void destroy();

    public abstract boolean isInitialized();

    public boolean isSuffix(LdapDN dn) throws NamingException {
        return this.getSuffix().equals((Object)dn);
    }

    public void inspect() throws Exception {
        PartitionViewer viewer = new PartitionViewer(this, this.searchEngine);
        viewer.execute();
    }

    public abstract void addIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract boolean hasUserIndexOn(String var1) throws NamingException;

    public abstract boolean hasSystemIndexOn(String var1) throws NamingException;

    public abstract Index getExistanceIndex();

    public abstract Index getHierarchyIndex();

    public abstract Index getUpdnIndex();

    public abstract Index getNdnIndex();

    public abstract Index getOneAliasIndex();

    public abstract Index getSubAliasIndex();

    public abstract Index getAliasIndex();

    public abstract void setAliasIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setExistanceIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setHierarchyIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setUpdnIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setNdnIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setOneAliasIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract void setSubAliasIndexOn(AttributeType var1, int var2, int var3) throws NamingException;

    public abstract Index getUserIndex(String var1) throws IndexNotFoundException;

    public abstract Index getSystemIndex(String var1) throws IndexNotFoundException;

    public abstract BigInteger getEntryId(String var1) throws NamingException;

    public abstract String getEntryDn(BigInteger var1) throws NamingException;

    public abstract BigInteger getParentId(String var1) throws NamingException;

    public abstract BigInteger getParentId(BigInteger var1) throws NamingException;

    public abstract String getEntryUpdn(BigInteger var1) throws NamingException;

    public abstract String getEntryUpdn(String var1) throws NamingException;

    public abstract Attributes lookup(BigInteger var1) throws NamingException;

    public abstract void delete(BigInteger var1) throws NamingException;

    public abstract NamingEnumeration list(BigInteger var1) throws NamingException;

    public abstract int getChildCount(BigInteger var1) throws NamingException;

    public abstract Attributes getSuffixEntry() throws NamingException;

    public abstract void setProperty(String var1, String var2) throws NamingException;

    public abstract String getProperty(String var1) throws NamingException;

    public abstract Iterator getUserIndices();

    public abstract Iterator getSystemIndices();

    public abstract Attributes getIndices(BigInteger var1) throws NamingException;

    public abstract int count() throws NamingException;
}

