/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.enumeration.SearchResultEnumeration;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.BTreeSearchResult;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class BTreeSearchResultEnumeration
implements SearchResultEnumeration {
    private BTreePartition partition = null;
    private final String[] attrIds;
    private final NamingEnumeration underlying;
    private boolean attrIdsHasStar = false;
    private boolean attrIdsHasPlus = false;
    private AttributeTypeRegistry registry = null;

    public BTreeSearchResultEnumeration(String[] attrIds, NamingEnumeration underlying, BTreePartition db, AttributeTypeRegistry registry) {
        this.partition = db;
        this.attrIds = attrIds;
        this.underlying = underlying;
        this.attrIdsHasStar = this.containsStar(attrIds);
        this.attrIdsHasPlus = this.containsPlus(attrIds);
        this.registry = registry;
    }

    public void close() throws NamingException {
        this.underlying.close();
    }

    public boolean hasMore() throws NamingException {
        return this.underlying.hasMore();
    }

    public Object next() throws NamingException {
        AttributeType attrType;
        NamingEnumeration<String> list;
        Attributes entry;
        IndexRecord rec = (IndexRecord)this.underlying.next();
        String name = this.partition.getEntryUpdn(rec.getEntryId());
        if (null == rec.getAttributes()) {
            rec.setAttributes(this.partition.lookup(rec.getEntryId()));
        }
        if (this.attrIds == null) {
            entry = (Attributes)rec.getAttributes().clone();
        } else if (this.attrIdsHasPlus && this.attrIdsHasStar) {
            entry = (Attributes)rec.getAttributes().clone();
        } else if (this.attrIdsHasPlus) {
            entry = new LockableAttributesImpl();
            for (int ii = 0; ii < this.attrIds.length; ++ii) {
                if (this.attrIds[ii].equals("+") || null == rec.getAttributes().get(this.attrIds[ii])) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(this.attrIds[ii]).clone();
                entry.put(attr);
            }
            list = rec.getAttributes().getIDs();
            while (list.hasMore()) {
                String attrId = list.next();
                attrType = this.registry.lookup(attrId);
                if (attrType.getUsage() == UsageEnum.USERAPPLICATIONS) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(attrId).clone();
                entry.put(attr);
            }
        } else if (this.attrIdsHasStar) {
            entry = new LockableAttributesImpl();
            for (int ii = 0; ii < this.attrIds.length; ++ii) {
                if (this.attrIds[ii].equals("*") || null == rec.getAttributes().get(this.attrIds[ii])) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(this.attrIds[ii]).clone();
                entry.put(attr);
            }
            list = rec.getAttributes().getIDs();
            while (list.hasMore()) {
                String attrId = list.next();
                attrType = this.registry.lookup(attrId);
                if (attrType.getUsage() != UsageEnum.USERAPPLICATIONS) continue;
                Attribute attr = (Attribute)rec.getAttributes().get(attrId).clone();
                entry.put(attr);
            }
        } else {
            entry = new LockableAttributesImpl();
            Attributes attrs = rec.getAttributes();
            for (int ii = 0; ii < this.attrIds.length && !"1.1".equals(this.attrIds[ii]); ++ii) {
                Attribute attr = AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)this.registry.lookup(this.attrIds[ii]));
                if (null == attr) {
                    Iterator descendants = this.registry.descendants(this.attrIds[ii]);
                    while (descendants.hasNext()) {
                        AttributeType atype = (AttributeType)descendants.next();
                        attr = AttributeUtils.getAttribute((Attributes)attrs, (AttributeType)atype);
                        if (attr == null) continue;
                        entry.put((Attribute)attr.clone());
                    }
                    continue;
                }
                entry.put((Attribute)attr.clone());
            }
        }
        AttributeType refAT = this.registry.lookup("ref");
        Attribute refAttr = AttributeUtils.getAttribute((Attributes)rec.getAttributes(), (AttributeType)refAT);
        if (refAttr != null) {
            entry.put((Attribute)refAttr.clone());
        }
        BTreeSearchResult result = new BTreeSearchResult(rec.getEntryId(), name, null, entry);
        result.setRelative(false);
        return result;
    }

    private boolean containsStar(String[] ids) {
        if (ids == null) {
            return false;
        }
        for (int ii = ids.length - 1; ii >= 0; --ii) {
            if (!ids[ii].trim().equals("*")) continue;
            return true;
        }
        return false;
    }

    private boolean containsPlus(String[] ids) {
        if (ids == null) {
            return false;
        }
        for (int ii = ids.length - 1; ii >= 0; --ii) {
            if (!ids[ii].trim().equals("+")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMoreElements() {
        return this.underlying.hasMoreElements();
    }

    public Object nextElement() {
        return this.underlying.nextElement();
    }
}

