/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import jdbm.RecordManager;
import jdbm.helper.CachePolicy;
import jdbm.helper.MRU;
import jdbm.recman.BaseRecordManager;
import jdbm.recman.CacheRecordManager;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.ServerUtils;
import org.apache.directory.server.core.configuration.PartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.BTreePartition;
import org.apache.directory.server.core.partition.impl.btree.BTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.Index;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertion;
import org.apache.directory.server.core.partition.impl.btree.IndexAssertionEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexEnumeration;
import org.apache.directory.server.core.partition.impl.btree.IndexNotFoundException;
import org.apache.directory.server.core.partition.impl.btree.IndexRecord;
import org.apache.directory.server.core.partition.impl.btree.MutableBTreePartitionConfiguration;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmMasterTable;
import org.apache.directory.server.core.schema.AttributeTypeRegistry;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.exception.LdapAuthenticationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.LockableAttributeImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbmPartition
extends BTreePartition {
    private static final Logger log = LoggerFactory.getLogger((Class)JdbmPartition.class);
    private RecordManager recMan;
    private LdapDN normSuffix;
    private LdapDN upSuffix;
    private File workingDirectory;
    private JdbmMasterTable master;
    private Map indices;
    private Map sysIndices;
    private boolean initialized;
    private Index ndnIdx;
    private Index updnIdx;
    private Index existanceIdx;
    private Index hierarchyIdx;
    private Index oneAliasIdx;
    private Index subAliasIdx;
    private Index aliasIdx;
    private OidRegistry oidRegistry;
    private AttributeTypeRegistry attrRegistry;
    private BTreePartitionConfiguration cfg;

    public synchronized void init(DirectoryServiceConfiguration factoryCfg, PartitionConfiguration cfg) throws NamingException {
        this.cfg = cfg instanceof BTreePartitionConfiguration ? (BTreePartitionConfiguration)cfg : MutableBTreePartitionConfiguration.getConfiguration(cfg);
        this.oidRegistry = factoryCfg.getGlobalRegistries().getOidRegistry();
        this.attrRegistry = factoryCfg.getGlobalRegistries().getAttributeTypeRegistry();
        this.upSuffix = new LdapDN(cfg.getSuffix());
        this.normSuffix = LdapDN.normalize((LdapDN)this.upSuffix, (Map)this.attrRegistry.getNormalizerMapping());
        File workingDirectory = new File(factoryCfg.getStartupConfiguration().getWorkingDirectory().getPath() + File.separator + cfg.getName());
        workingDirectory.mkdirs();
        this.workingDirectory = workingDirectory;
        try {
            String path = workingDirectory.getPath() + File.separator + "master";
            BaseRecordManager base = new BaseRecordManager(path);
            base.disableTransactions();
            int cacheSize = cfg.getCacheSize();
            if (cacheSize < 0) {
                cacheSize = 10000;
                log.warn("Using the default entry cache size of {} for {} partition", (Object)new Integer(cacheSize), (Object)cfg.getName());
            } else {
                log.info("Using the custom configured cache size of {} for {} partition", (Object)new Integer(cacheSize), (Object)cfg.getName());
            }
            this.recMan = new CacheRecordManager((RecordManager)base, (CachePolicy)new MRU(cacheSize));
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Could not initialize RecordManager");
            ne.setRootCause(e);
            throw ne;
        }
        this.master = new JdbmMasterTable(this.recMan);
        this.indices = new HashMap();
        this.sysIndices = new HashMap();
        super.init(factoryCfg, cfg);
        this.initialized = true;
    }

    public synchronized void destroy() {
        if (!this.initialized) {
            return;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.addAll(this.indices.values());
        if (null != this.ndnIdx) {
            array.add(this.ndnIdx);
        }
        if (null != this.updnIdx) {
            array.add(this.updnIdx);
        }
        if (null != this.aliasIdx) {
            array.add(this.aliasIdx);
        }
        if (null != this.oneAliasIdx) {
            array.add(this.oneAliasIdx);
        }
        if (null != this.subAliasIdx) {
            array.add(this.subAliasIdx);
        }
        if (null != this.hierarchyIdx) {
            array.add(this.hierarchyIdx);
        }
        if (null != this.existanceIdx) {
            array.add(this.existanceIdx);
        }
        Iterator list = array.iterator();
        while (list.hasNext()) {
            Index index = (Index)list.next();
            try {
                index.close();
            }
            catch (Throwable t) {
                log.error("Failed to close an index.", t);
            }
        }
        try {
            this.master.close();
        }
        catch (Throwable t) {
            log.error("Failed to close the master.", t);
        }
        try {
            this.recMan.close();
        }
        catch (Throwable t) {
            log.error("Failed to close the record manager", t);
        }
        this.initialized = false;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public synchronized void sync() throws NamingException {
        if (!this.initialized) {
            return;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        array.addAll(this.indices.values());
        array.add(this.ndnIdx);
        array.add(this.updnIdx);
        array.add(this.aliasIdx);
        array.add(this.oneAliasIdx);
        array.add(this.subAliasIdx);
        array.add(this.hierarchyIdx);
        array.add(this.existanceIdx);
        Iterator list = array.iterator();
        while (list.hasNext()) {
            Index idx = (Index)list.next();
            idx.sync();
        }
        this.master.sync();
        try {
            this.recMan.commit();
        }
        catch (Throwable t) {
            throw (NamingException)new NamingException("Failed to commit changes to the record manager.").initCause(t);
        }
    }

    public void addIndexOn(AttributeType spec, int cacheSize, int numDupLimit) throws NamingException {
        JdbmIndex idx = new JdbmIndex(spec, this.workingDirectory, cacheSize, numDupLimit);
        this.indices.put(spec.getOid(), idx);
    }

    public Index getExistanceIndex() {
        return this.existanceIdx;
    }

    public void setExistanceIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.existanceIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.existanceIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.existanceIdx);
    }

    public Index getHierarchyIndex() {
        return this.hierarchyIdx;
    }

    public void setHierarchyIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.hierarchyIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.hierarchyIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.hierarchyIdx);
    }

    public Index getAliasIndex() {
        return this.aliasIdx;
    }

    public void setAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.aliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.aliasIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.aliasIdx);
    }

    public Index getOneAliasIndex() {
        return this.oneAliasIdx;
    }

    public void setOneAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.oneAliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.oneAliasIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.oneAliasIdx);
    }

    public Index getSubAliasIndex() {
        return this.subAliasIdx;
    }

    public void setSubAliasIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.subAliasIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.subAliasIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.subAliasIdx);
    }

    public Index getUpdnIndex() {
        return this.updnIdx;
    }

    public void setUpdnIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.updnIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.updnIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.updnIdx);
    }

    public Index getNdnIndex() {
        return this.ndnIdx;
    }

    public void setNdnIndexOn(AttributeType attrType, int cacheSize, int numDupLimit) throws NamingException {
        if (this.ndnIdx != null) {
            NamingException e = new NamingException("Index already set!");
            throw e;
        }
        this.ndnIdx = new JdbmIndex(attrType, this.workingDirectory, cacheSize, numDupLimit);
        this.sysIndices.put(attrType.getOid(), this.ndnIdx);
    }

    public Iterator getUserIndices() {
        return this.indices.keySet().iterator();
    }

    public Iterator getSystemIndices() {
        return this.sysIndices.keySet().iterator();
    }

    public boolean hasUserIndexOn(String id) throws NamingException {
        return this.indices.containsKey(this.oidRegistry.getOid(id));
    }

    public boolean hasSystemIndexOn(String id) throws NamingException {
        return this.sysIndices.containsKey(this.oidRegistry.getOid(id));
    }

    public Index getUserIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            log.error("Failed to identify OID for: " + id, (Throwable)e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, e);
        }
        if (this.indices.containsKey(id)) {
            return (Index)this.indices.get(id);
        }
        String name = "unknown";
        try {
            name = this.oidRegistry.getPrimaryName(id);
        }
        catch (NamingException e) {
            String msg = "Failed to resolve primary name for " + id + " in user index lookup";
            log.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, e);
        }
        throw new IndexNotFoundException("A user index on attribute " + id + " (" + name + ") does not exist!");
    }

    public Index getSystemIndex(String id) throws IndexNotFoundException {
        try {
            id = this.oidRegistry.getOid(id);
        }
        catch (NamingException e) {
            log.error("Failed to identify OID for: " + id, (Throwable)e);
            throw new IndexNotFoundException("Failed to identify OID for: " + id, id, e);
        }
        if (this.sysIndices.containsKey(id)) {
            return (Index)this.sysIndices.get(id);
        }
        String name = "unknown";
        try {
            name = this.oidRegistry.getPrimaryName(id);
        }
        catch (NamingException e) {
            String msg = "Failed to resolve primary name for " + id + " in user index lookup";
            log.error(msg, (Throwable)e);
            throw new IndexNotFoundException(msg, id, e);
        }
        throw new IndexNotFoundException("A system index on attribute " + id + " (" + name + ") does not exist!");
    }

    public BigInteger getEntryId(String dn) throws NamingException {
        return this.ndnIdx.forwardLookup(dn);
    }

    public String getEntryDn(BigInteger id) throws NamingException {
        return (String)this.ndnIdx.reverseLookup(id);
    }

    public BigInteger getParentId(String dn) throws NamingException {
        BigInteger childId = this.ndnIdx.forwardLookup(dn);
        return (BigInteger)this.hierarchyIdx.reverseLookup(childId);
    }

    public BigInteger getParentId(BigInteger childId) throws NamingException {
        return (BigInteger)this.hierarchyIdx.reverseLookup(childId);
    }

    public String getEntryUpdn(BigInteger id) throws NamingException {
        return (String)this.updnIdx.reverseLookup(id);
    }

    public String getEntryUpdn(String dn) throws NamingException {
        BigInteger id = this.ndnIdx.forwardLookup(dn);
        return (String)this.updnIdx.reverseLookup(id);
    }

    public int count() throws NamingException {
        return this.master.count();
    }

    private void dropAliasIndices(BigInteger aliasId) throws NamingException {
        String targetDn = (String)this.aliasIdx.reverseLookup(aliasId);
        BigInteger targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)new LdapDN(aliasDn).getPrefix(1);
        BigInteger ancestorId = this.getEntryId(ancestorDn.toString());
        this.oneAliasIdx.drop(ancestorId, targetId);
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.normSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
        this.aliasIdx.drop(aliasId);
    }

    private void addAliasIndices(BigInteger aliasId, LdapDN aliasDn, String aliasTarget) throws NamingException {
        LdapDN normalizedAliasTargetDn = null;
        BigInteger targetId = null;
        LdapDN ancestorDn = null;
        BigInteger ancestorId = null;
        normalizedAliasTargetDn = new LdapDN(aliasTarget);
        normalizedAliasTargetDn.normalize(this.attrRegistry.getNormalizerMapping());
        if (aliasDn.startsWith((Name)normalizedAliasTargetDn)) {
            if (aliasDn.equals((Object)normalizedAliasTargetDn)) {
                throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias to itself.");
            }
            throw new NamingException("[36] aliasDereferencingProblem - attempt to create alias with cycle to relative " + aliasTarget + " not allowed from descendent alias " + aliasDn);
        }
        if (!normalizedAliasTargetDn.startsWith((Name)this.normSuffix)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to an entry outside of the " + this.upSuffix.getUpName() + " namingContext to an object whose existance cannot be" + " determined.");
        }
        targetId = this.ndnIdx.forwardLookup(normalizedAliasTargetDn.toNormName());
        if (null == targetId) {
            throw new NamingException("[33] aliasProblem - the alias when dereferenced would not name a known object the aliasedObjectName must be set to a valid existing entry.");
        }
        if (null != this.aliasIdx.reverseLookup(targetId)) {
            throw new NamingException("[36] aliasDereferencingProblem - the alias points to another alias.  Alias chaining is not supported by this backend.");
        }
        this.aliasIdx.add(normalizedAliasTargetDn.getNormName(), aliasId);
        ancestorDn = (LdapDN)aliasDn.clone();
        ancestorDn.remove(aliasDn.size() - 1);
        ancestorId = this.getEntryId(ancestorDn.toNormName());
        if (!NamespaceTools.isSibling((Name)normalizedAliasTargetDn, (Name)aliasDn)) {
            this.oneAliasIdx.add(ancestorId, targetId);
        }
        while (!ancestorDn.equals((Object)this.normSuffix) && null != ancestorId) {
            if (!NamespaceTools.isDescendant((Name)ancestorDn, (Name)normalizedAliasTargetDn)) {
                this.subAliasIdx.add(ancestorId, targetId);
            }
            ancestorDn.remove(ancestorDn.size() - 1);
            ancestorId = this.getEntryId(ancestorDn.toNormName());
        }
    }

    public void add(LdapDN normName, Attributes entry) throws NamingException {
        BigInteger parentId = null;
        BigInteger id = this.master.getNextId();
        LdapDN parentDn = null;
        if (normName.equals((Object)this.normSuffix)) {
            parentId = BigInteger.ZERO;
        } else {
            parentDn = (LdapDN)normName.clone();
            parentDn.remove(parentDn.size() - 1);
            parentId = this.getEntryId(parentDn.toString());
        }
        if (parentId == null) {
            throw new LdapNameNotFoundException("Id for parent '" + parentDn + "' not found!");
        }
        AttributeType octype = this.attrRegistry.lookup("objectClass");
        Attribute objectClass = ServerUtils.getAttribute(octype, entry);
        if (objectClass == null) {
            String msg = "Entry " + normName.getUpName() + " contains no objectClass attribute: " + entry;
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.OBJECTCLASSVIOLATION);
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"alias")) {
            AttributeType aliasType = this.attrRegistry.lookup("aliasedObjectName");
            Attribute aliasAttr = ServerUtils.getAttribute(aliasType, entry);
            this.addAliasIndices(id, normName, (String)aliasAttr.get());
        }
        this.ndnIdx.add(normName.toNormName(), id);
        this.updnIdx.add(normName.getUpName(), id);
        this.hierarchyIdx.add(parentId, id);
        NamingEnumeration<String> list = entry.getIDs();
        while (list.hasMore()) {
            String attributeId = list.next();
            String attributeOid = this.oidRegistry.getOid(attributeId);
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index idx = this.getUserIndex(attributeOid);
            NamingEnumeration<?> values = entry.get(attributeId).getAll();
            while (values.hasMore()) {
                idx.add(values.next(), id);
            }
            this.existanceIdx.add(attributeOid, id);
        }
        this.master.put(entry, id);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    public Attributes lookup(BigInteger id) throws NamingException {
        return this.master.get(id);
    }

    public void delete(BigInteger id) throws NamingException {
        Attributes entry = this.lookup(id);
        BigInteger parentId = this.getParentId(id);
        NamingEnumeration<String> attrs = entry.getIDs();
        AttributeType octype = this.attrRegistry.lookup("objectClass");
        Attribute objectClass = ServerUtils.getAttribute(octype, entry);
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"alias")) {
            this.dropAliasIndices(id);
        }
        this.ndnIdx.drop(id);
        this.updnIdx.drop(id);
        this.hierarchyIdx.drop(id);
        if (!parentId.equals(BigInteger.ZERO)) {
            this.hierarchyIdx.drop(parentId, id);
        }
        while (attrs.hasMore()) {
            String attributeId = attrs.next();
            String attributeOid = this.oidRegistry.getOid(attributeId);
            if (!this.hasUserIndexOn(attributeOid)) continue;
            Index index = this.getUserIndex(attributeOid);
            NamingEnumeration<?> values = entry.get(attributeId).getAll();
            while (values.hasMore()) {
                index.drop(values.next(), id);
            }
            this.existanceIdx.drop(attributeOid, id);
        }
        this.master.delete(id);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    public NamingEnumeration list(BigInteger id) throws NamingException {
        return this.hierarchyIdx.listIndices(id);
    }

    public int getChildCount(BigInteger id) throws NamingException {
        return this.hierarchyIdx.count(id);
    }

    public LdapDN getSuffix() {
        return this.normSuffix;
    }

    public LdapDN getUpSuffix() {
        return this.upSuffix;
    }

    public Attributes getSuffixEntry() throws NamingException {
        BigInteger id = this.getEntryId(this.normSuffix.toNormName());
        if (null == id) {
            return null;
        }
        return this.lookup(id);
    }

    public void setProperty(String propertyName, String propertyValue) throws NamingException {
        this.master.setProperty(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) throws NamingException {
        return this.master.getProperty(propertyName);
    }

    public Attributes getIndices(BigInteger id) throws NamingException {
        IndexRecord rec;
        LockableAttributesImpl attributes = new LockableAttributesImpl();
        attributes.put("_nDn", this.getEntryDn(id));
        attributes.put("_upDn", this.getEntryUpdn(id));
        attributes.put("_parent", this.getParentId(id));
        Iterator idxList = this.indices.values().iterator();
        while (idxList.hasNext()) {
            Index index = (Index)idxList.next();
            IndexEnumeration list = index.listReverseIndices(id);
            while (list.hasMore()) {
                rec = (IndexRecord)list.next();
                Object val = rec.getIndexKey();
                String attrId = index.getAttribute().getName();
                Attribute attr = attributes.get(attrId);
                if (attr == null) {
                    attr = new LockableAttributeImpl(attrId);
                }
                attr.add(val);
                attributes.put(attr);
            }
        }
        IndexEnumeration list = this.existanceIdx.listReverseIndices(id);
        StringBuffer val = new StringBuffer();
        while (list.hasMore()) {
            rec = (IndexRecord)list.next();
            val.append("_existance[");
            val.append(rec.getIndexKey());
            val.append("]");
            String valStr = val.toString();
            Attribute attr = attributes.get(valStr);
            if (attr == null) {
                attr = new LockableAttributeImpl(valStr);
            }
            attr.add(rec.getEntryId());
            attributes.put(attr);
            val.setLength(0);
        }
        list = this.hierarchyIdx.listIndices(id);
        LockableAttributeImpl childAttr = new LockableAttributeImpl("_child");
        attributes.put((Attribute)childAttr);
        while (list.hasMore()) {
            IndexRecord rec2 = (IndexRecord)list.next();
            childAttr.add(rec2.getEntryId());
        }
        return attributes;
    }

    private void add(BigInteger id, Attributes entry, Attribute mods) throws NamingException {
        AttributeType type;
        Attribute entryAttrToAddTo;
        String modsOid = this.oidRegistry.getOid(mods.getID());
        if (this.hasUserIndexOn(modsOid)) {
            Index idx = this.getUserIndex(modsOid);
            idx.add(mods, id);
            if (!this.existanceIdx.hasValue(modsOid, id)) {
                this.existanceIdx.add(modsOid, id);
            }
        }
        if ((entryAttrToAddTo = ServerUtils.getAttribute(type = this.attrRegistry.lookup(modsOid), entry)) == null) {
            entryAttrToAddTo = new LockableAttributeImpl(mods.getID());
            entry.put(entryAttrToAddTo);
        }
        for (int ii = 0; ii < mods.size(); ++ii) {
            entryAttrToAddTo.add(mods.get(ii));
        }
        if (modsOid.equals(this.oidRegistry.getOid("aliasedObjectName"))) {
            String ndnStr = (String)this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new LdapDN(ndnStr), (String)mods.get());
        }
    }

    private void remove(BigInteger id, Attributes entry, Attribute mods) throws NamingException {
        String modsOid = this.oidRegistry.getOid(mods.getID());
        if (this.hasUserIndexOn(modsOid)) {
            Index idx = this.getUserIndex(modsOid);
            idx.drop(mods, id);
            if (null == idx.reverseLookup(id)) {
                this.existanceIdx.drop(modsOid, id);
            }
        }
        AttributeType attrType = this.attrRegistry.lookup(modsOid);
        if (mods.size() == 0) {
            ServerUtils.removeAttribute(attrType, entry);
        } else {
            Attribute entryAttr = ServerUtils.getAttribute(attrType, entry);
            NamingEnumeration<?> values = mods.getAll();
            while (values.hasMore()) {
                entryAttr.remove(values.next());
            }
            if (entryAttr.size() == 0) {
                entry.remove(entryAttr.getID());
            }
        }
        if (modsOid.equals(this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
    }

    private void replace(BigInteger id, Attributes entry, Attribute mods) throws NamingException {
        String aliasAttributeOid;
        String modsOid = this.oidRegistry.getOid(mods.getID());
        if (this.hasUserIndexOn(modsOid)) {
            Index idx = this.getUserIndex(modsOid);
            idx.drop(id);
            idx.add(mods, id);
            if (null == idx.reverseLookup(id)) {
                this.existanceIdx.drop(modsOid, id);
            }
        }
        if (modsOid.equals(aliasAttributeOid = this.oidRegistry.getOid("aliasedObjectName"))) {
            this.dropAliasIndices(id);
        }
        if (mods.size() > 0) {
            entry.put(mods);
        } else {
            entry.remove(mods.getID());
        }
        if (modsOid.equals(aliasAttributeOid) && mods.size() > 0) {
            String ndnStr = (String)this.ndnIdx.reverseLookup(id);
            this.addAliasIndices(id, new LdapDN(ndnStr), (String)mods.get());
        }
    }

    public void modify(LdapDN dn, int modOp, Attributes mods) throws NamingException {
        NamingEnumeration<String> attrs = null;
        BigInteger id = this.getEntryId(dn.toString());
        Attributes entry = this.master.get(id);
        switch (modOp) {
            case 1: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.add(id, entry, attr);
                }
                break;
            }
            case 3: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.remove(id, entry, attr);
                }
                break;
            }
            case 2: {
                attrs = mods.getIDs();
                while (attrs.hasMore()) {
                    String attrId = attrs.next();
                    Attribute attr = mods.get(attrId);
                    this.replace(id, entry, attr);
                }
                break;
            }
            default: {
                throw new NamingException("Unidentified modification operation");
            }
        }
        this.master.put(entry, id);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    public void modify(LdapDN dn, ModificationItemImpl[] mods) throws NamingException {
        BigInteger id = this.getEntryId(dn.toString());
        Attributes entry = this.master.get(id);
        block5: for (int ii = 0; ii < mods.length; ++ii) {
            Attribute attrMods = mods[ii].getAttribute();
            switch (mods[ii].getModificationOp()) {
                case 1: {
                    this.add(id, entry, attrMods);
                    continue block5;
                }
                case 3: {
                    this.remove(id, entry, attrMods);
                    continue block5;
                }
                case 2: {
                    this.replace(id, entry, attrMods);
                    continue block5;
                }
                default: {
                    throw new NamingException("Unidentified modification operation");
                }
            }
        }
        this.master.put(entry, id);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    public void modifyRn(LdapDN dn, String newRdn, boolean deleteOldRdn) throws NamingException {
        String newRdnAttr = NamespaceTools.getRdnAttribute((String)newRdn);
        String newRdnValue = NamespaceTools.getRdnValue((String)newRdn);
        BigInteger id = this.getEntryId(dn.toString());
        Attributes entry = this.lookup(id);
        LdapDN updn = new LdapDN(this.getEntryUpdn(id));
        String newRdnAttrOid = this.oidRegistry.getOid(newRdnAttr);
        AttributeType newRdnAttrType = this.attrRegistry.lookup(newRdnAttrOid);
        Attribute rdnAttr = ServerUtils.getAttribute(newRdnAttrType, entry);
        if (rdnAttr == null) {
            rdnAttr = new LockableAttributeImpl(newRdnAttr);
        }
        if (!rdnAttr.contains(newRdnValue)) {
            rdnAttr.add(newRdnValue);
        }
        entry.put(rdnAttr);
        if (this.hasUserIndexOn(newRdnAttrOid)) {
            Index idx = this.getUserIndex(newRdnAttrOid);
            idx.add(newRdnValue, id);
            if (!this.existanceIdx.hasValue(newRdnAttrOid, id)) {
                this.existanceIdx.add(newRdnAttrOid, id);
            }
        }
        if (deleteOldRdn) {
            String oldRdn = updn.get(updn.size() - 1);
            String oldRdnAttr = NamespaceTools.getRdnAttribute((String)oldRdn);
            String oldRdnAttrOid = this.oidRegistry.getOid(oldRdnAttr);
            String oldRdnValue = NamespaceTools.getRdnValue((String)oldRdn);
            AttributeType oldRdnAttrType = this.attrRegistry.lookup(oldRdnAttrOid);
            ServerUtils.getAttribute(oldRdnAttrType, entry).remove(oldRdnValue);
            if (this.hasUserIndexOn(oldRdnAttrOid)) {
                Index idx = this.getUserIndex(oldRdnAttrOid);
                idx.drop(oldRdnValue, id);
                if (null == idx.reverseLookup(id)) {
                    this.existanceIdx.drop(oldRdnAttrOid, id);
                }
            }
        }
        LdapDN newUpdn = (LdapDN)updn.clone();
        newUpdn.remove(newUpdn.size() - 1);
        newUpdn.add(newUpdn.size(), newRdn);
        this.modifyDn(id, newUpdn, false);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    private void modifyDn(BigInteger id, LdapDN updn, boolean isMove) throws NamingException {
        String aliasTarget = null;
        this.ndnIdx.drop(id);
        LdapDN normalizedDn = LdapDN.normalize((LdapDN)updn, (Map)this.attrRegistry.getNormalizerMapping());
        this.ndnIdx.add(this.ndnIdx.getNormalized(normalizedDn.toNormName()), id);
        this.updnIdx.drop(id);
        this.updnIdx.add(updn.getUpName(), id);
        if (isMove && null != (aliasTarget = (String)this.aliasIdx.reverseLookup(id))) {
            this.addAliasIndices(id, new LdapDN(this.getEntryDn(id)), aliasTarget);
        }
        NamingEnumeration children = this.list(id);
        while (children.hasMore()) {
            IndexRecord rec = (IndexRecord)children.next();
            BigInteger childId = rec.getEntryId();
            LdapDN childUpdn = (LdapDN)updn.clone();
            LdapDN oldUpdn = new LdapDN(this.getEntryUpdn(childId));
            String rdn = oldUpdn.get(oldUpdn.size() - 1);
            childUpdn.add(childUpdn.size(), rdn);
            this.modifyDn(childId, childUpdn, isMove);
        }
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn, String newRdn, boolean deleteOldRdn) throws NamingException {
        BigInteger childId = this.getEntryId(oldChildDn.toString());
        this.modifyRn(oldChildDn, newRdn, deleteOldRdn);
        this.move(oldChildDn, childId, newParentDn);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    public void move(LdapDN oldChildDn, LdapDN newParentDn) throws NamingException {
        BigInteger childId = this.getEntryId(oldChildDn.toString());
        this.move(oldChildDn, childId, newParentDn);
        if (this.cfg.isSynchOnWrite()) {
            this.sync();
        }
    }

    private void move(LdapDN oldChildDn, BigInteger childId, LdapDN newParentDn) throws NamingException {
        BigInteger newParentId = this.getEntryId(newParentDn.toString());
        BigInteger oldParentId = this.getParentId(childId);
        this.dropMovedAliasIndices(oldChildDn);
        this.hierarchyIdx.drop(oldParentId, childId);
        this.hierarchyIdx.add(newParentId, childId);
        LdapDN childUpdn = new LdapDN(this.getEntryUpdn(childId));
        String childRdn = childUpdn.get(childUpdn.size() - 1);
        LdapDN newUpdn = new LdapDN(this.getEntryUpdn(newParentId));
        newUpdn.add(newUpdn.size(), childRdn);
        this.modifyDn(childId, newUpdn, true);
    }

    private void dropMovedAliasIndices(final LdapDN movedBase) throws NamingException {
        IndexAssertion isBaseDescendant = new IndexAssertion(){

            public boolean assertCandidate(IndexRecord rec) throws NamingException {
                String dn = JdbmPartition.this.getEntryDn(rec.getEntryId());
                return dn.endsWith(movedBase.toString());
            }
        };
        BigInteger movedBaseId = this.getEntryId(movedBase.toString());
        if (this.aliasIdx.reverseLookup(movedBaseId) != null) {
            this.dropAliasIndices(movedBaseId, movedBase);
        }
        IndexAssertionEnumeration aliases = new IndexAssertionEnumeration(this.aliasIdx.listIndices(movedBase.toString(), true), isBaseDescendant);
        while (aliases.hasMore()) {
            IndexRecord entry = (IndexRecord)aliases.next();
            this.dropAliasIndices(entry.getEntryId(), movedBase);
        }
    }

    private void dropAliasIndices(BigInteger aliasId, LdapDN movedBase) throws NamingException {
        String targetDn = (String)this.aliasIdx.reverseLookup(aliasId);
        BigInteger targetId = this.getEntryId(targetDn);
        String aliasDn = this.getEntryDn(aliasId);
        LdapDN ancestorDn = (LdapDN)movedBase.getPrefix(1);
        BigInteger ancestorId = this.getEntryId(ancestorDn.toString());
        if (aliasDn.equals(movedBase.toString())) {
            this.oneAliasIdx.drop(ancestorId, targetId);
        }
        this.subAliasIdx.drop(ancestorId, targetId);
        while (!ancestorDn.equals((Object)this.upSuffix)) {
            ancestorDn = (LdapDN)ancestorDn.getPrefix(1);
            ancestorId = this.getEntryId(ancestorDn.toString());
            this.subAliasIdx.drop(ancestorId, targetId);
        }
    }

    public void bind(LdapDN bindDn, byte[] credentials, List mechanisms, String saslAuthId) throws NamingException {
        throw new LdapAuthenticationNotSupportedException("Bind requests only tunnel down into partitions if there are no authenticators to handle the mechanism.\nCheck to see if you have correctly configured authenticators for the server.", ResultCodeEnum.AUTHMETHODNOTSUPPORTED);
    }

    public void unbind(LdapDN bindDn) throws NamingException {
    }
}

