/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.TupleBrowser;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.directory.server.core.partition.impl.btree.KeyOnlyComparator;
import org.apache.directory.server.core.partition.impl.btree.NoDupsEnumeration;
import org.apache.directory.server.core.partition.impl.btree.Table;
import org.apache.directory.server.core.partition.impl.btree.Tuple;
import org.apache.directory.server.core.partition.impl.btree.TupleComparator;
import org.apache.directory.server.core.partition.impl.btree.TupleEnumeration;
import org.apache.directory.server.core.partition.impl.btree.TupleRenderer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeEnumeration;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeTupleEnumeration;
import org.apache.directory.server.core.partition.impl.btree.jdbm.DupsEnumeration;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTupleBrowser;
import org.apache.directory.server.core.schema.SerializableComparator;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.util.EmptyEnumeration;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;

public class JdbmTable
implements Table {
    private static final String SZSUFFIX = "_btree_sz";
    private final String name;
    private final RecordManager recMan;
    private final boolean allowsDuplicates;
    private final TupleComparator comparator;
    private int count = 0;
    private BTree bt;
    private TupleRenderer renderer;
    private int numDupLimit = 512;
    private Map duplicateBtrees = new HashMap();
    private static final byte[] EMPTY_BYTES = new byte[0];

    public JdbmTable(String name, boolean allowsDuplicates, int numDupLimit, RecordManager manager, TupleComparator comparator) throws NamingException {
        long recId;
        this.numDupLimit = numDupLimit;
        this.name = name;
        this.recMan = manager;
        this.comparator = comparator;
        this.allowsDuplicates = allowsDuplicates;
        try {
            recId = this.recMan.getNamedObject(name);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        try {
            if (recId != 0L) {
                this.bt = BTree.load((RecordManager)this.recMan, (long)recId);
                recId = this.recMan.getNamedObject(name + SZSUFFIX);
                this.count = (Integer)this.recMan.fetch(recId);
            } else {
                this.bt = BTree.createInstance((RecordManager)this.recMan, (Comparator)comparator.getKeyComparator());
                recId = this.bt.getRecid();
                this.recMan.setNamedObject(name, recId);
                recId = this.recMan.insert((Object)new Integer(0));
                this.recMan.setNamedObject(name + SZSUFFIX, recId);
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    public JdbmTable(String name, RecordManager manager, SerializableComparator keyComparator) throws NamingException {
        this(name, false, Integer.MAX_VALUE, manager, new KeyOnlyComparator(keyComparator));
    }

    public TupleComparator getComparator() {
        return this.comparator;
    }

    public boolean isDupsEnabled() {
        return this.allowsDuplicates;
    }

    public String getName() {
        return this.name;
    }

    public TupleRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TupleRenderer renderer) {
        this.renderer = renderer;
    }

    public boolean isSortedDupsEnabled() {
        return this.allowsDuplicates;
    }

    public int count(Object key, boolean isGreaterThan) throws NamingException {
        return this.count;
    }

    public int count(Object key) throws NamingException {
        if (!this.allowsDuplicates) {
            if (null == this.getRaw(key)) {
                return 0;
            }
            return 1;
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return 0;
        }
        if (values instanceof TreeSet) {
            return ((TreeSet)values).size();
        }
        if (values instanceof BTreeRedirect) {
            return this.getBTree((BTreeRedirect)values).size();
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public int count() throws NamingException {
        return this.count;
    }

    public Object get(Object key) throws NamingException {
        if (!this.allowsDuplicates) {
            return this.getRaw(key);
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return null;
        }
        if (values instanceof TreeSet) {
            TreeSet set = (TreeSet)values;
            if (set.size() == 0) {
                return null;
            }
            return set.first();
        }
        if (values instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)values);
            if (tree.size() == 0) {
                return null;
            }
            return this.firstKey(tree);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public boolean has(Object key, Object val, boolean isGreaterThan) throws NamingException {
        if (!this.allowsDuplicates) {
            Object rval = this.getRaw(key);
            if (null == rval) {
                return false;
            }
            if (val.equals(rval)) {
                return true;
            }
            if (this.comparator.compareValue(rval, val) >= 1 && isGreaterThan) {
                return true;
            }
            return this.comparator.compareValue(rval, val) <= 1 && !isGreaterThan;
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return false;
        }
        if (values instanceof TreeSet) {
            TreeSet set = (TreeSet)values;
            SortedSet<Object> subset = null;
            if (set.size() == 0) {
                return false;
            }
            subset = isGreaterThan ? set.tailSet(val) : set.headSet(val);
            return subset.size() > 0 || set.contains(val);
        }
        if (values instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)values);
            if (tree.size() == 0) {
                return false;
            }
            return this.btreeHas(tree, val, isGreaterThan);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public boolean has(Object key, boolean isGreaterThan) throws NamingException {
        try {
            jdbm.helper.Tuple tuple = this.bt.findGreaterOrEqual(key);
            if (null != tuple && this.comparator.compareKey(tuple.getKey(), key) == 0) {
                return true;
            }
            if (isGreaterThan) {
                return null != tuple;
            }
            TupleBrowser browser = null;
            if (null == tuple) {
                tuple = new jdbm.helper.Tuple();
                browser = this.bt.browse();
                if (browser.getNext(tuple)) {
                    return this.comparator.compareKey(tuple.getKey(), key) <= 0;
                }
            } else {
                browser = this.bt.browse(tuple.getKey());
                if (this.comparator.compareKey(tuple.getKey(), key) <= 0) {
                    return true;
                }
                browser.getNext(tuple);
                while (browser.getPrevious(tuple)) {
                    if (this.comparator.compareKey(tuple.getKey(), key) > 0) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return false;
    }

    public boolean has(Object key, Object value) throws NamingException {
        if (!this.allowsDuplicates) {
            Object obj = this.getRaw(key);
            if (null == obj) {
                return false;
            }
            return obj.equals(value);
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return false;
        }
        if (values instanceof TreeSet) {
            return ((TreeSet)values).contains(value);
        }
        if (values instanceof BTreeRedirect) {
            return this.btreeHas(this.getBTree((BTreeRedirect)values), value);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public boolean has(Object key) throws NamingException {
        return this.getRaw(key) != null;
    }

    public Object put(Object key, Object value) throws NamingException {
        Object replaced = null;
        if (!this.allowsDuplicates) {
            replaced = this.putRaw(key, value, true);
            if (null == replaced) {
                ++this.count;
            }
            return replaced;
        }
        TreeSet values = this.getRaw(key);
        if (values == null) {
            values = new TreeSet(this.comparator.getValueComparator());
        }
        if (values instanceof TreeSet) {
            TreeSet set = values;
            if (set.contains(value)) {
                return value;
            }
            boolean addSuccessful = set.add(value);
            if (set.size() > this.numDupLimit) {
                BTree tree = this.convertToBTree(set);
                BTreeRedirect redirect = new BTreeRedirect(tree.getRecid());
                replaced = this.putRaw(key, redirect, true);
            } else {
                replaced = this.putRaw(key, set, true);
            }
            if (addSuccessful) {
                ++this.count;
                return replaced;
            }
            return null;
        }
        if (values instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)((Object)values));
            if (this.insertDupIntoBTree(tree, value)) {
                ++this.count;
                return values;
            }
            return null;
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public Object put(Object key, NamingEnumeration values) throws NamingException {
        if (!this.allowsDuplicates) {
            if (values.hasMore()) {
                Object value = values.next();
                if (values.hasMore()) {
                    throw new UnsupportedOperationException("Attempting to put duplicate keys into table " + this.name + " which does not support duplicates");
                }
                return this.put(key, value);
            }
            return null;
        }
        TreeSet storedValues = this.getRaw(key);
        if (storedValues == null) {
            storedValues = new TreeSet(this.comparator.getValueComparator());
        }
        if (storedValues instanceof TreeSet) {
            TreeSet set = storedValues;
            while (values.hasMore()) {
                boolean isAddSuccessful;
                Object val = values.next();
                if (set.contains(val) || !(isAddSuccessful = set.add(val))) continue;
                ++this.count;
            }
            if (set.size() > this.numDupLimit) {
                BTree tree = this.convertToBTree(set);
                BTreeRedirect redirect = new BTreeRedirect(tree.getRecid());
                return this.putRaw(key, redirect, true);
            }
            return this.putRaw(key, set, true);
        }
        if (storedValues instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)((Object)storedValues));
            while (values.hasMore()) {
                Object val = values.next();
                if (!this.insertDupIntoBTree(tree, val)) continue;
                ++this.count;
            }
            return storedValues;
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public Object remove(Object key, Object value) throws NamingException {
        if (!this.allowsDuplicates) {
            Object oldValue = this.getRaw(key);
            if (oldValue != null && oldValue.equals(value)) {
                this.removeRaw(key);
                --this.count;
                return oldValue;
            }
            return null;
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return null;
        }
        if (values instanceof TreeSet) {
            TreeSet set = (TreeSet)values;
            if (set.remove(value)) {
                if (set.isEmpty()) {
                    this.removeRaw(key);
                } else {
                    this.putRaw(key, set, true);
                }
                --this.count;
                return value;
            }
            return null;
        }
        if (values instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)values);
            if (this.removeDupFromBTree(tree, value)) {
                if (tree.size() == 0) {
                    this.removeRaw(key);
                }
                --this.count;
                return value;
            }
            return null;
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public Object remove(Object key, NamingEnumeration values) throws NamingException {
        if (!this.allowsDuplicates) {
            if (values.hasMore()) {
                Object value = values.next();
                if (values.hasMore()) {
                    throw new UnsupportedOperationException("Attempting to remove duplicate keys from table " + this.name + " which does not support duplicates");
                }
                return this.remove(key, value);
            }
            return null;
        }
        Object storedValues = this.getRaw(key);
        if (storedValues == null) {
            return null;
        }
        if (storedValues instanceof TreeSet) {
            TreeSet set = (TreeSet)storedValues;
            Object firstValue = null;
            while (values.hasMore()) {
                Object val = values.next();
                if (firstValue == null) {
                    firstValue = val;
                }
                if (!set.contains(val)) continue;
                set.remove(val);
                --this.count;
            }
            this.putRaw(key, set, true);
            return firstValue;
        }
        if (storedValues instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)storedValues);
            Object first = null;
            while (values.hasMore()) {
                Object val = values.next();
                if (!this.removeDupFromBTree(tree, val)) continue;
                --this.count;
                if (first != null) continue;
                first = val;
            }
            return first;
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public Object remove(Object key) throws NamingException {
        Object returned = this.removeRaw(key);
        if (null == returned) {
            return null;
        }
        if (!this.allowsDuplicates) {
            --this.count;
            return returned;
        }
        if (returned instanceof TreeSet) {
            TreeSet set = (TreeSet)returned;
            this.count -= set.size();
            return set.first();
        }
        if (returned instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)returned);
            this.count -= tree.size();
            return this.removeAll(tree);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public NamingEnumeration listValues(Object key) throws NamingException {
        if (!this.allowsDuplicates) {
            Object value = this.get(key);
            if (null == value) {
                return new EmptyEnumeration();
            }
            return new SingletonEnumeration(value);
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return new EmptyEnumeration();
        }
        if (values instanceof TreeSet) {
            TreeSet set = (TreeSet)values;
            final Iterator list = set.iterator();
            return new NamingEnumeration(){

                public void close() {
                }

                public Object nextElement() {
                    return list.next();
                }

                public Object next() {
                    return list.next();
                }

                public boolean hasMore() {
                    return list.hasNext();
                }

                public boolean hasMoreElements() {
                    return list.hasNext();
                }
            };
        }
        if (values instanceof BTreeRedirect) {
            BTree tree = this.getBTree((BTreeRedirect)values);
            return new BTreeEnumeration(tree);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public NamingEnumeration listTuples() throws NamingException {
        NoDupsEnumeration list = null;
        try {
            JdbmTupleBrowser browser = new JdbmTupleBrowser(this.bt.browse());
            list = new NoDupsEnumeration(browser, true);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        if (this.allowsDuplicates) {
            return new DupsEnumeration(this, list);
        }
        return list;
    }

    public NamingEnumeration listTuples(Object key) throws NamingException {
        if (!this.allowsDuplicates) {
            Object val = this.getRaw(key);
            if (null == val) {
                return new EmptyEnumeration();
            }
            return new SingletonEnumeration((Object)new Tuple(key, this.getRaw(key)));
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return new EmptyEnumeration();
        }
        if (values instanceof TreeSet) {
            TreeSet set = (TreeSet)values;
            Object[] objs = new Object[set.size()];
            objs = set.toArray(objs);
            ArrayIterator iterator = new ArrayIterator((Object)objs);
            return new TupleEnumeration(key, (Iterator)iterator);
        }
        if (values instanceof BTreeRedirect) {
            return new BTreeTupleEnumeration(this.getBTree((BTreeRedirect)values), key);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public NamingEnumeration listTuples(Object key, boolean isGreaterThan) throws NamingException {
        NamingEnumeration list = null;
        try {
            if (isGreaterThan) {
                JdbmTupleBrowser browser = new JdbmTupleBrowser(this.bt.browse(key));
                list = new NoDupsEnumeration(browser, isGreaterThan);
            } else {
                Object greaterKey;
                jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
                TupleBrowser browser = this.bt.browse(key);
                if (browser.getNext(tuple) && 0 != this.comparator.compareKey(key, greaterKey = tuple.getKey())) {
                    browser.getPrevious(tuple);
                }
                list = new NoDupsEnumeration(new JdbmTupleBrowser(browser), isGreaterThan);
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException("Failed to get TupleBrowser on table " + this.name + " using key " + this.renderKey(key));
            ne.setRootCause(e);
            throw ne;
        }
        if (this.allowsDuplicates) {
            list = new DupsEnumeration(this, (NoDupsEnumeration)list);
        }
        return list;
    }

    public NamingEnumeration listTuples(Object key, Object val, boolean isGreaterThan) throws NamingException {
        if (!this.allowsDuplicates) {
            throw new UnsupportedOperationException("Cannot list tuples over duplicates on table that does not support duplicates.");
        }
        Object values = this.getRaw(key);
        if (values == null) {
            return new EmptyEnumeration();
        }
        if (values instanceof TreeSet) {
            TreeSet set = (TreeSet)values;
            if (isGreaterThan) {
                SortedSet<Object> tailSet = set.tailSet(val);
                if (tailSet.isEmpty()) {
                    return new EmptyEnumeration();
                }
                Object[] objs = new Object[tailSet.size()];
                objs = tailSet.toArray(objs);
                ArrayIterator iterator = new ArrayIterator((Object)objs);
                return new TupleEnumeration(key, (Iterator)iterator);
            }
            SortedSet<Object> headset = set.headSet(val);
            ArrayList<Object> list = new ArrayList<Object>(headset.size() + 1);
            list.addAll(headset);
            if (set.contains(val)) {
                list.add(val);
            }
            Collections.reverse(list);
            return new TupleEnumeration(key, list.iterator());
        }
        if (values instanceof BTreeRedirect) {
            return new BTreeTupleEnumeration(this.getBTree((BTreeRedirect)values), this.comparator.getValueComparator(), key, val, isGreaterThan);
        }
        throw new IllegalStateException("When using duplicate keys either a TreeSet or BTree is used for values.");
    }

    public synchronized void close() throws NamingException {
        this.sync();
    }

    public void sync() throws NamingException {
        try {
            long recId = this.recMan.getNamedObject(this.name + SZSUFFIX);
            if (0L == recId) {
                recId = this.recMan.insert((Object)new Integer(this.count));
            } else {
                this.recMan.update(recId, (Object)new Integer(this.count));
            }
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    private String renderKey(Object obj) {
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        if (null == this.renderer) {
            buf.append(obj.toString());
        } else {
            buf.append(this.renderer.getKeyString(obj));
        }
        buf.append("'");
        return buf.toString();
    }

    private Object getRaw(Object key) throws NamingException {
        Object val = null;
        if (null == key) {
            return null;
        }
        try {
            val = !this.allowsDuplicates ? this.bt.find(key) : this.bt.find(key);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return val;
    }

    private Object putRaw(Object key, Object value, boolean doReplace) throws NamingException {
        Object val = null;
        try {
            val = this.bt.insert(key, value, doReplace);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return val;
    }

    private Object removeRaw(Object key) throws NamingException {
        Object val = null;
        try {
            val = this.bt.remove(key);
        }
        catch (IOException e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return val;
    }

    BTree getBTree(BTreeRedirect redirect) throws NamingException {
        if (this.duplicateBtrees.containsKey(redirect.getRecId())) {
            return (BTree)this.duplicateBtrees.get(redirect.getRecId());
        }
        try {
            BTree tree = BTree.load((RecordManager)this.recMan, (long)redirect.getRecId());
            this.duplicateBtrees.put(redirect.getRecId(), tree);
            return tree;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failed to load btree", ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private Object firstKey(BTree tree) throws NamingException {
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        boolean success = false;
        try {
            success = tree.browse().getNext(tuple);
            if (success) {
                return tuple.getKey();
            }
            return null;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("IO failure while acessing btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private boolean btreeHas(BTree tree, Object key, boolean isGreaterThan) throws NamingException {
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        try {
            Object biggerKey;
            TupleBrowser browser = tree.browse(key);
            if (isGreaterThan) {
                boolean success = browser.getNext(tuple);
                return success;
            }
            boolean success = browser.getPrevious(tuple);
            if (success) {
                return true;
            }
            success = browser.getNext(tuple);
            return success && this.comparator.compareValue(key, biggerKey = tuple.getKey()) == 0;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("IO failure while acessing btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private boolean btreeHas(BTree tree, Object key) throws NamingException {
        jdbm.helper.Tuple tuple = new jdbm.helper.Tuple();
        try {
            TupleBrowser browser = tree.browse(key);
            boolean success = browser.getNext(tuple);
            return success && this.comparator.compareValue(key, tuple.getKey()) == 0;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("IO failure while acessing btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private boolean insertDupIntoBTree(BTree tree, Object value) throws LdapNamingException {
        try {
            Object replaced = tree.insert(value, (Object)EMPTY_BYTES, true);
            return null == replaced;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failed to insert dup into BTree", ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private boolean removeDupFromBTree(BTree tree, Object value) throws LdapNamingException {
        try {
            Object removed = null;
            if (tree.find(value) != null) {
                removed = tree.remove(value);
            }
            return null != removed;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failed to remove dup from BTree", ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private BTree convertToBTree(TreeSet set) throws NamingException {
        try {
            BTree tree = BTree.createInstance((RecordManager)this.recMan, (Comparator)this.comparator.getValueComparator());
            Iterator ii = set.iterator();
            while (ii.hasNext()) {
                tree.insert(ii.next(), (Object)EMPTY_BYTES, true);
            }
            return tree;
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failed to convert TreeSet values to BTree", ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private Object removeAll(BTree tree) throws NamingException {
        Object first = null;
        jdbm.helper.Tuple jdbmTuple = new jdbm.helper.Tuple();
        try {
            TupleBrowser browser = tree.browse();
            while (browser.getNext(jdbmTuple)) {
                tree.remove(jdbmTuple.getKey());
                if (first != null) continue;
                first = jdbmTuple.getKey();
            }
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failed to remove all keys in BTree", ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
        return first;
    }
}

