/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.referral;

import java.util.HashSet;
import java.util.Set;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralLut {
    private static final Logger log = LoggerFactory.getLogger((Class)ReferralLut.class);
    private Set names = new HashSet();

    public boolean isReferral(LdapDN dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        return this.names.contains(dn.toString());
    }

    public boolean isReferral(String dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        return this.names.contains(dn);
    }

    public LdapDN getFarthestReferralAncestor(LdapDN dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        LdapDN farthest = new LdapDN();
        for (int ii = 0; ii < dn.size(); ++ii) {
            try {
                farthest.add(dn.get(ii));
            }
            catch (InvalidNameException e) {
                log.error("Should never get this when moving names from a proper normalized name!", (Throwable)e);
            }
            if (!this.isReferral(farthest) || farthest.size() == dn.size()) continue;
            return farthest;
        }
        return null;
    }

    public LdapDN getNearestReferralAncestor(LdapDN dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        LdapDN cloned = (LdapDN)dn.clone();
        if (cloned.size() > 0) {
            try {
                cloned.remove(cloned.size() - 1);
            }
            catch (InvalidNameException e) {
                log.error("Should never get this when removing from a cloned normalized name!", (Throwable)e);
            }
        } else {
            return null;
        }
        while (!this.isReferral(cloned) && cloned.size() > 0) {
            try {
                cloned.remove(cloned.size() - 1);
            }
            catch (InvalidNameException e) {
                log.error("Should never get this when removing from a cloned normalized name!", (Throwable)e);
            }
        }
        return cloned.isEmpty() ? null : cloned;
    }

    public void referralAdded(LdapDN dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        if (!this.names.add(dn.toString()) && log.isWarnEnabled()) {
            log.warn("found " + dn + " in refname lut while adding it");
        }
    }

    public void referralAdded(String dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        if (!this.names.add(dn) && log.isWarnEnabled()) {
            log.warn("found " + dn + " in refname lut while adding it");
        }
    }

    public void referralDeleted(LdapDN dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        if (!this.names.remove(dn.toString()) && log.isWarnEnabled()) {
            log.warn("cound not find " + dn + " in refname lut while deleting it");
        }
    }

    public void referralDeleted(String dn) {
        if (dn == null) {
            throw new IllegalArgumentException("dn cannot be null");
        }
        if (!this.names.remove(dn) && log.isWarnEnabled()) {
            log.warn("cound not find " + dn + " in refname lut while deleting it");
        }
    }

    public void referralChanged(LdapDN oldDn, LdapDN newDn) {
        if (oldDn == null || newDn == null) {
            throw new IllegalArgumentException("old or new dn cannot be null");
        }
        if (!this.names.remove(oldDn.toString()) && log.isWarnEnabled()) {
            log.warn("cound not find old name (" + oldDn + ") in refname lut while moving or renaming it");
        }
        if (!this.names.add(newDn.toString()) && log.isWarnEnabled()) {
            log.warn("found new name (" + newDn + ") in refname lut while moving or renaming " + oldDn);
        }
    }

    public void referralChanged(String oldDn, String newDn) {
        if (oldDn == null || newDn == null) {
            throw new IllegalArgumentException("old or new dn cannot be null");
        }
        if (!this.names.remove(oldDn) && log.isWarnEnabled()) {
            log.warn("cound not find old name (" + oldDn + ") in refname lut while moving or renaming it");
        }
        if (!this.names.add(newDn) && log.isWarnEnabled()) {
            log.warn("found new name (" + newDn + ") in refname lut while moving or renaming " + oldDn);
        }
    }

    public void referralChanged(LdapDN oldDn, String newDn) {
        if (oldDn == null || newDn == null) {
            throw new IllegalArgumentException("old or new dn cannot be null");
        }
        if (!this.names.remove(oldDn.toString()) && log.isWarnEnabled()) {
            log.warn("cound not find old name (" + oldDn + ") in refname lut while moving or renaming it");
        }
        if (!this.names.add(newDn) && log.isWarnEnabled()) {
            log.warn("found new name (" + newDn + ") in refname lut while moving or renaming " + oldDn);
        }
    }

    public void referralChanged(String oldDn, LdapDN newDn) {
        if (oldDn == null || newDn == null) {
            throw new IllegalArgumentException("old or new dn cannot be null");
        }
        if (!this.names.remove(oldDn) && log.isWarnEnabled()) {
            log.warn("cound not find old name (" + oldDn + ") in refname lut while moving or renaming it");
        }
        if (!this.names.add(newDn) && log.isWarnEnabled()) {
            log.warn("found new name (" + newDn + ") in refname lut while moving or renaming " + oldDn);
        }
    }
}

