/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.server.core.schema.OidRegistry;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.StringTools;

public class RefinementLeafEvaluator {
    private final OidRegistry registry;

    public RefinementLeafEvaluator(OidRegistry registry) {
        this.registry = registry;
    }

    public boolean evaluate(SimpleNode node, Attribute objectClasses) throws NamingException {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (node.getAssertionType() != 0) {
            throw new NamingException("Unrecognized assertion type for refinement node: " + node.getAssertionType());
        }
        if (!node.getAttribute().equalsIgnoreCase("objectclass")) {
            throw new NamingException("Refinement leaf node attribute was " + node.getAttribute());
        }
        if (null == objectClasses) {
            throw new IllegalArgumentException("objectClasses argument cannot be null");
        }
        if (!objectClasses.getID().equalsIgnoreCase("objectclass")) {
            throw new IllegalArgumentException("objectClasses attribute must be for ID 'objectClass'");
        }
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)node.getValue())) {
            return true;
        }
        String value = null;
        value = node.getValue() instanceof String ? (String)node.getValue() : (node.getValue() instanceof byte[] ? "#" + StringTools.toHexString((byte[])((byte[])node.getValue())) : node.getValue().toString());
        if (Character.isDigit(value.charAt(0))) {
            Iterator list = this.registry.getNameSet(value).iterator();
            while (list.hasNext()) {
                String objectClass = (String)list.next();
                if (!AttributeUtils.containsValueCaseIgnore((Attribute)objectClasses, (Object)objectClass)) continue;
                return true;
            }
        }
        return false;
    }
}

