/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import org.apache.directory.daemon.DaemonApplication;
import org.apache.directory.daemon.InstallationLayout;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.core.configuration.SyncConfiguration;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Service
implements DaemonApplication {
    private static final Logger log = LoggerFactory.getLogger((Class)Service.class);
    private Properties env;
    private Thread workerThread = null;
    private SynchWorker worker = new SynchWorker();
    private MutableServerStartupConfiguration cfg;
    private boolean startNoWait = false;
    public static final String BANNER = "           _                     _          ____  ____   \n          / \\   _ __   __ _  ___| |__   ___|  _ \\/ ___|  \n         / _ \\ | '_ \\ / _` |/ __| '_ \\ / _ \\ | | \\___ \\   \n        / ___ \\| |_) | (_| | (__| | | |  __/ |_| |___) |  \n       /_/   \\_\\ .__/ \\__,_|\\___|_| |_|\\___|____/|____/   \n               |_|                                                               \n";

    public void init(InstallationLayout install, String[] args) throws Exception {
        Service.printBanner();
        long startTime = System.currentTimeMillis();
        if (install != null) {
            log.info("server: loading settings from ", (Object)install.getConfigurationFile());
            FileSystemXmlApplicationContext factory = null;
            factory = new FileSystemXmlApplicationContext(install.getConfigurationFile().toURL().toString());
            this.cfg = (MutableServerStartupConfiguration)factory.getBean("configuration");
            this.env = (Properties)factory.getBean("environment");
        } else if (args != null && args.length > 0 && new File(args[0]).exists()) {
            log.info("server: loading settings from ", (Object)args[0]);
            FileSystemXmlApplicationContext factory = null;
            factory = new FileSystemXmlApplicationContext(new File(args[0]).toURL().toString());
            this.cfg = (MutableServerStartupConfiguration)factory.getBean("configuration");
            this.env = (Properties)factory.getBean("environment");
        } else {
            log.info("server: using default settings ...");
            this.env = new Properties();
            this.cfg = new MutableServerStartupConfiguration();
        }
        this.env.setProperty("java.naming.provider.url", "ou=system");
        this.env.setProperty("java.naming.factory.initial", ServerContextFactory.class.getName());
        if (install != null) {
            this.cfg.setWorkingDirectory(install.getPartitionsDirectory());
        }
        this.env.putAll((Map<?, ?>)this.cfg.toJndiEnvironment());
        new InitialDirContext(this.env);
        if (this.cfg.getSynchPeriodMillis() > 0L) {
            this.workerThread = new Thread((Runnable)this.worker, "SynchWorkerThread");
        }
        if (log.isInfoEnabled()) {
            log.info("server: started in {} milliseconds", (Object)(System.currentTimeMillis() - startTime + ""));
        }
    }

    public void synch() throws Exception {
        this.env.putAll((Map<?, ?>)new SyncConfiguration().toJndiEnvironment());
        new InitialDirContext(this.env);
    }

    public void start() {
        if (this.workerThread != null) {
            this.workerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String[] args) throws Exception {
        if (this.workerThread != null) {
            this.worker.stop = true;
            Object object = this.worker.lock;
            synchronized (object) {
                this.worker.lock.notify();
            }
            while (this.startNoWait && this.workerThread.isAlive()) {
                log.info("Waiting for SynchWorkerThread to die.");
                this.workerThread.join(500L);
            }
        }
        this.env.putAll((Map<?, ?>)new ShutdownConfiguration().toJndiEnvironment());
        new InitialDirContext(this.env);
    }

    public void destroy() {
    }

    public static void printBanner() {
        System.out.println(BANNER);
    }

    class SynchWorker
    implements Runnable {
        Object lock = new Object();
        boolean stop = false;

        SynchWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stop) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(Service.this.cfg.getSynchPeriodMillis());
                    }
                    catch (InterruptedException e) {
                        log.warn("SynchWorker failed to wait on lock.", (Throwable)e);
                    }
                }
                try {
                    Service.this.synch();
                }
                catch (Exception e) {
                    log.error("SynchWorker failed to synch directory.", (Throwable)e);
                }
            }
        }
    }
}

