/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.db.conf;

import com.mysql.cj.jdbc.ConnectionImpl;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.ZoneId;
import javax.persistence.EntityManagerFactory;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.Validator;
import org.openthinclient.db.DatabaseConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.PropertySource;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@PropertySource(value={"classpath:/org/openthinclient/db/conf/database-application.properties"})
public class DataSourceConfiguration {
    @Autowired
    private ManagerHome managerHome;

    public static String createH2DatabaseUrl(ManagerHome managerHome) {
        return "jdbc:h2:" + managerHome.getLocation().toPath().resolve("db").resolve("manager").toUri().toString() + ";DB_CLOSE_ON_EXIT=FALSE";
    }

    public static String createApacheDerbyDatabaseUrl(ManagerHome managerHome) {
        return "jdbc:derby:" + managerHome.getLocation().toPath().resolve("db").resolve("manager").toString() + ";create=true";
    }

    public static DataSource createDataSource(DatabaseConfiguration conf, String url) {
        DataSource dataSource = new DataSource();
        dataSource.setDriverClassName(conf.getType().getDriverClassName());
        dataSource.setUrl(url);
        dataSource.setUsername(conf.getUsername());
        if (conf.getPassword() != null) {
            dataSource.setPassword(conf.getPassword());
        }
        if (conf.getType() == DatabaseConfiguration.DatabaseType.MYSQL) {
            String properties = "autoReconnect=true";
            String timezone = conf.getTimezone();
            if (timezone == null || timezone.trim().isEmpty()) {
                timezone = ZoneId.systemDefault().getId();
            }
            if (!timezone.equals("auto")) {
                properties = properties + ";serverTimezone=" + timezone;
            }
            dataSource.setConnectionProperties(properties);
        }
        return dataSource;
    }

    public static void validateDataSource(DataSource source) throws SQLException {
        try (Connection connection = source.getConnection();){
            connection.createStatement().execute("select 1");
        }
    }

    @Bean
    @Primary
    public DataSource dataSource() {
        DatabaseConfiguration conf = (DatabaseConfiguration)this.managerHome.getConfiguration(DatabaseConfiguration.class);
        DatabaseConfiguration.DatabaseType type = conf.getType();
        String url = type == DatabaseConfiguration.DatabaseType.H2 && conf.getUrl() == null ? DataSourceConfiguration.createH2DatabaseUrl(this.managerHome) : (type == DatabaseConfiguration.DatabaseType.APACHE_DERBY ? DataSourceConfiguration.createApacheDerbyDatabaseUrl(this.managerHome) : conf.getUrl());
        DataSource dataSource = DataSourceConfiguration.createDataSource(conf, url);
        if (type == DatabaseConfiguration.DatabaseType.APACHE_DERBY) {
            dataSource.setTestOnBorrow(true);
            dataSource.setValidationQuery("values 1");
            dataSource.setValidationInterval(0L);
            String derbyLogPath = Paths.get(this.managerHome.getLocation().getPath(), "logs/derby.log").toAbsolutePath().toString();
            System.setProperty("derby.stream.error.file", derbyLogPath);
        } else if (type == DatabaseConfiguration.DatabaseType.MYSQL) {
            dataSource.setTestOnBorrow(true);
            dataSource.setValidator((Validator)new MySQLConnectionValidator());
        }
        if (type != DatabaseConfiguration.DatabaseType.APACHE_DERBY) {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                System.setProperty("derby.stream.error.file", "NUL");
            } else {
                System.setProperty("derby.stream.error.file", "/dev/null");
            }
        }
        return dataSource;
    }

    @Bean
    public EntityManagerFactory entityManagerFactory() {
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
        factory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        factory.setPackagesToScan(new String[]{"org.openthinclient.pkgmgr.db", "org.openthinclient.service.common.license"});
        factory.setDataSource((javax.sql.DataSource)this.dataSource());
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        JpaTransactionManager txManager = new JpaTransactionManager();
        txManager.setEntityManagerFactory(this.entityManagerFactory());
        return txManager;
    }

    public static class MySQLConnectionValidator
    implements Validator {
        private static final Logger LOGGER = LoggerFactory.getLogger(MySQLConnectionValidator.class);

        public boolean validate(Connection connection, int validateAction) {
            if (connection instanceof ConnectionImpl) {
                try {
                    LOGGER.info("Validating MySQL connection using ping...");
                    ((ConnectionImpl)connection).ping();
                    return true;
                }
                catch (SQLException e) {
                    LOGGER.info("MySQL Connection broken. Cause: " + e.getCause());
                    LOGGER.debug("MySQL Connection broken.", (Throwable)e);
                    return false;
                }
            }
            LOGGER.info("Validating MySQL connection using query...");
            try {
                connection.createStatement().executeQuery("SELECT 1");
                return true;
            }
            catch (SQLException e) {
                LOGGER.info("MySQL Connection broken. Cause: " + e.getCause());
                LOGGER.debug("MySQL Connection broken.", (Throwable)e);
                return false;
            }
        }
    }
}

