/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.config;

import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.vaadin.spring.security.VaadinSecurity;
import org.vaadin.spring.security.navigation.PreAuthorizeViewInstanceAccessControl;
import org.vaadin.spring.security.navigation.SecuredViewAccessControl;
import org.vaadin.spring.security.support.VaadinSecurityAwareProcessor;

public abstract class AbstractVaadinSecurityConfiguration {
    public static final String CURRENT_USER_BEAN = "currentUser";
    public static final String VAADIN_SECURITY_BEAN = "vaadinSecurity";
    public static final String VAADIN_SECURITY_AWARE_PROCESSOR_BEAN = "vaadinSecurityProcessor";
    public static final String AUTHENTICATION_MANAGER_BEAN = "authenticationManager";
    public static final String ACCESS_DECISION_MANAGER_BEAN = "accessDecisionManager";

    @Bean(name={"currentUser"})
    Authentication currentUser() {
        return (Authentication)ProxyFactory.getProxy(Authentication.class, (Interceptor)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                SecurityContext securityContext = SecurityContextHolder.getContext();
                Authentication authentication = securityContext.getAuthentication();
                if (authentication == null) {
                    throw new AuthenticationCredentialsNotFoundException("No authentication found in current security context");
                }
                return invocation.getMethod().invoke((Object)authentication, invocation.getArguments());
            }
        });
    }

    @Bean(name={"vaadinSecurity"})
    abstract VaadinSecurity vaadinSecurity();

    @Bean(name={"vaadinSecurityProcessor"})
    VaadinSecurityAwareProcessor vaadinSecurityProcessor() {
        return new VaadinSecurityAwareProcessor();
    }

    @Bean
    SecuredViewAccessControl securedViewAccessControl() {
        return new SecuredViewAccessControl();
    }

    @Bean
    PreAuthorizeViewInstanceAccessControl preAuthorizeViewInstanceAccessControl() {
        return new PreAuthorizeViewInstanceAccessControl();
    }
}

