/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.http.HttpService;
import org.vaadin.spring.security.config.AbstractVaadinSecurityConfiguration;
import org.vaadin.spring.security.shared.DefaultVaadinSharedSecurity;
import org.vaadin.spring.security.shared.SavedRequestAwareVaadinAuthenticationSuccessHandler;
import org.vaadin.spring.security.shared.VaadinAuthenticationSuccessHandler;
import org.vaadin.spring.security.shared.VaadinLogoutHandler;
import org.vaadin.spring.security.shared.VaadinRedirectLogoutHandler;
import org.vaadin.spring.security.shared.VaadinSharedSecurity;
import org.vaadin.spring.security.web.DefaultVaadinRedirectStrategy;
import org.vaadin.spring.security.web.VaadinRedirectStrategy;
import org.vaadin.spring.servlet.CustomInitParameterProvider;
import org.vaadin.spring.servlet.SingletonCustomInitParameterProvider;

@Configuration
public class VaadinSharedSecurityConfiguration
extends AbstractVaadinSecurityConfiguration {
    public static final String VAADIN_REDIRECT_STRATEGY_BEAN = "vaadinRedirectStrategy";
    public static final String VAADIN_LOGOUT_HANDLER_BEAN = "vaadinLogoutHandler";
    public static final String VAADIN_AUTHENTICATION_SUCCESS_HANDLER_BEAN = "vaadinAuthenticationSuccessHandler";

    @Override
    VaadinSharedSecurity vaadinSecurity() {
        return new DefaultVaadinSharedSecurity();
    }

    @Bean(name={"vaadinRedirectStrategy"})
    VaadinRedirectStrategy vaadinRedirectStrategy() {
        return new DefaultVaadinRedirectStrategy();
    }

    @Bean(name={"vaadinLogoutHandler"})
    VaadinLogoutHandler vaadinLogoutHandler(VaadinRedirectStrategy vaadinRedirectStrategy) {
        return new VaadinRedirectLogoutHandler(vaadinRedirectStrategy);
    }

    @Bean(name={"vaadinAuthenticationSuccessHandler"})
    VaadinAuthenticationSuccessHandler vaadinAuthenticationSuccessHandler(HttpService httpService, VaadinRedirectStrategy vaadinRedirectStrategy) {
        return new SavedRequestAwareVaadinAuthenticationSuccessHandler(httpService, vaadinRedirectStrategy, "/");
    }

    @Bean
    CustomInitParameterProvider pushSecurityInterceptorInitParameterProvider() {
        return new SingletonCustomInitParameterProvider("org.atmosphere.cpr.AtmosphereInterceptor", "org.vaadin.spring.security.shared.PushSecurityInterceptor");
    }
}

