/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.support;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.Aware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.vaadin.spring.security.VaadinSecurity;
import org.vaadin.spring.security.VaadinSecurityAware;
import org.vaadin.spring.security.VaadinSecurityContext;
import org.vaadin.spring.security.VaadinSecurityContextAware;

public class VaadinSecurityAwareProcessor
implements ApplicationContextAware,
BeanPostProcessor {
    private ConfigurableApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        AccessControlContext acc = null;
        if (System.getSecurityManager() != null && bean instanceof VaadinSecurityAware) {
            acc = this.applicationContext.getBeanFactory().getAccessControlContext();
        }
        if (acc != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    VaadinSecurityAwareProcessor.this.invokeAwareInterfaces(bean);
                    return null;
                }
            }, acc);
        } else {
            this.invokeAwareInterfaces(bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void invokeAwareInterfaces(Object bean) {
        if (bean instanceof Aware) {
            if (bean instanceof VaadinSecurityAware) {
                ((VaadinSecurityAware)bean).setVaadinSecurity((VaadinSecurity)this.applicationContext.getBean(VaadinSecurity.class));
            }
            if (bean instanceof VaadinSecurityContextAware) {
                ((VaadinSecurityContextAware)bean).setVaadinSecurityContext((VaadinSecurityContext)this.applicationContext.getBean(VaadinSecurityContext.class));
            }
        }
    }
}

