/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar;

import com.vaadin.server.Resource;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.sidebar.SideBarItemIconProvider;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.SideBarItemIcon;

public abstract class SideBarItemDescriptor
implements Comparable<SideBarItemDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SideBarItemDescriptor.class);
    public static final String ITEM_ID_PREFIX = "sidebaritem_";
    private final SideBarItem item;
    private final I18N i18n;
    private final ApplicationContext applicationContext;
    private final String beanName;
    private final Annotation iconAnnotation;
    private final SideBarItemIconProvider<Annotation> iconProvider;

    protected SideBarItemDescriptor(String beanName, ApplicationContext applicationContext) {
        this.item = (SideBarItem)applicationContext.findAnnotationOnBean(beanName, SideBarItem.class);
        LOGGER.debug("Item annotation of bean [{}] is [{}]", (Object)beanName, (Object)this.item);
        this.i18n = (I18N)applicationContext.getBean(I18N.class);
        this.applicationContext = applicationContext;
        this.beanName = beanName;
        this.iconAnnotation = this.findIconAnnotation();
        LOGGER.debug("Icon annotation of bean [{}] is [{}]", (Object)beanName, (Object)this.iconAnnotation);
        this.iconProvider = this.findIconProvider();
        LOGGER.debug("Icon provider of bean [{}] is [{}]", (Object)beanName, this.iconProvider);
    }

    public <A extends Annotation> A findAnnotationOnBean(Class<A> annotationType) {
        return (A)this.applicationContext.findAnnotationOnBean(this.beanName, annotationType);
    }

    private Annotation findIconAnnotation() {
        for (Class type = this.applicationContext.getType(this.beanName); type != null; type = type.getSuperclass()) {
            Annotation[] annotations;
            LOGGER.trace("Checking class [{}] for icon annotations", (Object)type.getName());
            for (Annotation annotation : annotations = type.getDeclaredAnnotations()) {
                LOGGER.trace("Checking annotation [{}] for icon annotations", (Object)annotation);
                if (!annotation.annotationType().isAnnotationPresent(SideBarItemIcon.class)) continue;
                LOGGER.trace("Found icon annotation on [{}]", (Object)annotation);
                return annotation;
            }
        }
        LOGGER.trace("Found no icon annotation");
        return null;
    }

    private SideBarItemIconProvider<Annotation> findIconProvider() {
        if (this.iconAnnotation != null) {
            Class<? extends SideBarItemIconProvider> iconProviderClass = this.iconAnnotation.annotationType().getAnnotation(SideBarItemIcon.class).value();
            return (SideBarItemIconProvider)this.applicationContext.getBean(iconProviderClass);
        }
        return null;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected String getBeanName() {
        return this.beanName;
    }

    public String getCaption() {
        if (this.item.captionCode().isEmpty()) {
            return this.item.caption();
        }
        return this.i18n.get(this.item.captionCode(), new Object[0]);
    }

    public Resource getIcon() {
        if (this.iconProvider != null) {
            return this.iconProvider.getIcon(this.iconAnnotation);
        }
        return null;
    }

    public String getItemId() {
        return ITEM_ID_PREFIX + this.beanName.toLowerCase();
    }

    public int getOrder() {
        return this.item.order();
    }

    public boolean isMemberOfSection(SideBarSectionDescriptor section) {
        return this.item.sectionId().equals(section.getId());
    }

    @Override
    public int compareTo(SideBarItemDescriptor o) {
        return this.getOrder() - o.getOrder();
    }

    public abstract void itemInvoked(UI var1);

    public static class ViewItemDescriptor
    extends SideBarItemDescriptor {
        private final SpringView vaadinView;

        public ViewItemDescriptor(String beanName, ApplicationContext applicationContext) {
            super(beanName, applicationContext);
            this.vaadinView = (SpringView)applicationContext.findAnnotationOnBean(beanName, SpringView.class);
        }

        public String getViewName() {
            return this.vaadinView.name();
        }

        @Override
        public void itemInvoked(UI ui) {
            ui.getNavigator().navigateTo(this.vaadinView.name());
        }
    }

    public static class ActionItemDescriptor
    extends SideBarItemDescriptor {
        public ActionItemDescriptor(String beanName, ApplicationContext applicationContext) {
            super(beanName, applicationContext);
        }

        @Override
        public void itemInvoked(UI ui) {
            Runnable operation = (Runnable)this.getApplicationContext().getBean(this.getBeanName(), Runnable.class);
            operation.run();
        }
    }
}

