/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.layouts;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.util.Collection;
import java.util.Iterator;
import org.vaadin.viritin.fluency.ui.FluentHorizontalLayout;

public class MHorizontalLayout
extends HorizontalLayout
implements FluentHorizontalLayout<MHorizontalLayout> {
    private static final long serialVersionUID = 524957578263653250L;

    public MHorizontalLayout() {
    }

    public MHorizontalLayout(Component ... components) {
        this();
        this.addComponents(components);
    }

    public MHorizontalLayout with(Component ... components) {
        this.addComponents(components);
        return this;
    }

    public MHorizontalLayout alignAll(Alignment alignment) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            this.setComponentAlignment(component, alignment);
        }
        return this;
    }

    public MHorizontalLayout expand(Component ... componentsToExpand) {
        if (this.getWidth() < 0.0f) {
            this.withFullWidth();
        }
        for (Component component : componentsToExpand) {
            if (component.getParent() != this) {
                this.addComponent(component);
            }
            this.setExpandRatio(component, 1.0f);
            component.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        }
        return this;
    }

    public MHorizontalLayout add(Component ... component) {
        return this.with(component);
    }

    public MHorizontalLayout add(Collection<Component> component) {
        return this.with(component.toArray(new Component[component.size()]));
    }

    public MHorizontalLayout add(Component component, Alignment alignment) {
        return this.add(component).withAlign(component, alignment);
    }

    public MHorizontalLayout add(Component component, float ratio) {
        return this.add(component).withExpand(component, ratio);
    }

    public MHorizontalLayout add(Component component, Alignment alignment, float ratio) {
        return this.add(component).withAlign(component, alignment).withExpand(component, ratio);
    }

    public MHorizontalLayout withAlign(Component component, Alignment alignment) {
        this.setComponentAlignment(component, alignment);
        return this;
    }

    public MHorizontalLayout withExpand(Component component, float ratio) {
        this.setExpandRatio(component, ratio);
        return this;
    }

    public MHorizontalLayout space() {
        return this.expand(new Component[]{new Label()});
    }

    public MHorizontalLayout withSizeUndefined() {
        this.setSizeUndefined();
        return this;
    }

    public MHorizontalLayout withWidthUndefined() {
        this.setWidthUndefined();
        return this;
    }

    public MHorizontalLayout withHeightUndefined() {
        this.setHeightUndefined();
        return this;
    }
}

