/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7;

import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.Item;
import com.vaadin.v7.data.util.filter.UnsupportedFilterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.DynaClass;
import org.vaadin.viritin.v7.ListContainer;

public class FilterableListContainer<T>
extends ListContainer<T>
implements Container.Filterable {
    private static final long serialVersionUID = 6410519255465731727L;
    private final Set<Container.Filter> filters = new HashSet<Container.Filter>();
    private List<T> filteredItems = new ArrayList<T>();

    public FilterableListContainer(Class<? extends T> type) {
        super(type);
    }

    public FilterableListContainer(DynaClass type, String ... properties) {
        super(type, properties);
    }

    public FilterableListContainer(DynaClass type) {
        super(type);
    }

    public FilterableListContainer(Collection<? extends T> backingList) {
        super(backingList);
    }

    private void addFilter(Container.Filter filter) {
        this.filters.add(filter);
        this.filterContainer();
    }

    private Set<Container.Filter> getFilters() {
        return this.filters;
    }

    private void removeAllFilters() {
        if (this.filters.isEmpty()) {
            return;
        }
        this.filters.clear();
        this.filterContainer();
    }

    private void removeFilter(Container.Filter filter) {
        this.filters.remove(filter);
        this.filterContainer();
    }

    private void filterContainer() {
        this.applyFilters();
        super.fireItemSetChange();
    }

    private void applyFilters() {
        this.filteredItems = new ArrayList<T>();
        if (this.isFiltered()) {
            for (Object itemId : super.getBackingList()) {
                if (!this.passesFilters(itemId)) continue;
                this.filteredItems.add(itemId);
            }
        }
    }

    private boolean passesFilters(T itemId) {
        if (this.isFiltered()) {
            Item item = super.getItem(itemId);
            for (Container.Filter f : this.getFilters()) {
                if (f.passesFilter(itemId, item)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFiltered() {
        return this.filters == null ? false : this.filters.size() > 0;
    }

    private boolean contains(T itemId) {
        return this.getBackingList().contains(itemId);
    }

    @Override
    public void fireItemSetChange() {
        this.applyFilters();
        super.fireItemSetChange();
    }

    @Override
    protected List<T> getBackingList() {
        return this.isFiltered() ? this.filteredItems : super.getBackingList();
    }

    public List<T> getUnfilteredItemIds() {
        return super.getBackingList();
    }

    @Override
    public T getIdByIndex(int index) {
        return this.getBackingList().get(index);
    }

    @Override
    public Item getItem(Object itemId) {
        if (itemId == null) {
            return null;
        }
        if (this.isFiltered() && !this.filteredItems.contains(itemId)) {
            return null;
        }
        return super.getItem(itemId);
    }

    @Override
    public Collection<T> getItemIds() {
        return this.getBackingList();
    }

    @Override
    public List<T> getItemIds(int startIndex, int numberOfItems) {
        return this.getBackingList().subList(startIndex, startIndex + numberOfItems);
    }

    @Override
    public int indexOfId(Object itemId) {
        return this.getBackingList().indexOf(itemId);
    }

    @Override
    public int size() {
        return this.getBackingList().size();
    }

    @Override
    public boolean containsId(Object itemId) {
        return this.contains(itemId);
    }

    public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        this.addFilter(filter);
    }

    public void removeContainerFilter(Container.Filter filter) {
        this.removeFilter(filter);
    }

    public void removeAllContainerFilters() {
        this.removeAllFilters();
    }

    public Collection<Container.Filter> getContainerFilters() {
        return this.getFilters();
    }

    @Override
    public void sort(Object[] propertyId, boolean[] ascending) {
        super.sort(propertyId, ascending);
        if (this.isFiltered()) {
            this.filterContainer();
        }
    }
}

