/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7;

import com.vaadin.server.AbstractErrorMessage;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.fieldgroup.BeanFieldGroup;
import com.vaadin.v7.data.fieldgroup.FieldGroup;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.Field;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import org.vaadin.viritin.v7.fields.EagerValidateable;

public class MBeanFieldGroup<T>
extends BeanFieldGroup<T>
implements Property.ValueChangeListener,
FieldEvents.TextChangeListener {
    private static final long serialVersionUID = 9027084784300479429L;
    protected final Class<T> nonHiddenBeanType;
    private boolean validateOnlyBoundFields = true;
    private Set<ConstraintViolation<T>> jsr303beanLevelViolations;
    private Set<Validator.InvalidValueException> beanLevelViolations;
    private final Set<String> fieldsWithInitiallyDisabledValidation = new HashSet<String>();
    private static ValidatorFactory factory;
    private transient Validator javaxBeanValidator;
    private Class<?>[] validationGroups;
    private final LinkedHashMap<MValidator<T>, Collection<AbstractComponent>> mValidators = new LinkedHashMap();
    private final Map<ErrorMessage, AbstractComponent> mValidationErrors = new HashMap<ErrorMessage, AbstractComponent>();
    private final Map<Class<?>, AbstractComponent> validatorToErrorTarget = new HashMap();
    private boolean validateAllProperties = true;
    private boolean beanModified = false;
    private FieldGroupListener<T> listener;
    private static final String NO_BUFFERING_SUPPORT = "Buffering is not supported by Viritin. Please, see https://github.com/viritin/viritin/issues/186 for details.";

    public void configureMaddonDefaults() {
        for (Object property : this.getBoundPropertyIds()) {
            Field field = this.getField(property);
            try {
                try {
                    java.lang.reflect.Field declaredField = this.findDeclaredField(property, this.nonHiddenBeanType);
                    NotNull notNullAnnotation = declaredField.getAnnotation(NotNull.class);
                    if (notNullAnnotation == null || field.isReadOnly()) continue;
                    field.setRequired(true);
                    Locale locale = this.getLocale();
                    if (locale == null) {
                        locale = Locale.getDefault();
                    }
                    String msg = MBeanFieldGroup.getJavaxBeanValidatorFactory().getMessageInterpolator().interpolate(notNullAnnotation.message(), new MessageInterpolator.Context(){

                        public ConstraintDescriptor<?> getConstraintDescriptor() {
                            return null;
                        }

                        public Object getValidatedValue() {
                            return null;
                        }

                        public <T> T unwrap(Class<T> type) {
                            return null;
                        }
                    }, locale);
                    this.getField(property).setRequiredError(msg);
                }
                catch (NoSuchFieldException ex) {
                    Logger.getLogger(MBeanFieldGroup.class.getName()).log(Level.FINE, null, ex);
                }
                catch (SecurityException ex) {
                    Logger.getLogger(MBeanFieldGroup.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ClassNotFoundException)) continue;
                Logger.getLogger(MBeanFieldGroup.class.getName()).log(Level.FINE, "Validation API not available.");
            }
        }
    }

    protected java.lang.reflect.Field findDeclaredField(Object property, Class<?> clazz) throws NoSuchFieldException, SecurityException {
        try {
            java.lang.reflect.Field declaredField = clazz.getDeclaredField(property.toString());
            return declaredField;
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() == null) {
                throw e;
            }
            return this.findDeclaredField(property, clazz.getSuperclass());
        }
    }

    public Set<String> getFieldsWithInitiallyDisabledValidation() {
        return Collections.unmodifiableSet(this.fieldsWithInitiallyDisabledValidation);
    }

    public void hideInitialEmpyFieldValidationErrors() {
        this.fieldsWithInitiallyDisabledValidation.clear();
        for (Field f : this.getFields()) {
            AbstractField abstractField;
            if (!(f instanceof AbstractField) || (abstractField = (AbstractField)f).getErrorMessage() == null || !abstractField.isRequired() || !abstractField.isEmpty() || !abstractField.isValidationVisible()) continue;
            String propertyId = this.getPropertyId((Field)abstractField).toString();
            abstractField.setValidationVisible(false);
            this.fieldsWithInitiallyDisabledValidation.add(propertyId);
        }
    }

    public Set<ConstraintViolation<T>> getConstraintViolations() {
        return this.jsr303beanLevelViolations;
    }

    public Set<Validator.InvalidValueException> getBasicConstraintViolations() {
        return this.beanLevelViolations;
    }

    public Collection<String> getBeanLevelValidationErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.getConstraintViolations() != null) {
            for (final ConstraintViolation<T> constraintViolation : this.getConstraintViolations()) {
                MessageInterpolator.Context context = new MessageInterpolator.Context(){

                    public ConstraintDescriptor<?> getConstraintDescriptor() {
                        return constraintViolation.getConstraintDescriptor();
                    }

                    public Object getValidatedValue() {
                        return constraintViolation.getInvalidValue();
                    }

                    public <T> T unwrap(Class<T> type) {
                        throw new ValidationException();
                    }
                };
                String msg = MBeanFieldGroup.getJavaxBeanValidatorFactory().getMessageInterpolator().interpolate(constraintViolation.getMessageTemplate(), context, this.getLocale());
                errors.add(msg);
            }
        }
        if (this.getBasicConstraintViolations() != null) {
            for (Validator.InvalidValueException cv : this.getBasicConstraintViolations()) {
                errors.add(cv.getMessage());
            }
        }
        return errors;
    }

    public Class<?>[] getValidationGroups() {
        if (this.validationGroups == null) {
            return new Class[]{Default.class};
        }
        return this.validationGroups;
    }

    public void setValidationGroups(Class<?> ... validationGroups) {
        this.validationGroups = validationGroups;
    }

    protected static ValidatorFactory getJavaxBeanValidatorFactory() {
        if (factory == null) {
            factory = Validation.buildDefaultValidatorFactory();
        }
        return factory;
    }

    protected boolean jsr303ValidateBean(T bean) {
        try {
            if (this.javaxBeanValidator == null) {
                this.javaxBeanValidator = MBeanFieldGroup.getJavaxBeanValidatorFactory().getValidator();
            }
        }
        catch (Throwable t) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).fine("JSR303 validation failed");
            return true;
        }
        boolean containsAtLeastOneBoundComponentWithError = false;
        HashSet<ConstraintViolation<T>> constraintViolations = new HashSet<ConstraintViolation<T>>(this.javaxBeanValidator.validate(bean, (Class[])this.getValidationGroups()));
        if (constraintViolations.isEmpty()) {
            return true;
        }
        Iterator iterator = constraintViolations.iterator();
        while (iterator.hasNext()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)iterator.next();
            Class<? extends Annotation> annotationType = constraintViolation.getConstraintDescriptor().getAnnotation().annotationType();
            AbstractComponent errortarget = this.validatorToErrorTarget.get(annotationType);
            if (errortarget == null) continue;
            errortarget.setComponentError((ErrorMessage)new UserError(constraintViolation.getMessage()));
            iterator.remove();
            containsAtLeastOneBoundComponentWithError = true;
        }
        this.jsr303beanLevelViolations = constraintViolations;
        return !containsAtLeastOneBoundComponentWithError && this.isValidateOnlyBoundFields();
    }

    private Locale getLocale() {
        Field firstField = (Field)this.getFields().iterator().next();
        return firstField.getLocale();
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Property property;
        if (event != null && (property = event.getProperty()) instanceof Field) {
            Field abstractField = (Field)property;
            Object propertyId = this.getPropertyId(abstractField);
            if (propertyId != null) {
                boolean wasHiddenValidation = this.fieldsWithInitiallyDisabledValidation.remove(propertyId.toString());
                if (wasHiddenValidation && abstractField instanceof AbstractField) {
                    AbstractField abstractField1 = (AbstractField)abstractField;
                    abstractField1.setValidationVisible(true);
                }
            } else {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Property id for field was not found.");
            }
        }
        this.setBeanModified(true);
        if (this.listener != null) {
            this.listener.onFieldGroupChange(this);
        }
    }

    public MBeanFieldGroup<T> addValidator(MValidator<T> validator, AbstractComponent ... fields) {
        this.mValidators.put(validator, Arrays.asList(fields));
        return this;
    }

    public MBeanFieldGroup<T> removeValidator(MValidator<T> validator) {
        this.mValidators.remove(validator);
        return this;
    }

    public MBeanFieldGroup<T> clearValidators() {
        this.mValidators.clear();
        return this;
    }

    public MBeanFieldGroup<T> setValidationErrorTarget(Class validatorType, AbstractComponent component) {
        this.validatorToErrorTarget.put(validatorType, component);
        return this;
    }

    private void clearMValidationErrors() {
        for (AbstractComponent value : this.mValidationErrors.values()) {
            if (value == null) continue;
            value.setComponentError(null);
        }
        this.mValidationErrors.clear();
        for (AbstractComponent ac : this.validatorToErrorTarget.values()) {
            ac.setComponentError(null);
        }
    }

    public boolean isValidateOnlyBoundFields() {
        return this.validateOnlyBoundFields;
    }

    public void setValidateOnlyBoundFields(boolean validateOnlyBoundFields) {
        this.validateOnlyBoundFields = validateOnlyBoundFields;
    }

    public boolean isValid() {
        if (this.validateAllProperties) {
            return this.isValidAllProperties();
        }
        return this.isValidLegacy();
    }

    private boolean isValidAllProperties() {
        this.clearMValidationErrors();
        this.jsr303beanLevelViolations = null;
        this.beanLevelViolations = null;
        boolean propertiesValid = true;
        try {
            for (Field field : this.getFields()) {
                field.validate();
            }
        }
        catch (Validator.InvalidValueException e) {
            propertiesValid = false;
        }
        boolean ok = true;
        for (MValidator<Object> mValidator : this.mValidators.keySet()) {
            try {
                mValidator.validate(this.getItemDataSource().getBean());
            }
            catch (Validator.InvalidValueException e) {
                Collection<AbstractComponent> properties = this.mValidators.get(mValidator);
                if (!properties.isEmpty()) {
                    for (AbstractComponent field : properties) {
                        ErrorMessage em = AbstractErrorMessage.getErrorMessageForException((Throwable)e);
                        this.mValidationErrors.put(em, field);
                        field.setComponentError(em);
                    }
                } else {
                    ErrorMessage em = AbstractErrorMessage.getErrorMessageForException((Throwable)e);
                    AbstractComponent target = this.validatorToErrorTarget.get(mValidator.getClass());
                    if (target != null) {
                        target.setComponentError(em);
                    } else {
                        if (this.beanLevelViolations == null) {
                            this.beanLevelViolations = new HashSet<Validator.InvalidValueException>();
                        }
                        this.beanLevelViolations.add(e);
                        this.mValidationErrors.put(em, null);
                    }
                }
                ok = false;
            }
        }
        return this.jsr303ValidateBean(this.getItemDataSource().getBean()) && ok && propertiesValid;
    }

    private boolean isValidLegacy() {
        this.clearMValidationErrors();
        this.jsr303beanLevelViolations = null;
        this.beanLevelViolations = null;
        boolean propertiesValid = super.isValid();
        if (propertiesValid) {
            boolean ok = true;
            for (MValidator<Object> mValidator : this.mValidators.keySet()) {
                try {
                    mValidator.validate(this.getItemDataSource().getBean());
                }
                catch (Validator.InvalidValueException e) {
                    Collection<AbstractComponent> properties = this.mValidators.get(mValidator);
                    if (!properties.isEmpty()) {
                        for (AbstractComponent field : properties) {
                            ErrorMessage em = AbstractErrorMessage.getErrorMessageForException((Throwable)e);
                            this.mValidationErrors.put(em, field);
                            field.setComponentError(em);
                        }
                    } else {
                        ErrorMessage em = AbstractErrorMessage.getErrorMessageForException((Throwable)e);
                        AbstractComponent target = this.validatorToErrorTarget.get(mValidator.getClass());
                        if (target != null) {
                            target.setComponentError(em);
                        } else {
                            if (this.beanLevelViolations == null) {
                                this.beanLevelViolations = new HashSet<Validator.InvalidValueException>();
                            }
                            this.beanLevelViolations.add(e);
                            this.mValidationErrors.put(em, null);
                        }
                    }
                    ok = false;
                }
            }
            return this.jsr303ValidateBean(this.getItemDataSource().getBean()) && ok;
        }
        return false;
    }

    public void setValidateAllProperties(boolean validateAllProperties) {
        this.validateAllProperties = validateAllProperties;
    }

    public void textChange(FieldEvents.TextChangeEvent event) {
        this.valueChange(null);
    }

    public void setBeanModified(boolean beanModified) {
        this.beanModified = beanModified;
    }

    public boolean isBeanModified() {
        return this.beanModified;
    }

    public boolean isModified() {
        return super.isModified();
    }

    public MBeanFieldGroup(Class<T> beanType) {
        super(beanType);
        this.nonHiddenBeanType = beanType;
        this.setBuffered(false);
    }

    public MBeanFieldGroup<T> withEagerValidation() {
        return this.withEagerValidation(new FieldGroupListener<T>(){
            private static final long serialVersionUID = 2706724523369882782L;

            @Override
            public void onFieldGroupChange(MBeanFieldGroup<T> beanFieldGroup) {
            }
        });
    }

    public MBeanFieldGroup<T> withEagerValidation(FieldGroupListener<T> listener) {
        this.listener = listener;
        for (Field field : this.getFields()) {
            field.addValueChangeListener((Property.ValueChangeListener)this);
            if (field instanceof EagerValidateable) {
                EagerValidateable ev = (EagerValidateable)field;
                ev.setEagerValidation(true);
            }
            if (!(field instanceof FieldEvents.TextChangeNotifier)) continue;
            FieldEvents.TextChangeNotifier abstractTextField = (FieldEvents.TextChangeNotifier)field;
            abstractTextField.addTextChangeListener((FieldEvents.TextChangeListener)this);
        }
        return this;
    }

    public void unbind() {
        for (Field field : new ArrayList(this.getFields())) {
            field.removeValueChangeListener((Property.ValueChangeListener)this);
            if (field instanceof FieldEvents.TextChangeNotifier) {
                FieldEvents.TextChangeNotifier abstractTextField = (FieldEvents.TextChangeNotifier)field;
                abstractTextField.removeTextChangeListener((FieldEvents.TextChangeListener)this);
            }
            this.unbind(field);
        }
        this.fieldsWithInitiallyDisabledValidation.clear();
    }

    @Deprecated
    public void commit() throws FieldGroup.CommitException {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Viritin doesn't support buffering, this method might not work as expected.");
        super.commit();
    }

    @Deprecated
    public void discard() {
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Viritin doesn't support buffering, this method might not work as expected.");
        super.discard();
    }

    @Deprecated
    public void setBuffered(boolean buffered) {
        if (buffered) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Viritin doesn't support buffering, this method might not work as expected.");
        }
        super.setBuffered(buffered);
    }

    protected void configureField(Field<?> field) {
        boolean readOnlyStatus = this.isReadOnly() || field.getPropertyDataSource().isReadOnly();
        super.configureField(field);
        field.setReadOnly(readOnlyStatus);
    }

    public static interface MValidator<T>
    extends Serializable {
        public void validate(T var1) throws Validator.InvalidValueException;
    }

    public static interface FieldGroupListener<T>
    extends Serializable {
        public void onFieldGroupChange(MBeanFieldGroup<T> var1);
    }
}

