/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7;

import java.io.Serializable;
import java.util.List;
import org.vaadin.viritin.LazyList;

public class SortableLazyList<T>
extends LazyList<T>
implements Serializable {
    private static final long serialVersionUID = 6271514642253054989L;
    private boolean[] sortAscending = new boolean[]{true};
    private String[] sortProperty;
    private final SortablePagingProvider<T> sortablePageProvider;
    private final MultiSortablePagingProvider<T> multiSortablePageProvider;

    public void sort(boolean ascending, String property) {
        this.sortAscending[0] = ascending;
        this.sortProperty = new String[]{property};
        this.reset();
    }

    public SortableLazyList(SortableEntityProvider<T> dataProvider) {
        this(dataProvider, 45);
    }

    public SortableLazyList(SortableEntityProvider<T> dataProvider, int pageSize) {
        super(dataProvider, pageSize);
        this.sortablePageProvider = dataProvider;
        this.multiSortablePageProvider = null;
    }

    public SortableLazyList(SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(pageProvider, countProvider, 45);
    }

    public SortableLazyList(SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        super(countProvider, pageSize);
        this.sortablePageProvider = pageProvider;
        this.multiSortablePageProvider = null;
    }

    public SortableLazyList(MultiSortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        super(countProvider, pageSize);
        this.sortablePageProvider = null;
        this.multiSortablePageProvider = pageProvider;
    }

    @Override
    protected List<T> findEntities(int i) {
        if (this.multiSortablePageProvider != null) {
            return this.multiSortablePageProvider.findEntities(i, this.getSortAscending(), this.getSortProperty());
        }
        String sortProp = null;
        if (this.sortProperty != null && this.sortProperty.length > 0) {
            sortProp = this.sortProperty[0];
        }
        return this.sortablePageProvider.findEntities(i, this.isSortAscending(), sortProp);
    }

    public boolean isSortAscending() {
        return this.sortAscending[0];
    }

    public boolean[] getSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean[] sortAscending) {
        this.sortAscending = sortAscending;
    }

    public String[] getSortProperty() {
        return this.sortProperty;
    }

    public void setSortProperty(String[] sortProperty) {
        this.sortProperty = sortProperty;
    }

    public static interface SortableEntityProvider<T>
    extends SortablePagingProvider<T>,
    LazyList.CountProvider {
    }

    public static interface MultiSortablePagingProvider<T>
    extends Serializable {
        public List<T> findEntities(int var1, boolean[] var2, String[] var3);
    }

    public static interface SortablePagingProvider<T>
    extends Serializable {
        public List<T> findEntities(int var1, boolean var2, String var3);
    }
}

