/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Component;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.event.FieldEvents;
import com.vaadin.v7.ui.CustomField;
import org.vaadin.viritin.util.HtmlElementPropertySetter;
import org.vaadin.viritin.v7.fields.EagerValidateable;
import org.vaadin.viritin.v7.fields.MTextField;

public abstract class AbstractNumberField<T>
extends CustomField<T>
implements EagerValidateable,
FieldEvents.TextChangeNotifier,
FieldEvents.FocusNotifier,
FieldEvents.BlurNotifier {
    private static final long serialVersionUID = 5925606478174987241L;
    private String htmlFieldType = "number";
    protected MTextField tf = new MTextField(){
        private static final long serialVersionUID = 6823601969399906594L;

        @Override
        public void beforeClientResponse(boolean initial) {
            super.beforeClientResponse(initial);
            AbstractNumberField.this.configureHtmlElement();
        }
    };
    protected HtmlElementPropertySetter s = new HtmlElementPropertySetter((AbstractComponent)this.tf);
    protected Property.ValueChangeListener vcl = new Property.ValueChangeListener(){
        private static final long serialVersionUID = 5034199201545161061L;

        public void valueChange(Property.ValueChangeEvent event) {
            Object value = event.getProperty().getValue();
            if (value != null) {
                AbstractNumberField.this.userInputToValue(String.valueOf(value));
            } else {
                AbstractNumberField.this.setValue(null);
            }
        }
    };
    protected FieldEvents.TextChangeListener tcl;

    protected void configureHtmlElement() {
        this.s.setProperty("type", this.getHtmlFieldType());
        this.s.setJavaScriptEventHandler("keypress", "function(e) {var c = viritin.getChar(e); return c==null || /^[-\\d\\n\\t\\r]+$/.test(c);}");
    }

    protected abstract void userInputToValue(String var1);

    protected Component initContent() {
        this.tf.addValueChangeListener(this.vcl);
        return this.tf;
    }

    protected void setInternalValue(T newValue) {
        super.setInternalValue(newValue);
        if (newValue == null) {
            this.tf.setValue(null);
        } else {
            this.tf.setValue(this.valueToPresentation(newValue));
        }
    }

    protected String valueToPresentation(T newValue) {
        return newValue.toString();
    }

    public String getHtmlFieldType() {
        return this.htmlFieldType;
    }

    public void setHtmlFieldType(String htmlFieldType) {
        this.htmlFieldType = htmlFieldType;
    }

    public void addTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.tf.addTextChangeListener(listener);
    }

    public void removeTextChangeListener(FieldEvents.TextChangeListener listener) {
        this.tf.removeTextChangeListener(listener);
    }

    @Override
    public boolean isEagerValidation() {
        return this.tf.isEagerValidation();
    }

    @Override
    public void setEagerValidation(boolean eagerValidation) {
        this.tf.setEagerValidation(true);
        if (eagerValidation && this.tcl == null) {
            this.tcl = new FieldEvents.TextChangeListener(){
                private static final long serialVersionUID = 2244473923631502546L;

                public void textChange(FieldEvents.TextChangeEvent event) {
                    AbstractNumberField.this.userInputToValue(event.getText());
                }
            };
            this.tf.addTextChangeListener(this.tcl);
        }
        if (!eagerValidation && this.tcl != null) {
            this.tf.removeTextChangeListener(this.tcl);
            this.tcl = null;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tf.setEnabled(enabled);
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.tf.setReadOnly(readOnly);
    }

    public void setWidth(float width, Sizeable.Unit unit) {
        super.setWidth(width, unit);
        if (this.tf != null) {
            if (width != -1.0f) {
                this.tf.setWidth("100%");
            } else {
                this.tf.setWidth(null);
            }
        }
    }

    public void addBlurListener(FieldEvents.BlurListener listener) {
        this.tf.addBlurListener(listener);
    }

    public void removeBlurListener(FieldEvents.BlurListener listener) {
        this.tf.removeBlurListener(listener);
    }

    public void addFocusListener(FieldEvents.FocusListener listener) {
        this.tf.addFocusListener(listener);
    }

    public void removeFocusListener(FieldEvents.FocusListener listener) {
        this.tf.removeFocusListener(listener);
    }

    public AbstractNumberField<T> withBlurListener(FieldEvents.BlurListener listener) {
        this.addBlurListener(listener);
        return this;
    }

    public AbstractNumberField<T> withFocusListener(FieldEvents.FocusListener listener) {
        this.addFocusListener(listener);
        return this;
    }
}

