/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.BeanValidator;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.vaadin.viritin.v7.fields.IntegerField;

public class IntegerSliderField
extends IntegerField {
    private static final long serialVersionUID = -3019209950602573361L;
    private Integer max;
    private Integer min;
    private Integer step;

    public IntegerSliderField() {
        this.setHtmlFieldType("range");
    }

    public void addValidator(Validator validator) {
        super.addValidator(validator);
        if (validator instanceof BeanValidator) {
            BeanValidator beanValidator = (BeanValidator)validator;
            try {
                Min minAnnotation;
                Field propertyNameField = BeanValidator.class.getDeclaredField("propertyName");
                propertyNameField.setAccessible(true);
                String fieldName = propertyNameField.get(beanValidator).toString();
                Field beanClass = BeanValidator.class.getDeclaredField("beanClass");
                beanClass.setAccessible(true);
                Class beantype = (Class)beanClass.get(beanValidator);
                Field field = beantype.getDeclaredField(fieldName);
                field.setAccessible(true);
                Max maxAnnotation = field.getAnnotation(Max.class);
                if (maxAnnotation != null) {
                    this.setMax((int)maxAnnotation.value());
                }
                if ((minAnnotation = field.getAnnotation(Min.class)) != null) {
                    this.setMin((int)minAnnotation.value());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                Logger.getLogger(IntegerSliderField.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public IntegerSliderField withMax(Integer min) {
        this.setMax(min);
        return this;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public IntegerSliderField withMin(Integer min) {
        this.setMin(min);
        return this;
    }

    public Integer getStep() {
        return this.step;
    }

    public void setStep(Integer step) {
        this.step = step;
    }

    public IntegerSliderField withStep(Integer step) {
        this.setStep(step);
        return this;
    }

    @Override
    protected void configureHtmlElement() {
        super.configureHtmlElement();
        if (this.max != null) {
            this.s.setProperty("max", this.max.toString());
        }
        if (this.min != null) {
            this.s.setProperty("min", this.min.toString());
        }
        if (this.step != null) {
            this.s.setProperty("step", this.step.toString());
        }
    }

    @Override
    public IntegerSliderField withCaption(String caption) {
        return (IntegerSliderField)super.withCaption(caption);
    }
}

