/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.Version;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.data.util.filter.UnsupportedFilterException;
import com.vaadin.v7.shared.ui.combobox.FilteringMode;
import com.vaadin.v7.ui.AbstractSelect;
import com.vaadin.v7.ui.ComboBox;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.vaadin.viritin.LazyList;
import org.vaadin.viritin.fields.CaptionGenerator;
import org.vaadin.viritin.util.HtmlElementPropertySetter;
import org.vaadin.viritin.v7.ListContainer;
import org.vaadin.viritin.v7.fields.IconGenerator;
import org.vaadin.viritin.v7.fields.MValueChangeListener;
import org.vaadin.viritin.v7.fields.TypedSelect;

public class LazyComboBox<T>
extends TypedSelect<T> {
    private static final long serialVersionUID = 2332969066755466769L;
    private String currentFilter;
    private FilterablePagingProvider<T> fpp;
    private FilterableCountProvider fcp;
    private String lastRawFilter;
    private boolean useRawFilter = false;
    private LazyList<T> piggybackLazyList;

    public LazyComboBox(Class<T> aClass) {
        this(aClass, new FilterablePagingProvider<T>(){

            @Override
            public List<T> findEntities(int firstRow, String filter) {
                return Collections.emptyList();
            }
        }, new FilterableCountProvider(){

            @Override
            public int size(String filter) {
                return 0;
            }
        });
    }

    public LazyComboBox(Class<T> elementType, FilterablePagingProvider<T> filterablePageProvider, FilterableCountProvider countProvider) {
        this(elementType, filterablePageProvider, countProvider, 45);
    }

    public LazyComboBox(Class<T> elementType, FilterablePagingProvider<T> filterablePageProvider, FilterableCountProvider countProvider, int pageLength) {
        this();
        this.initList(elementType, filterablePageProvider, countProvider, pageLength);
    }

    protected final ComboBox initList(Class<T> elementType, FilterablePagingProvider<T> filterablePageProvider, FilterableCountProvider countProvider1, int pageLength) {
        this.fpp = filterablePageProvider;
        this.fcp = countProvider1;
        this.piggybackLazyList = new LazyList(new LazyList.PagingProvider<T>(){
            private static final long serialVersionUID = 1027614132444478021L;

            @Override
            public List<T> findEntities(int firstRow) {
                return LazyComboBox.this.fpp.findEntities(firstRow, LazyComboBox.this.getCurrentFilter());
            }
        }, new LazyList.CountProvider(){
            private static final long serialVersionUID = -7339189124024626177L;

            @Override
            public int size() {
                return LazyComboBox.this.fcp.size(LazyComboBox.this.getCurrentFilter());
            }
        }, pageLength);
        ComboBox comboBox = new ComboBox(){
            private static final long serialVersionUID = -4543249010409767251L;
            {
                this.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
                this.setItemCaptionPropertyId("FAKE");
            }

            public String getItemCaption(Object itemId) {
                return LazyComboBox.this.getCaption(itemId);
            }

            public Resource getItemIcon(Object itemId) {
                if (LazyComboBox.this.getIconGenerator() != null) {
                    return LazyComboBox.this.getIcon(itemId);
                }
                return super.getItemIcon(itemId);
            }

            protected Container.Filter buildFilter(String filterString, FilteringMode filteringMode) {
                if (this.getValue() != null && this.getItemCaption(this.getValue()).equals(filterString)) {
                    filterString = "";
                }
                if (ObjectUtils.notEqual((Object)LazyComboBox.this.currentFilter, (Object)filterString)) {
                    LazyComboBox.this.currentFilter = filterString;
                    LazyComboBox.this.piggybackLazyList.reset();
                }
                return super.buildFilter(filterString, filteringMode);
            }

            public void changeVariables(Object source, Map<String, Object> variables) {
                String newFilter = (String)variables.get("filter");
                if (newFilter != null) {
                    LazyComboBox.this.lastRawFilter = newFilter;
                }
                super.changeVariables(source, variables);
            }
        };
        this.setBic(new DummyFilterableListContainer<T>(elementType, this.piggybackLazyList));
        comboBox.setContainerDataSource(this.getBic());
        if (Version.getMajorVersion() >= 7 && Version.getMinorVersion() >= 5) {
            comboBox.setScrollToSelectedItem(false);
        }
        LazyComboBox.fixComboBoxVaadinIssue16647(comboBox);
        this.setSelectInstance((AbstractSelect)comboBox);
        return comboBox;
    }

    public void loadFrom(FilterablePagingProvider<T> filterablePagingProvider, FilterableCountProvider filterableCountProvider) {
        this.fpp = filterablePagingProvider;
        this.fcp = filterableCountProvider;
        this.refresh();
    }

    public void loadFrom(FilterablePagingProvider<T> filterablePagingProvider, FilterableCountProvider filterableCountProvider, int pageLength) {
        this.fpp = filterablePagingProvider;
        this.fcp = filterableCountProvider;
        this.piggybackLazyList = new LazyList(new LazyList.PagingProvider<T>(){
            private static final long serialVersionUID = 1027614132444478021L;

            @Override
            public List<T> findEntities(int firstRow) {
                return LazyComboBox.this.fpp.findEntities(firstRow, LazyComboBox.this.getCurrentFilter());
            }
        }, new LazyList.CountProvider(){
            private static final long serialVersionUID = -7339189124024626177L;

            @Override
            public int size() {
                return LazyComboBox.this.fcp.size(LazyComboBox.this.getCurrentFilter());
            }
        }, pageLength);
        this.setBic(new DummyFilterableListContainer<T>(this.getType(), this.piggybackLazyList));
        this.getSelect().setContainerDataSource(this.getBic());
    }

    public static void fixComboBoxVaadinIssue16647(ComboBox comboBox) {
        HtmlElementPropertySetter heps = new HtmlElementPropertySetter((AbstractComponent)comboBox);
        heps.setProperty("./input", "autocorrect", "off");
        heps.setProperty("./input", "autocomplete", "off");
        heps.setProperty("./input", "autocapitalize", "off");
    }

    protected LazyComboBox() {
        super(new Object[0]);
        this.setCaptionGenerator(new CaptionGenerator<T>(){
            private static final long serialVersionUID = 9213991656985157568L;

            @Override
            public String getCaption(T option) {
                return option.toString();
            }
        });
    }

    public void refresh() {
        this.piggybackLazyList.reset();
        this.markAsDirty();
    }

    public String getCurrentFilter() {
        return this.useRawFilter ? this.lastRawFilter : this.currentFilter;
    }

    public String getRawFilter() {
        return this.lastRawFilter;
    }

    public boolean isUseRawFilter() {
        return this.useRawFilter;
    }

    public void setUseRawFilter(boolean useRawFilter) {
        this.useRawFilter = useRawFilter;
    }

    @Override
    public LazyComboBox<T> withWidth(String width) {
        return (LazyComboBox)super.withWidth(width);
    }

    @Override
    public LazyComboBox<T> withWidth(float width, Sizeable.Unit unit) {
        return (LazyComboBox)super.withWidth(width, unit);
    }

    @Override
    public LazyComboBox<T> withReadOnly(boolean readOnly) {
        return (LazyComboBox)super.withReadOnly(readOnly);
    }

    @Override
    public LazyComboBox<T> withFullWidth() {
        return (LazyComboBox)super.withFullWidth();
    }

    @Override
    public LazyComboBox<T> setNullSelectionAllowed(boolean nullAllowed) {
        return (LazyComboBox)super.setNullSelectionAllowed(nullAllowed);
    }

    @Override
    public LazyComboBox<T> setCaptionGenerator(CaptionGenerator<T> captionGenerator) {
        return (LazyComboBox)super.setCaptionGenerator(captionGenerator);
    }

    @Override
    public LazyComboBox<T> setIconGenerator(IconGenerator<T> generator) {
        return (LazyComboBox)super.setIconGenerator(generator);
    }

    @Override
    public LazyComboBox<T> addMValueChangeListener(MValueChangeListener<T> listener) {
        return (LazyComboBox)super.addMValueChangeListener(listener);
    }

    @Override
    public LazyComboBox<T> setFieldType(Class<T> type) {
        return (LazyComboBox)super.setFieldType(type);
    }

    @Override
    public LazyComboBox<T> withCaption(String caption) {
        return (LazyComboBox)super.withCaption(caption);
    }

    private static class DummyFilterableListContainer<T>
    extends ListContainer<T>
    implements Container.Filterable {
        private static final long serialVersionUID = -1165474591390168493L;

        DummyFilterableListContainer(Class<T> type, Collection<T> backingList) {
            super(type, backingList);
        }

        public void addContainerFilter(Container.Filter filter) throws UnsupportedFilterException {
        }

        public void removeContainerFilter(Container.Filter filter) {
        }

        public void removeAllContainerFilters() {
        }

        public Collection<Container.Filter> getContainerFilters() {
            return null;
        }

        @Override
        public boolean containsId(Object itemId) {
            return true;
        }
    }

    public static interface FilterableCountProvider {
        public int size(String var1);
    }

    public static interface FilterablePagingProvider<T> {
        public List<T> findEntities(int var1, String var2);
    }
}

