/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.event.MouseEvents;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Container;
import com.vaadin.v7.event.ItemClickEvent;
import com.vaadin.v7.ui.Field;
import com.vaadin.v7.ui.Table;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.viritin.LazyList;
import org.vaadin.viritin.MSize;
import org.vaadin.viritin.v7.ListContainer;
import org.vaadin.viritin.v7.SortableLazyList;
import org.vaadin.viritin.v7.fields.MValueChangeEvent;
import org.vaadin.viritin.v7.fields.MValueChangeEventImpl;
import org.vaadin.viritin.v7.fields.MValueChangeListener;

public class MTable<T>
extends Table {
    private static final long serialVersionUID = 3330985834015680723L;
    private ListContainer<T> bic;
    private String[] pendingProperties;
    private String[] pendingHeaders;
    private Collection sortableProperties;
    private String sortProperty;
    private boolean sortAscending;
    private ItemClickEvent.ItemClickListener itemClickPiggyback;
    private boolean isSorting = false;

    public MTable() {
    }

    public MTable(Class<? extends T> type) {
        this.bic = this.createContainer(type);
        this.setContainerDataSource((Container)this.bic);
    }

    public MTable(T ... beans) {
        this((Collection<T>)new ArrayList<T>(Arrays.asList(beans)));
    }

    public MTable(DynaClass type) {
        this.bic = this.createContainer(type);
        this.setContainerDataSource((Container)this.bic);
    }

    public MTable(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(new LazyList<T>(pageProvider, countProvider, 45));
    }

    public MTable(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(new LazyList<T>(pageProvider, countProvider, pageSize));
    }

    public MTable(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(new SortableLazyList<T>(pageProvider, countProvider, 45));
    }

    public MTable(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(new SortableLazyList<T>(pageProvider, countProvider, pageSize));
    }

    public MTable(Class<T> rowType, LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(rowType, pageProvider, countProvider, 45);
    }

    public MTable(Class<T> rowType, LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(rowType);
        this.lazyLoadFrom(pageProvider, countProvider, pageSize);
    }

    public MTable(Class<T> rowType, SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this(rowType, pageProvider, countProvider, 45);
    }

    public MTable(Class<T> rowType, SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this(rowType);
        this.lazyLoadFrom(pageProvider, countProvider, pageSize);
    }

    public MTable(Collection<T> beans) {
        this();
        if (beans != null) {
            this.bic = this.createContainer(beans);
            this.setContainerDataSource((Container)this.bic);
        }
    }

    public MTable<T> lazyLoadFrom(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this.setBeans(new LazyList<T>(pageProvider, countProvider, 45));
        return this;
    }

    public MTable<T> lazyLoadFrom(LazyList.PagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this.setBeans(new LazyList<T>(pageProvider, countProvider, pageSize));
        return this;
    }

    public MTable<T> lazyLoadFrom(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider) {
        this.setBeans(new SortableLazyList<T>(pageProvider, countProvider, 45));
        return this;
    }

    public MTable<T> lazyLoadFrom(SortableLazyList.SortablePagingProvider<T> pageProvider, LazyList.CountProvider countProvider, int pageSize) {
        this.setBeans(new SortableLazyList<T>(pageProvider, countProvider, pageSize));
        return this;
    }

    protected ListContainer<T> createContainer(Class<? extends T> type) {
        return new ListContainer<T>(type);
    }

    private ListContainer<T> createContainer(DynaClass type) {
        return new ListContainer(type);
    }

    protected ListContainer<T> createContainer(Collection<T> beans) {
        return new ListContainer<T>(beans);
    }

    protected ListContainer<T> getContainer() {
        return this.bic;
    }

    public MTable<T> withProperties(String ... visibleProperties) {
        if (this.isContainerInitialized()) {
            this.bic.setContainerPropertyIds(visibleProperties);
            this.setVisibleColumns(visibleProperties);
        } else {
            this.pendingProperties = visibleProperties;
            for (String string : visibleProperties) {
                this.addContainerProperty(string, String.class, "");
            }
        }
        for (String visibleProperty : visibleProperties) {
            Object[] parts = StringUtils.splitByCharacterTypeCamelCase((String)visibleProperty);
            parts[0] = StringUtils.capitalize((String)parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                parts[i] = ((String)parts[i]).toLowerCase();
            }
            String saneCaption = StringUtils.join((Object[])parts, (String)" ");
            this.setColumnHeader(visibleProperty, saneCaption);
        }
        return this;
    }

    protected boolean isContainerInitialized() {
        return this.bic != null;
    }

    public MTable<T> withColumnHeaders(String ... columnNamesForVisibleProperties) {
        if (this.isContainerInitialized()) {
            this.setColumnHeaders(columnNamesForVisibleProperties);
        } else {
            this.pendingHeaders = columnNamesForVisibleProperties;
            for (String prop : columnNamesForVisibleProperties) {
                this.addContainerProperty(prop, String.class, "");
            }
        }
        return this;
    }

    public MTable<T> withColumnWidth(String propertyId, int width) {
        this.setColumnWidth(propertyId, width);
        return this;
    }

    public MTable<T> setSortableProperties(Collection sortableProperties) {
        this.sortableProperties = sortableProperties;
        return this;
    }

    public MTable<T> setSortableProperties(String ... sortableProperties) {
        this.sortableProperties = Arrays.asList(sortableProperties);
        return this;
    }

    public Collection getSortableProperties() {
        return this.sortableProperties;
    }

    public Collection<?> getSortableContainerPropertyIds() {
        if (this.getSortableProperties() != null) {
            return Collections.unmodifiableCollection(this.sortableProperties);
        }
        return super.getSortableContainerPropertyIds();
    }

    public void addMValueChangeListener(MValueChangeListener<T> listener) {
        this.addListener(MValueChangeEvent.class, listener, MValueChangeEventImpl.VALUE_CHANGE_METHOD);
        this.setSelectable(true);
        this.setImmediate(true);
    }

    public void removeMValueChangeListener(MValueChangeListener<T> listener) {
        this.removeListener(MValueChangeEvent.class, listener, MValueChangeEventImpl.VALUE_CHANGE_METHOD);
        this.setSelectable(this.hasListeners(MValueChangeEvent.class));
    }

    protected void fireValueChange(boolean repaintIsNotNeeded) {
        super.fireValueChange(repaintIsNotNeeded);
        this.fireEvent((EventObject)((Object)new MValueChangeEventImpl((Field)this)));
    }

    protected void ensureBeanItemContainer(Collection<T> beans) {
        if (!this.isContainerInitialized()) {
            this.bic = this.createContainer(beans);
            if (this.pendingProperties != null) {
                this.bic.setContainerPropertyIds(this.pendingProperties);
                this.setContainerDataSource((Container)this.bic, Arrays.asList(this.pendingProperties));
                this.pendingProperties = null;
            } else {
                this.setContainerDataSource((Container)this.bic);
            }
            if (this.pendingHeaders != null) {
                this.setColumnHeaders(this.pendingHeaders);
                this.pendingHeaders = null;
            }
        }
    }

    public T getValue() {
        return (T)super.getValue();
    }

    @Deprecated
    public void setMultiSelect(boolean multiSelect) {
        super.setMultiSelect(multiSelect);
    }

    public MTable<T> addBeans(T ... beans) {
        this.addBeans((Collection<T>)Arrays.asList(beans));
        return this;
    }

    public MTable<T> addBeans(Collection<T> beans) {
        if (!beans.isEmpty()) {
            if (this.isContainerInitialized()) {
                this.bic.addAll(beans);
            } else {
                this.ensureBeanItemContainer(beans);
            }
        }
        return this;
    }

    public MTable<T> setBeans(T ... beans) {
        this.setBeans((Collection<T>)new ArrayList<T>(Arrays.asList(beans)));
        return this;
    }

    public MTable<T> setRows(T ... beansForRows) {
        return this.setBeans(beansForRows);
    }

    public MTable<T> setBeans(Collection<T> beans) {
        if (this.sortProperty != null && beans instanceof SortableLazyList) {
            SortableLazyList sll = (SortableLazyList)beans;
            sll.setSortProperty(new String[]{this.sortProperty});
            sll.setSortAscending(new boolean[]{this.sortAscending});
        }
        if (!this.isContainerInitialized() && !beans.isEmpty()) {
            this.ensureBeanItemContainer(beans);
        } else if (this.isContainerInitialized()) {
            this.bic.setCollection(beans);
        }
        return this;
    }

    public MTable<T> setRows(Collection<T> beansForRows) {
        return this.setBeans(beansForRows);
    }

    public MTable<T> expandFirstColumn() {
        this.expand(this.getContainerPropertyIds().iterator().next().toString());
        if (this.getWidth() == -1.0f) {
            return this.withFullWidth();
        }
        return this;
    }

    public MTable<T> withFullWidth() {
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        return this;
    }

    public MTable<T> withHeight(String height) {
        this.setHeight(height);
        return this;
    }

    public MTable<T> withFullHeight() {
        return this.withHeight("100%");
    }

    public MTable<T> withWidth(String width) {
        this.setWidth(width);
        return this;
    }

    public MTable<T> withSize(MSize mSize) {
        this.setWidth(mSize.getWidth(), mSize.getWidthUnit());
        this.setHeight(mSize.getHeight(), mSize.getHeightUnit());
        return this;
    }

    public MTable<T> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public MTable<T> withStyleName(String ... styleNames) {
        for (String styleName : styleNames) {
            this.addStyleName(styleName);
        }
        return this;
    }

    public MTable<T> withIcon(Resource icon) {
        this.setIcon(icon);
        return this;
    }

    public MTable<T> withId(String id) {
        this.setId(id);
        return this;
    }

    public MTable<T> expand(String ... propertiesToExpand) {
        for (String property : propertiesToExpand) {
            this.setColumnExpandRatio(property, 1.0f);
        }
        return this;
    }

    public MTable<T> withColumnExpand(String propertyId, float ratio) {
        this.setColumnExpandRatio(propertyId, ratio);
        return this;
    }

    private void ensureTypedItemClickPiggybackListener() {
        if (this.itemClickPiggyback == null) {
            this.itemClickPiggyback = new ItemClickEvent.ItemClickListener(){
                private static final long serialVersionUID = -2318797984292753676L;

                public void itemClick(ItemClickEvent event) {
                    MTable.this.fireEvent(new RowClickEvent(event));
                }
            };
            this.addItemClickListener(this.itemClickPiggyback);
        }
    }

    public MTable<T> withProperties(List<String> a) {
        return this.withProperties(a.toArray(new String[a.size()]));
    }

    public MTable<T> withGeneratedColumn(String columnId, final SimpleColumnGenerator<T> columnGenerator) {
        this.addGeneratedColumn(columnId, new Table.ColumnGenerator(){
            private static final long serialVersionUID = 2855441121974230973L;

            public Object generateCell(Table source, Object itemId, Object columnId) {
                return columnGenerator.generate(itemId);
            }
        });
        return this;
    }

    public MTable addSortListener(SortListener listener) {
        this.addListener(SortEvent.class, listener, SortEvent.method);
        return this;
    }

    public MTable removeSortListener(SortListener listener) {
        this.removeListener(SortEvent.class, listener, SortEvent.method);
        return this;
    }

    public void sort(Object[] propertyId, boolean[] ascending) throws UnsupportedOperationException {
        if (this.isSorting) {
            return;
        }
        boolean refreshingPreviouslyEnabled = this.disableContentRefreshing();
        boolean defaultTableSortingMethod = false;
        try {
            this.isSorting = true;
            this.sortAscending = ascending != null && ascending.length > 0 ? ascending[0] : true;
            this.sortProperty = propertyId != null && propertyId.length > 0 ? propertyId[0].toString() : null;
            SortEvent sortEvent = new SortEvent((Component)this, this.sortAscending, this.sortProperty);
            this.fireEvent((EventObject)((Object)sortEvent));
            if (!sortEvent.isPreventContainerSort()) {
                if (this.bic != null && this.bic.getItemIds() instanceof SortableLazyList) {
                    SortableLazyList sll = (SortableLazyList)this.bic.getItemIds();
                    if (ascending == null || ascending.length == 0) {
                        sll.sort(true, null);
                    } else {
                        sll.sort(ascending[0], propertyId[0].toString());
                    }
                    this.resetPageBuffer();
                } else {
                    super.sort(propertyId, ascending);
                    defaultTableSortingMethod = true;
                }
            }
            if (!defaultTableSortingMethod) {
                this.setSortAscending(this.sortAscending);
                this.setSortContainerPropertyId(this.sortProperty);
            }
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.isSorting = false;
            if (refreshingPreviouslyEnabled) {
                this.enableContentRefreshing(true);
            }
        }
    }

    public void addRowClickListener(RowClickListener<T> listener) {
        this.ensureTypedItemClickPiggybackListener();
        this.addListener(RowClickEvent.class, listener, RowClickEvent.TYPED_ITEM_CLICK_METHOD);
    }

    public void removeRowClickListener(RowClickListener<T> listener) {
        this.removeListener(RowClickEvent.class, listener, RowClickEvent.TYPED_ITEM_CLICK_METHOD);
    }

    @Deprecated
    public void resetLazyList() {
        this.refreshRows();
    }

    public void refreshRows() {
        if (this.bic != null && this.bic.getItemIds() instanceof LazyList) {
            ((LazyList)this.bic.getItemIds()).reset();
        }
        this.resetPageBuffer();
    }

    public MTable<T> setSelected(T entity) {
        this.setValue(entity);
        return this;
    }

    public MTable<T> withValueChangeListener(MValueChangeListener<T> listener) {
        this.addMValueChangeListener(listener);
        return this;
    }

    public MTable<T> withRowClickListener(RowClickListener<T> listener) {
        this.addRowClickListener(listener);
        return this;
    }

    public MTable<T> withSortListener(SortListener listener) {
        this.addSortListener(listener);
        return this;
    }

    public static interface RowClickListener<T>
    extends Serializable {
        public void rowClick(RowClickEvent<T> var1);
    }

    public static class RowClickEvent<T>
    extends MouseEvents.ClickEvent {
        private static final long serialVersionUID = -73902815731458960L;
        public static final Method TYPED_ITEM_CLICK_METHOD;
        private final ItemClickEvent orig;

        public RowClickEvent(ItemClickEvent orig) {
            super(orig.getComponent(), null);
            this.orig = orig;
        }

        public T getEntity() {
            return (T)this.orig.getItemId();
        }

        public T getRow() {
            return this.getEntity();
        }

        public String getColumnId() {
            return this.orig.getPropertyId().toString();
        }

        public MouseEventDetails.MouseButton getButton() {
            return this.orig.getButton();
        }

        public int getClientX() {
            return this.orig.getClientX();
        }

        public int getClientY() {
            return this.orig.getClientY();
        }

        public int getRelativeX() {
            return this.orig.getRelativeX();
        }

        public int getRelativeY() {
            return this.orig.getRelativeY();
        }

        public boolean isAltKey() {
            return this.orig.isAltKey();
        }

        public boolean isCtrlKey() {
            return this.orig.isCtrlKey();
        }

        public boolean isDoubleClick() {
            return this.orig.isDoubleClick();
        }

        public boolean isMetaKey() {
            return this.orig.isMetaKey();
        }

        public boolean isShiftKey() {
            return this.orig.isShiftKey();
        }

        static {
            try {
                TYPED_ITEM_CLICK_METHOD = RowClickListener.class.getDeclaredMethod("rowClick", RowClickEvent.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException();
            }
        }
    }

    public static interface SortListener {
        public void onSort(SortEvent var1);
    }

    public static class SortEvent
    extends Component.Event {
        private static final long serialVersionUID = 267382182533317834L;
        private boolean preventContainerSort = false;
        private final boolean sortAscending;
        private final String sortProperty;
        private static final Method method = ReflectTools.findMethod(SortListener.class, (String)"onSort", (Class[])new Class[]{SortEvent.class});

        public SortEvent(Component source, boolean sortAscending, String property) {
            super(source);
            this.sortAscending = sortAscending;
            this.sortProperty = property;
        }

        public String getSortProperty() {
            return this.sortProperty;
        }

        public boolean isSortAscending() {
            return this.sortAscending;
        }

        public void preventContainerSort() {
            this.preventContainerSort = true;
        }

        public boolean isPreventContainerSort() {
            return this.preventContainerSort;
        }
    }

    public static interface SimpleColumnGenerator<T> {
        public Object generate(T var1);
    }
}

