/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.fields;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.data.Property;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.ui.CustomField;
import com.vaadin.v7.ui.TextField;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.vaadin.viritin.v7.MBeanFieldGroup;
import org.vaadin.viritin.v7.fields.MTextField;

public class MapField<K, V>
extends CustomField<Map> {
    private static final Method ADDED_METHOD = ReflectTools.findMethod(ElementAddedListener.class, (String)"elementAdded", (Class[])new Class[]{ElementAddedEvent.class});
    private static final Method REMOVED_METHOD = ReflectTools.findMethod(ElementRemovedListener.class, (String)"elementRemoved", (Class[])new Class[]{ElementRemovedEvent.class});
    private GridLayout mainLayout = new GridLayout(3, 1);
    private Class<K> keyType;
    private Class<V> valueType;
    private Class<?> editorType;
    protected K newInstance;
    private final MBeanFieldGroup.FieldGroupListener fieldGroupListener = new MBeanFieldGroup.FieldGroupListener(){
        private static final long serialVersionUID = 1741634663680831911L;

        public void onFieldGroupChange(MBeanFieldGroup beanFieldGroup) {
            if (beanFieldGroup.getItemDataSource().getBean() == MapField.this.newInstance) {
                if (!((MapField)MapField.this).getFieldGroupFor(MapField.this.newInstance).valueEditor.isValid()) {
                    return;
                }
                MapField.this.getAndEnsureValue().put(MapField.this.newInstance, null);
                MapField.this.fireEvent(new ElementAddedEvent(MapField.this, MapField.this.newInstance));
                MapField.this.setPersisted(MapField.this.newInstance, true);
                MapField.this.onElementAdded();
            }
            MapField.this.fireValueChange(false);
        }
    };
    private boolean allowNewItems = true;
    private boolean allowRemovingItems = true;
    private boolean allowEditItems = true;
    private final Map<K, EntryEditor> pojoToEditor = new HashMap<K, EntryEditor>();
    private EntryEditor newEntryEditor;

    public MapField() {
    }

    public MapField(Class<K> elementType, Class<?> formType) {
        this.keyType = elementType;
        this.editorType = formType;
    }

    private void ensureInited() {
        if (this.mainLayout.getComponentCount() == 0) {
            this.mainLayout.addComponent((Component)new Label("Key ->"));
            this.mainLayout.addComponent((Component)new Label("Value"));
            this.mainLayout.addComponent((Component)new Label("Delete entry"));
        }
    }

    public Class<? extends Map> getType() {
        return Map.class;
    }

    public MapField<K, V> addElementAddedListener(ElementAddedListener<K> listener) {
        this.addListener(ElementAddedEvent.class, listener, ADDED_METHOD);
        return this;
    }

    public MapField<K, V> removeElementAddedListener(ElementAddedListener listener) {
        this.removeListener(ElementAddedEvent.class, listener, ADDED_METHOD);
        return this;
    }

    public MapField<K, V> addElementRemovedListener(ElementRemovedListener<K> listener) {
        this.addListener(ElementRemovedEvent.class, listener, REMOVED_METHOD);
        return this;
    }

    public MapField<K, V> removeElementRemovedListener(ElementRemovedListener listener) {
        this.removeListener(ElementRemovedEvent.class, listener, REMOVED_METHOD);
        return this;
    }

    public boolean isAllowNewItems() {
        return this.allowNewItems;
    }

    public boolean isAllowRemovingItems() {
        return this.allowRemovingItems;
    }

    public boolean isAllowEditItems() {
        return this.allowEditItems;
    }

    public MapField<K, V> setAllowEditItems(boolean allowEditItems) {
        this.allowEditItems = allowEditItems;
        return this;
    }

    public MapField<K, V> setAllowRemovingItems(boolean allowRemovingItems) {
        this.allowRemovingItems = allowRemovingItems;
        return this;
    }

    public MapField<K, V> withCaption(String caption) {
        this.setCaption(caption);
        return this;
    }

    public void validate() throws Validator.InvalidValueException {
        super.validate();
        Map v = (Map)this.getValue();
        if (v != null) {
            for (Object k : v.keySet()) {
            }
        }
    }

    private Map<K, V> getAndEnsureValue() {
        Map value = (HashMap)this.getValue();
        if (value == null) {
            if (this.getPropertyDataSource() == null) {
                return new HashMap();
            }
            Class fieldType = this.getPropertyDataSource().getType();
            if (fieldType.isInterface()) {
                value = new HashMap();
            } else {
                try {
                    value = (Map)fieldType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new RuntimeException("Could not instantiate the used colleciton type", ex);
                }
            }
            this.getPropertyDataSource().setValue(value);
        }
        return value;
    }

    public MapField<K, V> setAllowNewElements(boolean allowNewItems) {
        this.allowNewItems = allowNewItems;
        return this;
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    protected TextField createKeyEditorInstance() {
        MTextField tf = (MTextField)new MTextField().withInputPrompt("key");
        return tf;
    }

    protected TextField createValueEditorInstance() {
        MTextField tf = (MTextField)new MTextField().withInputPrompt("value");
        return tf;
    }

    private void replaceValue(K key, String value) {
        String tVal;
        K tKey;
        if (key == null) {
            return;
        }
        try {
            tKey = key;
        }
        catch (ClassCastException e) {
            try {
                tKey = this.keyType.getConstructor(String.class).newInstance(key);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("No suitable constructor found", ex);
            }
        }
        try {
            tVal = value;
        }
        catch (ClassCastException e) {
            try {
                tVal = this.valueType.getConstructor(String.class).newInstance(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("No suitable constructor found", ex);
            }
        }
        this.getAndEnsureValue().put(tKey, tVal);
    }

    private void renameValue(K oldKey, String key) {
        EntryEditor e;
        Object value;
        String tKey;
        try {
            tKey = key;
        }
        catch (ClassCastException e2) {
            try {
                tKey = this.keyType.getConstructor(String.class).newInstance(key);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new RuntimeException("No suitable constructor found", ex);
            }
        }
        if (oldKey != null) {
            value = this.getAndEnsureValue().remove(oldKey);
            e = this.pojoToEditor.remove(oldKey);
        } else {
            e = this.newEntryEditor;
            String strValue = (String)this.newEntryEditor.valueEditor.getValue();
            try {
                value = strValue;
            }
            catch (ClassCastException ex) {
                try {
                    value = this.valueType.getConstructor(String.class).newInstance(strValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex1) {
                    value = null;
                }
            }
            e.delete.setEnabled(true);
            this.createNewEntryRow();
        }
        e.oldKey = tKey;
        this.getAndEnsureValue().put(tKey, value);
        this.pojoToEditor.put(tKey, e);
    }

    private EntryEditor getFieldGroupFor(K key) {
        EntryEditor ee = this.pojoToEditor.get(key);
        if (ee == null) {
            TextField k = this.createKeyEditorInstance();
            TextField v = this.createValueEditorInstance();
            EntryEditor ee1 = ee = new EntryEditor(k, v, key);
            this.pojoToEditor.put(key, ee);
        }
        return ee;
    }

    public void addElement(K key, V value) {
        this.getAndEnsureValue().put(key, value);
        this.addInternalElement(key, value);
        this.fireValueChange(false);
        this.fireEvent((EventObject)((Object)new ElementAddedEvent<K>(this, key)));
    }

    public void removeElement(K keyToBeRemoved) {
        this.removeInternalElement(keyToBeRemoved);
        this.getAndEnsureValue().remove(keyToBeRemoved);
        this.fireValueChange(false);
        this.fireEvent((EventObject)((Object)new ElementRemovedEvent<K>(this, keyToBeRemoved)));
    }

    protected Component initContent() {
        return this.getLayout();
    }

    protected void setInternalValue(Map newValue) {
        super.setInternalValue((Object)newValue);
        this.clearCurrentEditors();
        Map value = newValue;
        if (value != null) {
            for (Map.Entry entry : value.entrySet()) {
                Object key = entry.getKey();
                Object value1 = entry.getValue();
                this.addInternalElement(key, value1);
            }
        }
        if (this.isAllowNewItems()) {
            this.createNewEntryRow();
        }
        this.onElementAdded();
    }

    private void createNewEntryRow() throws Property.ReadOnlyException {
        TextField keyEditor = this.createKeyEditorInstance();
        TextField valueEditor = this.createKeyEditorInstance();
        this.newEntryEditor = new EntryEditor(keyEditor, valueEditor, null);
        this.addRowForEntry(this.newEntryEditor, null, null);
    }

    protected void addInternalElement(K k, V v) {
        this.ensureInited();
        EntryEditor fieldGroupFor = this.getFieldGroupFor(k);
        this.addRowForEntry(fieldGroupFor, k, v);
    }

    private void addRowForEntry(EntryEditor editor, K k, V v) throws Property.ReadOnlyException {
        editor.bindValues(k, v);
        this.getLayout().addComponents(new Component[]{editor.keyEditor, editor.valueEditor, editor.delete});
    }

    protected void setPersisted(K v, boolean persisted) {
    }

    protected void removeInternalElement(K v) {
    }

    protected Layout getLayout() {
        return this.mainLayout;
    }

    protected void onElementAdded() {
        System.out.println("What now!?");
    }

    private void clearCurrentEditors() {
        while (this.mainLayout.getRows() > 1) {
            this.mainLayout.removeRow(1);
        }
    }

    private class EntryEditor
    implements Serializable {
        private static final long serialVersionUID = 5710635901082609223L;
        TextField keyEditor;
        TextField valueEditor;
        Button delete;
        K oldKey;

        EntryEditor(TextField ke, TextField valueEditor, K k) {
            this.keyEditor = ke;
            this.valueEditor = valueEditor;
            this.delete = new Button((Resource)FontAwesome.TRASH);
            this.delete.addClickListener(new Button.ClickListener(){

                public void buttonClick(Button.ClickEvent event) {
                    Object removed = ((Map)MapField.this.getValue()).remove(EntryEditor.this.oldKey);
                    MapField.this.pojoToEditor.remove(EntryEditor.this.oldKey);
                    Iterator iterator = MapField.this.mainLayout.iterator();
                    int idx = 0;
                    while (iterator.next() != EntryEditor.this.keyEditor) {
                        ++idx;
                    }
                    MapField.this.mainLayout.removeRow(idx / 3);
                }
            });
            this.oldKey = k;
            if (this.oldKey == null) {
                this.delete.setEnabled(false);
            }
        }

        private void bindValues(K k, V v) {
            this.keyEditor.setValue(k == null ? null : k.toString());
            this.valueEditor.setValue(v == null ? null : v.toString());
            this.keyEditor.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    MapField.this.renameValue(EntryEditor.this.oldKey, (String)EntryEditor.this.keyEditor.getValue());
                }
            });
            this.valueEditor.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    MapField.this.replaceValue(EntryEditor.this.oldKey, (String)EntryEditor.this.valueEditor.getValue());
                }
            });
        }
    }

    public static interface Instantiator<ET>
    extends Serializable {
        public ET create();
    }

    public static interface ElementRemovedListener<K>
    extends Serializable {
        public void elementRemoved(ElementRemovedEvent<K> var1);
    }

    public static interface ElementAddedListener<K>
    extends Serializable {
        public void elementAdded(ElementAddedEvent<K> var1);
    }

    public static class ElementRemovedEvent<K>
    extends Component.Event {
        private final K key;

        public ElementRemovedEvent(MapField source, K element) {
            super((Component)source);
            this.key = element;
        }

        public K getKey() {
            return this.key;
        }
    }

    public static class ElementAddedEvent<K>
    extends Component.Event {
        private final K key;

        public ElementAddedEvent(MapField source, K element) {
            super((Component)source);
            this.key = element;
        }

        public K getKey() {
            return this.key;
        }
    }
}

