/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.form;

import com.vaadin.server.ClientConnector;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.AbstractComponentContainer;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.util.ReflectTools;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.AbstractTextField;
import com.vaadin.v7.ui.Field;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.groups.Default;
import org.vaadin.viritin.button.DeleteButton;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.button.PrimaryButton;
import org.vaadin.viritin.label.RichText;
import org.vaadin.viritin.layouts.MHorizontalLayout;
import org.vaadin.viritin.v7.BeanBinder;
import org.vaadin.viritin.v7.MBeanFieldGroup;

public abstract class AbstractForm<T>
extends CustomComponent
implements MBeanFieldGroup.FieldGroupListener<T> {
    private static final long serialVersionUID = -2368496151988753088L;
    private String modalWindowTitle = "Edit entry";
    private String saveCaption = "Save";
    private String deleteCaption = "Delete";
    private String cancelCaption = "Cancel";
    private Window popup;
    private MBeanFieldGroup<T> fieldGroup;
    boolean isValid = false;
    private RichText beanLevelViolations;
    private T entity;
    private SavedHandler<T> savedHandler;
    private ResetHandler<T> resetHandler;
    private DeleteHandler<T> deleteHandler;
    private boolean eagerValidation = true;
    private String[] nestedProperties;
    private Button resetButton;
    private Button saveButton;
    private Button deleteButton;
    private final LinkedHashMap<MBeanFieldGroup.MValidator<T>, Collection<AbstractComponent>> mValidators = new LinkedHashMap();
    private final Map<Class<?>, AbstractComponent> validatorToErrorTarget = new LinkedHashMap();
    private Class<?>[] validationGroups;

    public AbstractForm() {
        this.addAttachListener(new ClientConnector.AttachListener(){
            private static final long serialVersionUID = 3193438171004932112L;

            public void attach(ClientConnector.AttachEvent event) {
                AbstractForm.this.lazyInit();
                AbstractForm.this.adjustResetButtonState();
            }
        });
    }

    protected void lazyInit() {
        if (this.getCompositionRoot() == null) {
            this.setCompositionRoot(this.createContent());
            this.adjustSaveButtonState();
            this.adjustResetButtonState();
        }
    }

    @Override
    public void onFieldGroupChange(MBeanFieldGroup<T> beanFieldGroup) {
        boolean wasValid = this.isValid;
        this.isValid = this.fieldGroup.isValid();
        this.adjustSaveButtonState();
        this.adjustResetButtonState();
        if (wasValid != this.isValid) {
            this.fireValidityChangedEvent();
        }
        this.updateConstraintViolationsDisplay();
    }

    protected void updateConstraintViolationsDisplay() {
        if (this.beanLevelViolations != null) {
            Collection<String> errorMessages = this.getFieldGroup().getBeanLevelValidationErrors();
            if (!errorMessages.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String e : errorMessages) {
                    sb.append(e);
                    sb.append("<br/>");
                }
                this.beanLevelViolations.setValue(sb.toString());
                this.beanLevelViolations.setVisible(true);
            } else {
                this.beanLevelViolations.setVisible(false);
                this.beanLevelViolations.setValue("");
            }
        }
    }

    public Component getConstraintViolationsDisplay() {
        if (this.beanLevelViolations == null) {
            this.beanLevelViolations = new RichText();
            this.beanLevelViolations.setVisible(false);
            this.beanLevelViolations.setStyleName("failure");
        }
        return this.beanLevelViolations;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void adjustSaveButtonState() {
        if (this.isEagerValidation() && this.isBound()) {
            boolean beanModified = this.fieldGroup.isBeanModified();
            this.getSaveButton().setEnabled(beanModified && this.isValid());
        }
    }

    protected boolean isBound() {
        return this.fieldGroup != null;
    }

    protected void adjustResetButtonState() {
        if (this.popup != null && this.popup.getParent() != null) {
            this.getResetButton().setEnabled(true);
            return;
        }
        if (this.isEagerValidation() && this.isBound()) {
            boolean modified = this.fieldGroup.isBeanModified();
            this.getResetButton().setEnabled(modified || this.popup != null);
        }
    }

    public void addValidityChangedListener(ValidityChangedListener<T> listener) {
        this.addListener(ValidityChangedEvent.class, listener, ValidityChangedEvent.method);
    }

    public void removeValidityChangedListener(ValidityChangedListener<T> listener) {
        this.removeListener(ValidityChangedEvent.class, listener, ValidityChangedEvent.method);
    }

    private void fireValidityChangedEvent() {
        this.fireEvent((EventObject)((Object)new ValidityChangedEvent((Component)this)));
    }

    public boolean isEagerValidation() {
        return this.eagerValidation;
    }

    public void setEagerValidation(boolean eagerValidation) {
        this.eagerValidation = eagerValidation;
    }

    public MBeanFieldGroup<T> setEntity(T entity) {
        this.entity = entity;
        this.lazyInit();
        if (entity != null) {
            if (this.isBound()) {
                this.fieldGroup.unbind();
            }
            this.fieldGroup = this.bindEntity(entity);
            try {
                this.fieldGroup.setValidationGroups(this.getValidationGroups());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (Map.Entry<MBeanFieldGroup.MValidator<T>, Collection<AbstractComponent>> entry : this.mValidators.entrySet()) {
                this.fieldGroup.addValidator(entry.getKey(), entry.getValue().toArray(new AbstractComponent[entry.getValue().size()]));
            }
            for (Map.Entry<Serializable, Collection<Object>> entry : this.validatorToErrorTarget.entrySet()) {
                this.fieldGroup.setValidationErrorTarget((Class)entry.getKey(), (AbstractComponent)entry.getValue());
            }
            this.isValid = this.fieldGroup.isValid();
            if (this.isEagerValidation()) {
                this.fieldGroup.withEagerValidation(this);
                this.adjustSaveButtonState();
                this.adjustResetButtonState();
            }
            this.fieldGroup.hideInitialEmpyFieldValidationErrors();
            this.setVisible(true);
            return this.fieldGroup;
        }
        this.setVisible(false);
        return null;
    }

    protected MBeanFieldGroup<T> bindEntity(T entity) {
        return BeanBinder.bind(entity, this, this.getNestedProperties());
    }

    public String[] getNestedProperties() {
        return this.nestedProperties;
    }

    public void setNestedProperties(String ... nestedProperties) {
        this.nestedProperties = nestedProperties;
    }

    public void setHandler(Object handler) {
        if (handler != null) {
            if (handler instanceof SavedHandler) {
                this.setSavedHandler((SavedHandler)handler);
            }
            if (handler instanceof ResetHandler) {
                this.setResetHandler((ResetHandler)handler);
            }
            if (handler instanceof DeleteHandler) {
                this.setDeleteHandler((DeleteHandler)handler);
            }
        }
    }

    public void setSavedHandler(SavedHandler<T> savedHandler) {
        this.savedHandler = savedHandler;
        this.getSaveButton().setVisible(this.savedHandler != null);
    }

    public void setResetHandler(ResetHandler<T> resetHandler) {
        this.resetHandler = resetHandler;
        this.getResetButton().setVisible(this.resetHandler != null);
    }

    public void setDeleteHandler(DeleteHandler<T> deleteHandler) {
        this.deleteHandler = deleteHandler;
        this.getDeleteButton().setVisible(this.deleteHandler != null);
    }

    public ResetHandler<T> getResetHandler() {
        return this.resetHandler;
    }

    public SavedHandler<T> getSavedHandler() {
        return this.savedHandler;
    }

    public DeleteHandler<T> getDeleteHandler() {
        return this.deleteHandler;
    }

    public Window openInModalPopup() {
        this.popup = new Window(this.getModalWindowTitle(), (Component)this);
        this.popup.setModal(true);
        UI.getCurrent().addWindow(this.popup);
        this.focusFirst();
        return this.popup;
    }

    public Window getPopup() {
        return this.popup;
    }

    public void closePopup() {
        if (this.popup != null) {
            this.popup.close();
            this.popup = null;
        }
    }

    public HorizontalLayout getToolbar() {
        return new MHorizontalLayout(new Component[]{this.getSaveButton(), this.getResetButton(), this.getDeleteButton()});
    }

    protected Button createCancelButton() {
        return (Button)new MButton(this.getCancelCaption()).withVisible(false);
    }

    public Button getResetButton() {
        if (this.resetButton == null) {
            this.setResetButton(this.createCancelButton());
        }
        return this.resetButton;
    }

    public void setResetButton(Button resetButton) {
        this.resetButton = resetButton;
        this.resetButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -19755976436277487L;

            public void buttonClick(Button.ClickEvent event) {
                AbstractForm.this.reset(event);
            }
        });
    }

    protected Button createSaveButton() {
        return (Button)new PrimaryButton(this.getSaveCaption()).withVisible(false);
    }

    public void setSaveButton(Button saveButton) {
        this.saveButton = saveButton;
        saveButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2058398434893034442L;

            public void buttonClick(Button.ClickEvent event) {
                AbstractForm.this.save(event);
            }
        });
    }

    public Button getSaveButton() {
        if (this.saveButton == null) {
            this.setSaveButton(this.createSaveButton());
        }
        return this.saveButton;
    }

    protected Button createDeleteButton() {
        return (Button)new DeleteButton(this.getDeleteCaption()).withVisible(false);
    }

    public void setDeleteButton(Button deleteButton) {
        this.deleteButton = deleteButton;
        deleteButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = -2693734056915561664L;

            public void buttonClick(Button.ClickEvent event) {
                AbstractForm.this.delete(event);
            }
        });
    }

    public Button getDeleteButton() {
        if (this.deleteButton == null) {
            this.setDeleteButton(this.createDeleteButton());
        }
        return this.deleteButton;
    }

    protected void save(Button.ClickEvent e) {
        this.savedHandler.onSave(this.getEntity());
        this.getFieldGroup().setBeanModified(false);
        this.adjustResetButtonState();
        this.adjustSaveButtonState();
    }

    protected void reset(Button.ClickEvent e) {
        this.resetHandler.onReset(this.getEntity());
        this.getFieldGroup().setBeanModified(false);
        this.adjustResetButtonState();
        this.adjustSaveButtonState();
    }

    protected void delete(Button.ClickEvent e) {
        this.deleteHandler.onDelete(this.getEntity());
    }

    public void focusFirst() {
        Component compositionRoot = this.getCompositionRoot();
        this.findFieldAndFocus(compositionRoot);
    }

    private boolean findFieldAndFocus(Component compositionRoot) {
        if (compositionRoot instanceof AbstractComponentContainer) {
            AbstractComponentContainer cc = (AbstractComponentContainer)compositionRoot;
            for (Component component : cc) {
                if (component instanceof AbstractTextField) {
                    AbstractTextField abstractTextField = (AbstractTextField)component;
                    abstractTextField.selectAll();
                    return true;
                }
                if (component instanceof AbstractField) {
                    AbstractField abstractField = (AbstractField)component;
                    abstractField.focus();
                    return true;
                }
                if (!(component instanceof AbstractComponentContainer) || !this.findFieldAndFocus(component)) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract Component createContent();

    public MBeanFieldGroup<T> getFieldGroup() {
        return this.fieldGroup;
    }

    public T getEntity() {
        return this.entity;
    }

    public Class<?>[] getValidationGroups() {
        if (this.validationGroups == null) {
            return new Class[]{Default.class};
        }
        return this.validationGroups;
    }

    public void setValidationGroups(Class<?> ... validationGroups) {
        this.validationGroups = validationGroups;
        if (this.getFieldGroup() != null) {
            this.getFieldGroup().setValidationGroups(validationGroups);
        }
    }

    public void setValidationErrorTarget(Class<?> aClass, AbstractComponent errorTarget) {
        this.validatorToErrorTarget.put(aClass, errorTarget);
        if (this.getFieldGroup() != null) {
            this.getFieldGroup().setValidationErrorTarget(aClass, errorTarget);
        }
    }

    public AbstractForm<T> addValidator(MBeanFieldGroup.MValidator<T> validator, AbstractComponent ... fields) {
        this.mValidators.put(validator, Arrays.asList(fields));
        if (this.getFieldGroup() != null) {
            this.getFieldGroup().addValidator(validator, fields);
        }
        return this;
    }

    public AbstractForm<T> removeValidator(MBeanFieldGroup.MValidator<T> validator) {
        Collection remove = (Collection)this.mValidators.remove(validator);
        if (remove != null && this.getFieldGroup() != null) {
            this.getFieldGroup().removeValidator(validator);
        }
        return this;
    }

    public AbstractForm<T> clearValidators() {
        this.mValidators.clear();
        if (this.getFieldGroup() != null) {
            this.getFieldGroup().clearValidators();
        }
        return this;
    }

    public void setRequired(Field ... fields) {
        for (Field field : fields) {
            field.setRequired(true);
        }
    }

    public String getModalWindowTitle() {
        return this.modalWindowTitle;
    }

    public void setModalWindowTitle(String modalWindowTitle) {
        this.modalWindowTitle = modalWindowTitle;
    }

    public String getCancelCaption() {
        return this.cancelCaption;
    }

    public void setCancelCaption(String cancelCaption) {
        this.cancelCaption = cancelCaption;
    }

    public String getSaveCaption() {
        return this.saveCaption;
    }

    public void setSaveCaption(String saveCaption) {
        this.saveCaption = saveCaption;
    }

    public String getDeleteCaption() {
        return this.deleteCaption;
    }

    public void setDeleteCaption(String deleteCaption) {
        this.deleteCaption = deleteCaption;
    }

    public AbstractForm<T> withI18NCaption(String saveCaption, String deleteCaption, String cancelCaption) {
        this.saveCaption = saveCaption;
        this.deleteCaption = deleteCaption;
        this.cancelCaption = cancelCaption;
        return this;
    }

    public boolean isValidateOnlyBoundFields() {
        return this.fieldGroup.isValidateOnlyBoundFields();
    }

    public void setValidateOnlyBoundFields(boolean validateOnlyBoundFields) {
        this.fieldGroup.setValidateOnlyBoundFields(validateOnlyBoundFields);
    }

    public static interface DeleteHandler<T>
    extends Serializable {
        public void onDelete(T var1);
    }

    public static interface ResetHandler<T>
    extends Serializable {
        public void onReset(T var1);
    }

    public static interface SavedHandler<T>
    extends Serializable {
        public void onSave(T var1);
    }

    public static interface ValidityChangedListener<T>
    extends Serializable {
        public void onValidityChanged(ValidityChangedEvent<T> var1);
    }

    public static class ValidityChangedEvent<T>
    extends Component.Event {
        private static final long serialVersionUID = 7410354508832863756L;
        private static final Method method = ReflectTools.findMethod(ValidityChangedListener.class, (String)"onValidityChanged", (Class[])new Class[]{ValidityChangedEvent.class});

        public ValidityChangedEvent(Component source) {
            super(source);
        }

        public AbstractForm<T> getComponent() {
            return (AbstractForm)super.getComponent();
        }
    }
}

