/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.v7.grid.utils;

import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.v7.data.sort.SortOrder;
import com.vaadin.v7.event.SortEvent;
import com.vaadin.v7.ui.Grid;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.viritin.util.BrowserCookie;

public class GridUtils {
    private static final String COLOMN_DELIMITER = ":";
    private static final String SEMI_COLOMN_DELIMITER = ";";
    private final String HIDDEN_SETTINGS_NAME;
    private final String SORT_ORDER_SETTINGS_NAME;
    private final String COLUMNS_ORDER_SETTINGS_NAME;
    private final Grid grid;

    public static void attachToGrid(Grid grid, String cookieName) {
        GridUtils utils = new GridUtils(grid, cookieName);
    }

    private GridUtils(Grid grid, String cookieName) {
        this.grid = grid;
        this.HIDDEN_SETTINGS_NAME = cookieName + "hiddenCols";
        this.SORT_ORDER_SETTINGS_NAME = cookieName + "sortOrder";
        this.COLUMNS_ORDER_SETTINGS_NAME = cookieName + "columnOrder";
        this.loadSettings();
        grid.addColumnVisibilityChangeListener(new Grid.ColumnVisibilityChangeListener(){

            public void columnVisibilityChanged(Grid.ColumnVisibilityChangeEvent event) {
                GridUtils.this.saveHidden();
            }
        });
        grid.addSortListener(new SortEvent.SortListener(){

            public void sort(SortEvent event) {
                GridUtils.this.saveSortOrder();
            }
        });
        grid.addColumnReorderListener(new Grid.ColumnReorderListener(){

            public void columnReorder(Grid.ColumnReorderEvent event) {
                GridUtils.this.saveColumnOrder();
            }
        });
    }

    private void saveColumnOrder() {
        StringBuilder sb = new StringBuilder();
        for (Grid.Column c : this.grid.getColumns()) {
            sb.append(c.getPropertyId().toString());
            sb.append(COLOMN_DELIMITER);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        BrowserCookie.setCookie(this.COLUMNS_ORDER_SETTINGS_NAME, sb.toString());
    }

    private void loadSettings() {
        this.loadHidden();
        this.loadSortOrder();
        this.loadColumnOrder();
    }

    private void loadColumnOrder() {
        BrowserCookie.Callback saveFunc = new BrowserCookie.Callback(){

            @Override
            public void onValueDetected(String value) {
                if (value != null) {
                    Object[] columnsOrder = value.split(GridUtils.COLOMN_DELIMITER);
                    GridUtils.this.grid.setColumnOrder(columnsOrder);
                }
            }
        };
        BrowserCookie.detectCookieValue(this.COLUMNS_ORDER_SETTINGS_NAME, saveFunc);
    }

    private void loadSortOrder() {
        BrowserCookie.Callback saveFunc = new BrowserCookie.Callback(){

            @Override
            public void onValueDetected(String value) {
                ArrayList<SortOrder> sortOrderList = new ArrayList<SortOrder>();
                if (!StringUtils.isEmpty((CharSequence)value)) {
                    String[] sortOrder;
                    for (String so : sortOrder = value.split(GridUtils.SEMI_COLOMN_DELIMITER)) {
                        String[] colIdWithSort = so.split(GridUtils.COLOMN_DELIMITER);
                        String propertyId = colIdWithSort[0];
                        SortDirection direction = SortDirection.valueOf((String)colIdWithSort[1]);
                        SortOrder soCreated = new SortOrder((Object)propertyId, direction);
                        sortOrderList.add(soCreated);
                    }
                }
                GridUtils.this.grid.setSortOrder(sortOrderList);
            }
        };
        BrowserCookie.detectCookieValue(this.SORT_ORDER_SETTINGS_NAME, saveFunc);
    }

    private void loadHidden() {
        BrowserCookie.Callback saveFunc = new BrowserCookie.Callback(){

            @Override
            public void onValueDetected(String value) {
                if (value != null) {
                    for (String col : value.split(GridUtils.COLOMN_DELIMITER)) {
                        Grid.Column column = GridUtils.this.grid.getColumn((Object)col);
                        if (column == null) continue;
                        column.setHidden(true);
                    }
                }
            }
        };
        BrowserCookie.detectCookieValue(this.HIDDEN_SETTINGS_NAME, saveFunc);
    }

    private void saveSortOrder() {
        List sortOrder = this.grid.getSortOrder();
        StringBuilder sb = new StringBuilder();
        for (SortOrder o : sortOrder) {
            sb.append(o.getPropertyId());
            sb.append(COLOMN_DELIMITER);
            sb.append(o.getDirection());
            sb.append(SEMI_COLOMN_DELIMITER);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        BrowserCookie.setCookie(this.SORT_ORDER_SETTINGS_NAME, sb.toString());
    }

    private void saveHidden() {
        StringBuilder sb = new StringBuilder();
        for (Grid.Column c : this.grid.getColumns()) {
            if (!c.isHidden()) continue;
            sb.append(c.getPropertyId());
            sb.append(COLOMN_DELIMITER);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        BrowserCookie.setCookie(this.HIDDEN_SETTINGS_NAME, sb.toString());
    }
}

