/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import lombok.NonNull;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.ConfigurableHttpMethods;
import org.springframework.data.rest.core.mapping.ExposureConfiguration;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;

public class ConfigurationApplyingSupportedHttpMethodsAdapter
implements SupportedHttpMethods {
    @NonNull
    private final ExposureConfiguration configuration;
    @NonNull
    private final ResourceMetadata resourceMetadata;
    @NonNull
    private final SupportedHttpMethods delegate;

    @Override
    public HttpMethods getMethodsFor(ResourceType type) {
        HttpMethods methods = this.delegate.getMethodsFor(type);
        return this.configuration.filter(ConfigurableHttpMethods.of(methods), type, this.resourceMetadata);
    }

    @Override
    public HttpMethods getMethodsFor(PersistentProperty<?> property) {
        HttpMethods methodsFor = this.delegate.getMethodsFor(property);
        ResourceMapping mapping = this.resourceMetadata.getMappingFor(property);
        if (!PropertyAwareResourceMapping.class.isInstance(mapping)) {
            return methodsFor;
        }
        ConfigurableHttpMethods methods = ConfigurableHttpMethods.of(methodsFor);
        return this.configuration.filter(methods, (PropertyAwareResourceMapping)PropertyAwareResourceMapping.class.cast(mapping));
    }

    @Override
    public boolean allowsPutForCreation() {
        return this.configuration.allowsPutForCreation(this.resourceMetadata);
    }

    public ConfigurationApplyingSupportedHttpMethodsAdapter(@NonNull ExposureConfiguration configuration, @NonNull ResourceMetadata resourceMetadata, @NonNull SupportedHttpMethods delegate) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration is marked @NonNull but is null");
        }
        if (resourceMetadata == null) {
            throw new IllegalArgumentException("resourceMetadata is marked @NonNull but is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked @NonNull but is null");
        }
        this.configuration = configuration;
        this.resourceMetadata = resourceMetadata;
        this.delegate = delegate;
    }
}

