/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.util.function.Function;
import org.springframework.data.rest.core.mapping.ComposableFilter;
import org.springframework.data.rest.core.mapping.ConfigurableHttpMethods;
import org.springframework.data.rest.core.mapping.ExposureConfigurer;
import org.springframework.data.rest.core.mapping.HttpMethods;
import org.springframework.data.rest.core.mapping.PropertyAwareResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class ExposureConfiguration
implements ExposureConfigurer {
    private ComposableFilter<ResourceMetadata, ConfigurableHttpMethods> collection = ExposureConfigurer.AggregateResourceHttpMethodsFilter.none();
    private ComposableFilter<ResourceMetadata, ConfigurableHttpMethods> item = ExposureConfigurer.AggregateResourceHttpMethodsFilter.none();
    private ComposableFilter<PropertyAwareResourceMapping, ConfigurableHttpMethods> property = ExposureConfigurer.AssociationResourceHttpMethodsFilter.none();
    private Function<Class<?>, Boolean> creationViaPut = __ -> true;

    @Override
    public ExposureConfiguration withCollectionExposure(ExposureConfigurer.AggregateResourceHttpMethodsFilter filter) {
        this.collection = filter;
        return this;
    }

    @Override
    public ExposureConfiguration withItemExposure(ExposureConfigurer.AggregateResourceHttpMethodsFilter filter) {
        this.item = filter;
        return this;
    }

    @Override
    public ExposureConfiguration withAssociationExposure(ExposureConfigurer.AssociationResourceHttpMethodsFilter filter) {
        this.property = filter;
        return this;
    }

    @Override
    public ExposureConfiguration disablePutForCreation() {
        this.creationViaPut = __ -> false;
        return this;
    }

    public ExposureConfigurer forDomainType(Class<?> type) {
        Assert.notNull(type, (String)"Type  must not be null!");
        return new TypeBasedExposureConfigurer(type);
    }

    public ExposureConfiguration disablePutOnItemResources() {
        this.item = this.item.andThen((__, httpMethods) -> httpMethods.disable(HttpMethod.PUT));
        return this;
    }

    public ExposureConfiguration disablePatchOnItemResources() {
        this.item = this.item.andThen((__, httpMethods) -> httpMethods.disable(HttpMethod.PATCH));
        return this;
    }

    public boolean allowsPutForCreation(ResourceMetadata metadata) {
        Assert.notNull((Object)metadata, (String)"ResourceMetadata must not be null!");
        return this.creationViaPut.apply(metadata.getDomainType());
    }

    HttpMethods filter(ConfigurableHttpMethods methods, ResourceType type, ResourceMetadata metadata) {
        switch (type) {
            case COLLECTION: {
                return this.collection.filter(metadata, methods);
            }
            case ITEM: {
                return this.item.filter(metadata, methods);
            }
        }
        throw new IllegalArgumentException();
    }

    HttpMethods filter(ConfigurableHttpMethods methods, PropertyAwareResourceMapping mapping) {
        return this.property.filter(mapping, methods);
    }

    private static <T> ComposableFilter<ResourceMetadata, ConfigurableHttpMethods> withTypeFilter(Class<?> type, ComposableFilter<ResourceMetadata, ConfigurableHttpMethods> function) {
        return (metadata, httpMethods) -> type.isAssignableFrom(metadata.getDomainType()) ? function.filter((ResourceMetadata)metadata, (ConfigurableHttpMethods)httpMethods) : httpMethods;
    }

    private class TypeBasedExposureConfigurer
    implements ExposureConfigurer {
        private final Class<?> type;

        @Override
        public ExposureConfigurer withCollectionExposure(ExposureConfigurer.AggregateResourceHttpMethodsFilter filter) {
            ExposureConfiguration config = ExposureConfiguration.this;
            config.collection = config.collection.andThen(ExposureConfiguration.withTypeFilter(this.type, filter));
            return this;
        }

        @Override
        public ExposureConfigurer withItemExposure(ExposureConfigurer.AggregateResourceHttpMethodsFilter filter) {
            ExposureConfiguration config = ExposureConfiguration.this;
            config.item = config.item.andThen(ExposureConfiguration.withTypeFilter(this.type, filter));
            return this;
        }

        @Override
        public ExposureConfigurer withAssociationExposure(ExposureConfigurer.AssociationResourceHttpMethodsFilter filter) {
            ExposureConfiguration config = ExposureConfiguration.this;
            ExposureConfigurer.AssociationResourceHttpMethodsFilter typeFilter = (mapping, methods) -> this.type.isAssignableFrom(mapping.getProperty().getOwner().getType()) ? filter.filter(mapping, methods) : methods;
            config.property = config.property.andThen(typeFilter);
            return this;
        }

        @Override
        public ExposureConfigurer disablePutForCreation() {
            ExposureConfiguration config = ExposureConfiguration.this;
            Function current = config.creationViaPut;
            config.creationViaPut = type -> this.type.isAssignableFrom((Class<?>)type) ? Boolean.valueOf(false) : (Boolean)current.apply(type);
            return this;
        }

        public TypeBasedExposureConfigurer(Class<?> type) {
            this.type = type;
        }
    }
}

